package net.ibizsys.model.engine.dataentity.logic;


import java.util.Map;

import net.ibizsys.model.dataentity.logic.IPSDELogicParam;
import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;
import net.ibizsys.model.engine.util.IEntity;
import net.ibizsys.model.engine.util.IEntityBase;

public class PSDELogicEntityParamAddin extends PSDELogicParamAddinBase<IPSDELogicEngine<?>, IPSDELogicParam> {

	@Override
	public Object getValue(IPSDELogicSession iDELogicSession){
		Object object;
		try {
			object = iDELogicSession.getParam(this.getPSDELogicParam(), true);
			if (object != null) {
				// 检查类型是否正确
				if (!(object instanceof IEntity)) {
					throw new Exception(String.format("值不是数据对象类型"));
				}
				return object;
			}
		} catch (Exception ex) {
			throw new PSModelEngineAddinException(this, String.format("获取参数值发生异常，%1$s", ex.getMessage()), ex);
		}
		
		// 新建
		if (this.getPSDELogicParam().getParamPSDataEntity() == null) {
			object = this.getUtil().createEntity();
		} else {
			object = this.getUtil().createEntityDTO(this.getPSDELogicParam().getParamPSDataEntity());
		}
		iDELogicSession.setParam(this.getPSDELogicParam(), object);
		return object;
	}

	@Override
	public void bind(IPSDELogicSession iDELogicSession, Object paramObject){
		IEntityBase srcEntity = null;
		if (paramObject != null) {
			if(paramObject instanceof IEntity) {
				srcEntity = (IEntity)paramObject;
			}
			else{
				try {
					Map map = null;
					if(paramObject instanceof Map) {
						map = (Map)paramObject;
					}
					else {
						map = this.getUtil().deserialize(paramObject, Map.class);
					}
					//srcEntity = this.getPSModelEngineHolder().getPSSystemEngine().createEntity(map, !this.getPSDELogicParam().isOriginEntity());
					srcEntity = this.getUtil().createEntity(map);
				}
				catch(Throwable ex) {
					throw new PSModelEngineAddinException(this, String.format("逻辑参数无法绑定非数据对象类型参数"), ex);
				}
			}
		}
		super.bind(iDELogicSession, srcEntity);
	}
	
}
