package net.ibizsys.model.engine.dataentity.logic;

import java.util.LinkedHashMap;
import java.util.Map;

import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;
import net.ibizsys.model.engine.util.IEntity;

/**
 * 数据对象MAP参数运行时对象实现
 * 
 * @author lionlau
 *
 */
public class PSDELogicEntityMapParamAddin extends PSDELogicParamAddinBase {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(PSDELogicEntityMapParamAddin.class);
	
	@Override
	public Object getValue(IPSDELogicSession iDELogicSession) {
		Object object;
		try {
			object = iDELogicSession.getParam(this.getPSDELogicParam(), true);
			if (object != null) {
				// 检查类型是否正确
				if (!(object instanceof Map)) {
					throw new Exception(String.format("值不是数据对象Map类型"));
				}
				return object;
			}
		} catch (Exception ex) {
			throw new PSModelEngineAddinException(this, String.format("获取参数值发生异常，%1$s", ex.getMessage()), ex);
		}
		
		
		
		object = new LinkedHashMap<Object, IEntity>();
		iDELogicSession.setParam(this.getPSDELogicParam(), object);
		return object;
	}

	@Override
	public void bind(IPSDELogicSession iDELogicSession, Object paramObject){
//		Map srcMap = null;
//		if (paramObject != null) {
//			// 检查类型是否正确
//			srcMap = asMap(paramObject);
//			if (srcMap == null) {
//				try {
//					Map map = this.getPSModelEngineHolder().getPSSystemEngine().deserialize(paramObject, Map.class);
//					srcMap = new LinkedHashMap<Object, IEntity>();
//					for(Object key : map.keySet()) {
//						srcMap.put(key, EntityUtils.getValue(map.get(key), !this.getPSDELogicParam().isOriginEntity(), this.getSystemRuntime()));
//					}
//				}
//				catch(Throwable ex) {
//					throw new PSModelEngineException(this, String.format("逻辑参数无法绑定非数据对象Map类型参数"));
//				}
//			}
//		}
//		super.bind(iDELogicSession, srcMap);
		
		throw new PSModelEngineAddinException(this, String.format("绑定参数值发生异常，%1$s", "没有实现"));
	}

	@Override
	public int count(IPSDELogicSession iDELogicSession) {
		Object obj;
		try {
			obj = iDELogicSession.getParam(this.getPSDELogicParam(), true);
			if (obj == null) {
				return 0;
			}
		} catch (Exception ex) {
			throw new PSModelEngineAddinException(this, String.format("获取参数值发生异常，%1$s", ex.getMessage()), ex);
		}

		obj = this.getValue(iDELogicSession);
		if (obj instanceof Map) {
			return ((Map) obj).size();
		}
		return super.count(iDELogicSession);
	}

	@Override
	public void resetAll(IPSDELogicSession iDELogicSession) {
		Object obj;
		try {
			obj = iDELogicSession.getParam(this.getPSDELogicParam(), true);
			if (obj == null) {
				return;
			}
		} catch (Exception ex) {
			throw new PSModelEngineAddinException(this, String.format("获取参数值发生异常，%1$s", ex.getMessage()), ex);
		}
		
		
		obj = this.getValue(iDELogicSession);
		if (obj instanceof Map) {
			((Map)obj).clear();
			return;
		}
		
		super.resetAll(iDELogicSession);
	}

	
	
	
}
