package net.ibizsys.model.engine.dataentity.logic;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelEnums.DELLCondParamType;
import net.ibizsys.model.dataentity.logic.IPSDEEndLogic;
import net.ibizsys.model.dataentity.logic.IPSDELogic;
import net.ibizsys.model.dataentity.logic.IPSDELogicLink;
import net.ibizsys.model.dataentity.logic.IPSDELogicLinkCond;
import net.ibizsys.model.dataentity.logic.IPSDELogicLinkGroupCond;
import net.ibizsys.model.dataentity.logic.IPSDELogicLinkSingleCond;
import net.ibizsys.model.dataentity.logic.IPSDELogicNode;
import net.ibizsys.model.dataentity.logic.IPSDELogicParam;
import net.ibizsys.model.dataentity.logic.IPSDEThrowExceptionLogic;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.PSModelEngineBase;
import net.ibizsys.model.engine.PSModelEngineException;
import net.ibizsys.model.engine.util.ExceptionEntity;
import net.ibizsys.model.engine.util.IAction;
import net.ibizsys.model.engine.util.IEntityBase;
import net.ibizsys.model.engine.util.IExceptionEntity;
import net.ibizsys.model.util.Conditions;
import net.ibizsys.model.util.DataTypeUtils;

public abstract class PSDELogicEngineBase extends PSModelEngineBase implements IPSDELogicEngine {

	private static final Log log = LogFactory.getLog(PSDELogicEngineBase.class);
	
	
	private Map<String, IPSDELogicNodeAddin> psDELogicNodeAddinMap = new LinkedHashMap<>();
	private Map<String, IPSDELogicParamAddin> psPSDELogicParamAddinMap = new LinkedHashMap<>();
//	private IDEScriptLogicRuntime iDEScriptLogicRuntime = null;
//	private int nDebugMode = DELogicDebugModes.NONE;
	private IPSDELogicParamAddin defaultPSDELogicParamAddin = null;
	
	@Override
	public void init(IPSModelEngineHolder iPSModelEngineHolder, String id, IPSModelObject iPSModelObject) throws Exception {
		if (!(iPSModelObject instanceof IPSDELogic)) {
			throw new Exception(String.format("模型类型不正确"));
		}
		super.init(iPSModelEngineHolder, id, iPSModelObject);
	}

	@Override
	public IPSDELogic getPSModelObject() {
		return (IPSDELogic) super.getPSModelObject();
	}
	
	
//	@Override
//	public void init(IDataEntityRuntimeBaseContext iDataEntityRuntimeBaseContext, IPSDELogic iPSDELogic) throws Exception {
//		
//		this.setDataEntityRuntimeBase(iDataEntityRuntimeBaseContext.getDataEntityRuntime());
//		this.iDataEntityRuntimeBaseContext = iDataEntityRuntimeBaseContext;
//		this.iPSDELogic = iPSDELogic;
//		this.setDebugMode(this.getPSDELogic().getDebugMode());
//		this.onInit();
//	}
	
	@Override
	protected void onInit() throws Exception {
		
		List<IPSDELogicParam> psDELogicParamList = getPSDELogic().getPSDELogicParams();
		if(psDELogicParamList != null) {
			for(IPSDELogicParam iPSDELogicParam : psDELogicParamList) {
				if(!StringUtils.hasLength(iPSDELogicParam.getCodeName())) {
					throw new Exception(String.format("逻辑参数[%1$s]未指定代码标识", iPSDELogicParam.getName()));
				}
//				if(iPSDELogicParam.getParamPSDataEntity() != null) {
//					IDataEntityRuntime iDataEntityRuntime = null;
//					if(iPSDELogicParam.getParamPSDataEntity().getId().equals(this.getDataEntityRuntime().getId())) {
//						iDataEntityRuntime = this.getDataEntityRuntime();
//					}
//					else {
//						iDataEntityRuntime = this.getSystemRuntime().getDataEntityRuntime(iPSDELogicParam.getParamPSDataEntity().getId(), false);
//					}
//					paramDataEntityRuntimeMap.put(iPSDELogicParam.getCodeName(), iDataEntityRuntime);
//				}
				IPSDELogicParamAddin iPSDELogicParamAddin = this.getPSModelEngineHolder().getPSModelEngineAddin(this, iPSDELogicParam, IPSDELogicParamAddin.class);
				psPSDELogicParamAddinMap.put(iPSDELogicParam.getCodeName().toUpperCase(), iPSDELogicParamAddin);
				
				if(iPSDELogicParam.isDefault()) {
					if(this.getDefaultPSDELogicParamAddin()!=null) {
						throw new Exception(String.format("存在多个默认逻辑参数"));
					}
					this.setDefaultPSDELogicParamAddin(iPSDELogicParamAddin);
				}
			}
		}
		
		if(this.getPSDELogic().isCustomCode()) {
//			String strScriptCode = this.getPSDELogic().getScriptCode();
//			if(StringUtils.isEmpty(this.getPSDELogic().getScriptCode())) {
//				throw new Exception("未指定自定义脚本代码");
//			}
//			this.iDEScriptLogicRuntime = this.getDataEntityRuntimeBase().getDEScriptLogicRuntime(IDEScriptLogicRuntime.LOGICMODE_DELOGIC, strScriptCode);
			throw new Exception("未支持");
		}
		else {
			//建立各节点运行时对象
			List<IPSDELogicNode> psDELogicNodeList = this.getPSDELogic().getPSDELogicNodes();
			if(psDELogicNodeList != null) {
				for(IPSDELogicNode iPSDELogicNode : psDELogicNodeList) {
					IPSDELogicNodeAddin iPSDELogicNodeAddin = this.getPSModelEngineHolder().getPSModelEngineAddin(this, iPSDELogicNode, IPSDELogicNodeAddin.class);
//					if(iPSDELogicNodeAddin == null) {
//						//throw new PSModelEngineException(this, String.format("无法建立逻辑节点[%1$s][%2$s]运行时对象", iPSDELogicNode.getName(), iPSDELogicNode.getLogicNodeType()));
//						throw new Exception(String.format("无法建立逻辑节点[%1$s][%2$s]运行时对象", iPSDELogicNode.getName(), iPSDELogicNode.getLogicNodeType()));
//					}
					psDELogicNodeAddinMap.put(iPSDELogicNode.getCodeName().toUpperCase(), iPSDELogicNodeAddin);
				}
			}
			
			this.getPSDELogic().getStartPSDELogicNodeMust();
		}
		
		
		
		super.onInit();
	}
	
//	protected IDEScriptLogicRuntime getDEScriptLogicRuntime() {
//		return this.iDEScriptLogicRuntime;
//	}
//	
//	protected IDELogicRuntimeContext getDELogicRuntimeContext() {
//		return this.iDELogicRuntimeContext;
//	}
//	
//	protected IDataEntityRuntimeBaseContext getDataEntityRuntimeContext() {
//		return iDataEntityRuntimeBaseContext;
//	}

	protected IPSDELogicNodeAddin getPSDELogicNodeAddin(IPSDELogicNode iPSDELogicNode) {
		IPSDELogicNodeAddin iPSDELogicNodeAddin = null;
		try {
			iPSDELogicNodeAddin = this.getPSDELogicNodeAddin(iPSDELogicNode.getCodeName(), true);
		} catch (Throwable ex) {
			log.debug(ex);
		}
		if(iPSDELogicNodeAddin == null) {
			throw new PSModelEngineException(this, String.format("无法获取逻辑节点[%1$s][%2$s]运行时对象", iPSDELogicNode.getName(), iPSDELogicNode.getLogicNodeType()));
		}
		return iPSDELogicNodeAddin;
	}
	


	
	@Override
	public IPSDELogicParamAddin getPSDELogicParamAddin(String strName, boolean bTryMode) {
		IPSDELogicParamAddin iPSDELogicParamAddin =  psPSDELogicParamAddinMap.get(strName.toUpperCase());
		if(iPSDELogicParamAddin != null || bTryMode) {
			return iPSDELogicParamAddin;
		}
		throw new PSModelEngineException(this, String.format("未存在指定参数[%1$s]", strName));
	}
	
	@Override
	public IPSDELogicNodeAddin getPSDELogicNodeAddin(String strName, boolean bTryMode) {
		IPSDELogicNodeAddin iPSDELogicNodeAddin =  psDELogicNodeAddinMap.get(strName.toUpperCase());
		if(iPSDELogicNodeAddin != null || bTryMode) {
			return iPSDELogicNodeAddin;
		}
		throw new PSModelEngineException(this, String.format("未存在指定节点[%1$s]", strName));
	}

	
	@Override
	public Object execute(Object[] args) {
		return this.executeAction("执行逻辑", new IAction<Object>() {
			@Override
			public Object execute(Object[] args) throws Throwable {
				return onExecute(args);
			}
		}, args);
		
	}
	
	protected Object onExecute(Object[] args) throws Throwable {
		if(args == null || args.length == 0) {
			throw new Exception(String.format("传入参数无效"));
		}
		
		IEntityBase iEntity = null;
		if(args[0] instanceof IEntityBase) {
			iEntity = (IEntityBase)args[0];
		}
		if(iEntity == null) {
			throw new PSModelEngineException(this, String.format("传入参数无效"));
		}
		
//		if(this.getDEScriptLogicRuntime() != null) {
//			return this.getDEScriptLogicRuntime().execute(args);
//		}
//		else {
		if(true) {
			IPSDELogicSession iPSDELogicSession = this.createPSDELogicSession();
			List<IPSDELogicParam> psDELogicParamList = getPSDELogic().getPSDELogicParams();
			if(psDELogicParamList != null && psDELogicParamList.size() > 0) {
				for(IPSDELogicParam iPSDELogicParam : psDELogicParamList) {
					if(iPSDELogicParam.isDefault()) {
						iPSDELogicSession.setParam(iPSDELogicParam, iEntity);
						continue;
					}
					
					if(iPSDELogicParam.isLastReturnParam()
							|| iPSDELogicParam.isFilterParam()
							|| iPSDELogicParam.isEntityListParam()
							|| iPSDELogicParam.isEntityPageParam()
							|| iPSDELogicParam.isFileParam()
							|| iPSDELogicParam.isFileListParam()
							|| iPSDELogicParam.isSimpleParam()
							|| iPSDELogicParam.isSimpleListParam()) {
						continue;
					}
					
					if(iPSDELogicParam.isLastParam()) {
//						Object lastEntity = this.getDataEntityRuntime().getLastEntity();
//						if(lastEntity instanceof IEntity) {
//							iPSDELogicSession.setParam(strParamName, (IEntity)lastEntity);
//						}
//						continue;
						throw new Exception("没有实现");
						
					}
					
					if(iPSDELogicParam.isSessionParam()) {
//						String strSessionTag = String.format("DELOGIC_%1$s", strParamName);
//						Object objParam = ActionSessionManager.getCurrentSessionMust().getActionParam(strSessionTag);
//						if(objParam == null) {
//							objParam = new SimpleEntity();
//							ActionSessionManager.getCurrentSessionMust().setActionParam(strSessionTag, objParam);
//						}
//						if(objParam instanceof IEntity) {
//							iPSDELogicSession.setParam(strParamName, (IEntity)objParam);
//						}
						continue;
					}
					
					if(iPSDELogicParam.isEnvParam()) {
						//iPSDELogicSession.setParam(strParamName, ActionSessionManager.getCurrentSessionMust().getEnvEntity(true));
						continue;
					}
					
//					if(iPSDELogicParam.getParamPSDataEntity() != null) {
//						IDataEntityRuntime iDataEntityRuntime = paramDataEntityRuntimeMap.get(strParamName);
//						iPSDELogicSession.setParam(strParamName, iDataEntityRuntime.createEntity());
//					}
//					else {
//						iPSDELogicSession.setParam(strParamName, this.getSystemRuntime().createEntity());
//					}
				}
			}
			
			//进行参数准备
			IPSDELogicSession lastDELogicSession = PSDELogicSessionHolder.getCurrent();
			try {
				PSDELogicSessionHolder.setCurrent(iPSDELogicSession);
				this.beginSession(iPSDELogicSession);
				this.executePSDELogicNode(iPSDELogicSession, this.getPSDELogic().getStartPSDELogicNodeMust());
				this.endSession(iPSDELogicSession);
				this.outputDebugInfo(iPSDELogicSession, null);
				PSDELogicSessionHolder.setCurrent(lastDELogicSession);
			}
			catch(Throwable ex) {
				this.endSession(iPSDELogicSession);
				outputDebugInfo(iPSDELogicSession, ex);
				PSDELogicSessionHolder.setCurrent(lastDELogicSession);
				throw ex;
			}
			
			
			return iPSDELogicSession.getResult();
		}
		else {
			return null;
		}
		
	}
	
	protected void beginSession(IPSDELogicSession iPSDELogicSession) throws Throwable{
		if(this.psPSDELogicParamAddinMap != null) {
			for(IPSDELogicParamAddin iPSDELogicParamAddin:this.psPSDELogicParamAddinMap.values()) {
				iPSDELogicParamAddin.beginSession(iPSDELogicSession);
			}
		}
	}
	
	protected void endSession(IPSDELogicSession iPSDELogicSession){
		if(this.psPSDELogicParamAddinMap != null) {
			for(IPSDELogicParamAddin iPSDELogicParamAddin:this.psPSDELogicParamAddinMap.values()) {
				iPSDELogicParamAddin.endSession(iPSDELogicSession);
			}
		}
	}
	
	
	protected void executePSDELogicNode(IPSDELogicSession iPSDELogicSession, IPSDELogicNode iPSDELogicNode) throws Throwable{
		onExecutePSDELogicNode(iPSDELogicSession, iPSDELogicNode);
	}
	
	protected void onExecutePSDELogicNode(IPSDELogicSession iPSDELogicSession, IPSDELogicNode iPSDELogicNode) throws Throwable{
		this.onExecutePSDELogicNode(iPSDELogicSession, iPSDELogicNode, true);
	}
	
	protected void onExecutePSDELogicNode(IPSDELogicSession iPSDELogicSession, IPSDELogicNode iPSDELogicNode, boolean bExecuteLink) throws Throwable{
		
		IPSDELogicNodeAddin iPSDELogicNodeAddin = this.getPSDELogicNodeAddin(iPSDELogicNode);
		iPSDELogicSession.debugEnterNode(iPSDELogicNode);
		
		Throwable exception = null;
		try {
			iPSDELogicNodeAddin.execute(iPSDELogicSession);
			if(iPSDELogicNode instanceof IPSDEEndLogic) {
				iPSDELogicSession.debugExitNode(iPSDELogicNode);
				return;
			}
			
			
		}
		catch(Throwable ex) {
			if(iPSDELogicNode instanceof IPSDEThrowExceptionLogic) {
				throw ex;
			}
			exception = ex;
		}
		
		if(!bExecuteLink) {
			if(exception != null) {
				throw exception;
			}
			return;
		}
		
		
		List<IPSDELogicLink> psDELogicLinkList = iPSDELogicNode.getPSDELogicLinks();
		if(exception == null) {
			if(psDELogicLinkList != null && psDELogicLinkList.size() > 0) {
				Object lastReturn = iPSDELogicSession.getLastReturn();
				boolean bParallelOutput = iPSDELogicNode.isParallelOutput();
				if(bParallelOutput) {
					int nCount = 0;
					for(IPSDELogicLink iPSDELogicLink : psDELogicLinkList) {
						if(iPSDELogicLink.isCatchLink()
								|| iPSDELogicLink.isSubCallLink()) {
							continue;
						}
						nCount++;
					}
					if(nCount <= 1) {
						bParallelOutput = false;
					}
				}
				
				for(IPSDELogicLink iPSDELogicLink : psDELogicLinkList) {
					if(iPSDELogicLink.isCatchLink()
							|| iPSDELogicLink.isSubCallLink()) {
						continue;
					}
					if(iPSDELogicLink.getPSDELogicLinkGroupCond() == null 
							|| iPSDELogicLink.getPSDELogicLinkGroupCond().getPSDELogicLinkConds() == null) {
						iPSDELogicSession.debugEnterLink(iPSDELogicNode, iPSDELogicLink);
						if(!bParallelOutput) {
							iPSDELogicSession.debugExitNode(iPSDELogicNode);
						}
						iPSDELogicSession.setLastReturn(lastReturn);
						this.executePSDELogicNode(iPSDELogicSession, iPSDELogicLink.getDstPSDELogicNodeMust());
						if(!bParallelOutput) {
							return;
						}
						continue;
					}
					else if(testPSDELogicLinkCond(iPSDELogicSession, iPSDELogicLink.getPSDELogicLinkGroupCond())){
						iPSDELogicSession.debugEnterLink(iPSDELogicNode, iPSDELogicLink);
						if(!bParallelOutput) {
							iPSDELogicSession.debugExitNode(iPSDELogicNode);
						}
						iPSDELogicSession.setLastReturn(lastReturn);
						this.executePSDELogicNode(iPSDELogicSession, iPSDELogicLink.getDstPSDELogicNodeMust());
						if(!bParallelOutput) {
							return;
						}
						continue;
					}
				}
			}
		}
		else {
			if(psDELogicLinkList != null && psDELogicLinkList.size() > 0) {
				
				IExceptionEntity iExceptionEntity = null;
				
				for(IPSDELogicLink iPSDELogicLink : psDELogicLinkList) {
					if(!iPSDELogicLink.isCatchLink()) {
						continue;
					}
					
					if(iExceptionEntity == null) {
						iExceptionEntity = ExceptionEntity.from(exception);
						iPSDELogicSession.setLastReturn(iExceptionEntity);
					}
					
					if(iPSDELogicLink.getPSDELogicLinkGroupCond() == null 
							|| iPSDELogicLink.getPSDELogicLinkGroupCond().getPSDELogicLinkConds() == null) {
						iPSDELogicSession.debugInfo(exception.getMessage());
						exception = null;
						iPSDELogicSession.debugEnterLink(iPSDELogicNode, iPSDELogicLink);
						iPSDELogicSession.debugExitNode(iPSDELogicNode);
						this.executePSDELogicNode(iPSDELogicSession, iPSDELogicLink.getDstPSDELogicNodeMust());
						return;
					}
					else if(testPSDELogicLinkCond(iPSDELogicSession, iPSDELogicLink.getPSDELogicLinkGroupCond())){
						iPSDELogicSession.debugInfo(exception.getMessage());
						exception = null;
						iPSDELogicSession.debugEnterLink(iPSDELogicNode, iPSDELogicLink);
						iPSDELogicSession.debugExitNode(iPSDELogicNode);
						this.executePSDELogicNode(iPSDELogicSession, iPSDELogicLink.getDstPSDELogicNodeMust());
						return;
					}
				}
			}
			
			if(exception != null) {
				throw exception;
			}
		}
		
		iPSDELogicSession.debugExitNode(iPSDELogicNode);
		
	}
	
	protected boolean testPSDELogicLinkCond(IPSDELogicSession iPSDELogicSession, IPSDELogicLinkCond iPSDELogicLinkCond) throws Throwable{
		if(iPSDELogicLinkCond instanceof IPSDELogicLinkGroupCond) {
			IPSDELogicLinkGroupCond iPSDELogicLinkGroupCond = (IPSDELogicLinkGroupCond)iPSDELogicLinkCond;
			boolean bRet = true;
			if(iPSDELogicLinkGroupCond.getGroupOP().equals(Conditions.AND)) {
				if(iPSDELogicLinkGroupCond.getPSDELogicLinkConds() != null && iPSDELogicLinkGroupCond.getPSDELogicLinkConds().size()>0) {
					bRet = true;
					for(IPSDELogicLinkCond childPSDELogicLinkCond : iPSDELogicLinkGroupCond.getPSDELogicLinkConds()) {
						if(!testPSDELogicLinkCond(iPSDELogicSession, childPSDELogicLinkCond)) {
							bRet = false;
							break;
						}
					}
				}
			}
			else
				if(iPSDELogicLinkGroupCond.getGroupOP().equals(Conditions.OR)) {
					if(iPSDELogicLinkGroupCond.getPSDELogicLinkConds() != null && iPSDELogicLinkGroupCond.getPSDELogicLinkConds().size()>0) {
						bRet = false;
						for(IPSDELogicLinkCond childPSDELogicLinkCond : iPSDELogicLinkGroupCond.getPSDELogicLinkConds()) {
							if(testPSDELogicLinkCond(iPSDELogicSession, childPSDELogicLinkCond)) {
								bRet = true;
								break;
							}
						}
					}
				}
				else
					throw new PSModelEngineException(this, String.format("连接条件[%1$s]组逻辑操作[%2$s]无效", iPSDELogicLinkCond.getName(), iPSDELogicLinkGroupCond.getGroupOP()));
			
			if(iPSDELogicLinkGroupCond.isNotMode()) {
				bRet = !bRet;
			}
			return bRet;
		}
		if(iPSDELogicLinkCond instanceof IPSDELogicLinkSingleCond) {
			IPSDELogicLinkSingleCond iPSDELogicLinkSingleCond = (IPSDELogicLinkSingleCond)iPSDELogicLinkCond;
			IPSDELogicParamAddin dstPSDELogicParamAddin = this.getPSDELogicParamAddin(iPSDELogicLinkSingleCond.getDstLogicParamMust().getCodeName(), false);
//			IEntity iEntity = iPSDELogicSession.getParam(iPSDELogicLinkSingleCond.getDstLogicParamMust().getCodeName());
//			if(iEntity == null) {
//				throw new PSModelEngineException(this, String.format("连接条件[%1$s]指定目标参数对象[%2$s]无效", iPSDELogicLinkCond.getName(), iPSDELogicLinkSingleCond.getDstLogicParamMust().getCodeName()));
//			}
			Object objValue = null;
			String strDstFieldName = iPSDELogicLinkSingleCond.getDstFieldName();
			if(StringUtils.isEmpty(strDstFieldName)) {
				//throw new PSModelEngineException(this, String.format("连接条件[%1$s]指定目标参数属性无效", iPSDELogicLinkCond.getName()));
				objValue = dstPSDELogicParamAddin.getValue(iPSDELogicSession);
			}
			else{
				objValue = dstPSDELogicParamAddin.get(iPSDELogicSession, strDstFieldName.toLowerCase());
			}
			Object dstValue = iPSDELogicLinkSingleCond.getParamValue();
			String strParamType = iPSDELogicLinkSingleCond.getParamType();
			if(StringUtils.hasLength(strParamType)) {
				if(StringUtils.isEmpty(dstValue)) {
					throw new Exception(String.format("连接条件[%1$s]未指定参数项名称", iPSDELogicLinkCond.getName()));
				}
				if(strParamType.equals(DELLCondParamType.ENTITYFIELD.value)) {
					//dstValue = iEntity.get(((String)dstValue).toLowerCase());
					dstValue =  dstPSDELogicParamAddin.get(iPSDELogicSession, ((String)dstValue).toLowerCase());
				}
				else
					if(strParamType.equals(DELLCondParamType.CURTIME.value)) {
						dstValue = new java.sql.Timestamp(System.currentTimeMillis());
					}
					else
						if(strParamType.equals(DELLCondParamType.SRCENTITYFIELD.value)) {
							IPSDELogicParamAddin srcPSDELogicParamAddin = this.getPSDELogicParamAddin(iPSDELogicLinkSingleCond.getSrcLogicParamMust().getCodeName(), false);
							dstValue =  srcPSDELogicParamAddin.get(iPSDELogicSession, ((String)dstValue).toLowerCase());
						}
						else
							if(strParamType.equals(DELLCondParamType.SRCDLPARAM.value)) {
								IPSDELogicParamAddin srcPSDELogicParamAddin = this.getPSDELogicParamAddin(iPSDELogicLinkSingleCond.getSrcLogicParamMust().getCodeName(), false);
								dstValue =  srcPSDELogicParamAddin.getValue(iPSDELogicSession);
							}
			}
			return testValueCond(objValue, iPSDELogicLinkSingleCond.getCondOP(), dstValue);
		}
		
		throw new Exception(String.format("无法识别连接条件[%1$s][%2$s]", iPSDELogicLinkCond.getName(), iPSDELogicLinkCond.getLogicType()));
	}
	
	/**
	 * 测试条件是否成立
	 * 
	 * @param objSrcValue
	 * @param strOP
	 * @param strDstValue
	 * @return
	 * @throws Exception
	 */
	protected boolean testValueCond(Object objSrcValue, String strOP, Object objDstValue) throws Exception {
		return DataTypeUtils.testCond(objSrcValue, strOP, objDstValue);
	}
	
	/**
	 * 测试条件是否成立，等同testValueCond
	 * @param objSrcValue
	 * @param strOP
	 * @param objDstValue
	 * @return
	 * @throws Exception
	 */
	protected boolean test(Object objSrcValue, String strOP, Object objDstValue) throws Exception {
		return testValueCond(objSrcValue, strOP, objDstValue);
	}
	
	protected IPSDELogicSession createPSDELogicSession() {
		return new PSDELogicSession(this);
	}



	@Override
	public IPSDELogicParamAddin getDefaultPSDELogicParamAddin() {
		return this.defaultPSDELogicParamAddin;
	}
	
	protected void setDefaultPSDELogicParamAddin(IPSDELogicParamAddin defaultPSDELogicParamAddin) {
		this.defaultPSDELogicParamAddin = defaultPSDELogicParamAddin;
	}
	
	protected void outputDebugInfo(IPSDELogicSession iPSDELogicSession, Throwable ex) {
//		if(iPSDELogicSession.getDebugData() != null) {
//			String strDebugInfo = null;
//			if(ex==null) {
//				strDebugInfo = String.format("实体[%1$s]处理逻辑[%2$s]\r\n%3$s", this.getDataEntityRuntimeBase().getName(), this.getPSDELogic().getName(),
//						iPSDELogicSession.getDebugArrayNode().toString());
//			}
//			else {
//				String strException = ex.getMessage();
//				if(StringUtils.hasLength(strException)) {
//					strException = strException.replace("\r\n"," ");
//				}
//				strDebugInfo = String.format("实体[%1$s]处理逻辑[%2$s]发生异常，%3$s\r\n%4$s", this.getDataEntityRuntimeBase().getName(), this.getPSDELogic().getName(),
//						strException, iPSDELogicSession.getDebugArrayNode().toString());
//			}
//		
//			if(ex == null) {
//				log.debug(strDebugInfo);	
//				//this.getDELogicRuntimeContext().getSystemRuntime().log(ISystemUtilRuntime.LOGLEVEL_INFO, LogCats.DELOGIC, strDebugInfo, iPSDELogicSession.getDebugArrayNode());
//			}
//			else {
//				log.error(strDebugInfo, ex);
//				//this.getDELogicRuntimeContext().getSystemRuntime().log(ISystemUtilRuntime.LOGLEVEL_ERROR, LogCats.DELOGIC, strDebugInfo, iPSDELogicSession.getDebugArrayNode());
//			}
//		}
	}
	
	
	
//	
//	/**
//	 * 建立实体脚本逻辑运行时对象
//	 * @param strScriptCode
//	 * @return
//	 */
//	public IDELogicScriptNodeRuntime createDELogicScriptNodeRuntime(String strScriptCode, String strMode) {
//		return new PSDELogicScriptNodeAddin();
//	}
//	
//	protected IDELogicScriptNodeRuntime getDEScriptLogicRuntime(IPSDELogicNode iPSDELogicNode, String strScriptCode, String strMode, boolean bTryMode) {
//		String strLogicTag = String.format("%1$s|%2$s|%3$s", iPSDELogicNode.getCodeName(), strScriptCode, strMode);
//		IDELogicScriptNodeRuntime iDELogicScriptNodeRuntime = this.deLogicScriptNodeRuntimeMap.get(strLogicTag.hashCode());
//		if(iDELogicScriptNodeRuntime != null || bTryMode ) {
//			return iDELogicScriptNodeRuntime;
//		}
//			
//		String strCodeType = null;
//		if(iPSDELogicNode instanceof IPSDERawCodeLogic) {
//			IPSDERawCodeLogic iPSDERawCodeLogic = (IPSDERawCodeLogic)iPSDELogicNode;
//			strCodeType = iPSDERawCodeLogic.getCodeType();
//		}
//		
//		
//		
//		iDELogicScriptNodeRuntime = createDELogicScriptNodeRuntime(strScriptCode, strMode);
//		try {
//			iDELogicScriptNodeRuntime.init(getSystemRuntime().getSystemRTScriptContext(), this.getPSDELogicNodeAddin(iPSDELogicNode), strCodeType, strScriptCode, strMode);
//		} catch (Exception e) {
//			log.error(String.format("初始化实体处理逻辑脚本节点逻辑运行时对象发生异常，%1$s",e.getMessage()),e);
//			throw new DataEntityRuntimeException(this.getDataEntityRuntime(), String.format("初始化实体处理逻辑脚本节点逻辑运行时对象发生异常，%1$s",e.getMessage()), e);
//		}
//		this.deLogicScriptNodeRuntimeMap.put(strLogicTag.hashCode(), iDELogicScriptNodeRuntime);
//		return iDELogicScriptNodeRuntime;
//	}
//	
	
}
