package net.ibizsys.model.engine.dataentity.logic;

import org.springframework.util.StringUtils;

import net.ibizsys.model.PSModelEnums.LogicReturnType;
import net.ibizsys.model.dataentity.logic.IPSDEEndLogic;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.util.DataTypeUtils;
import net.ibizsys.model.util.DataTypes;

/**
 * 实体结束节点运行时对象
 * @author lionlau
 *
 */
public class PSDELogicEndNodeAddin extends PSDELogicNodeAddinBase{

	@Override
	public void init(IPSModelEngineHolder iPSModelEngineHolder, IPSModelEngine iPSModelEngine, Object data) throws Exception {
		if (!(data instanceof IPSDEEndLogic)) {
			throw new Exception(String.format("模型类型不正确"));
		}
		super.init(iPSModelEngineHolder, iPSModelEngine, data);
	}

	@Override
	public IPSDEEndLogic getPSDELogicNode() {
		return (IPSDEEndLogic) super.getPSDELogicNode();
	}

	@Override
	protected void onExecute(IPSDELogicSession iPSDELogicSession) throws Throwable {
		
		IPSDEEndLogic iPSDEEndLogic = getPSDELogicNode();
		
		String strReturnType = iPSDEEndLogic.getReturnType();
		if(!StringUtils.hasLength(strReturnType)
				|| LogicReturnType.NONEVALUE.value.equals(strReturnType)
				|| LogicReturnType.NULLVALUE.value.equals(strReturnType)) {
			iPSDELogicSession.setResult(null);
			return;
		}
		
		if(LogicReturnType.SRCVALUE.value.equals(strReturnType)) {
			if(iPSDEEndLogic.getRawValueStdDataType() == DataTypes.UNKNOWN) {
				iPSDELogicSession.setResult(iPSDEEndLogic.getRawValue());
			}
			else {
				iPSDELogicSession.setResult(DataTypeUtils.parse(iPSDEEndLogic.getRawValueStdDataType(), iPSDEEndLogic.getRawValue()));
			}
			
			return;
		}
				
		if(LogicReturnType.BREAK.value.equals(strReturnType)) {
			iPSDELogicSession.setResult(IPSDELogicEngine.BREAK_VALUE);
			return;
		}		
		
		if(LogicReturnType.LOGICPARAM.value.equals(strReturnType)
				|| LogicReturnType.LOGICPARAMFIELD.value.equals(strReturnType)) {
			IPSDELogicParamAddin iDELogicParamRuntime= iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDEEndLogic.getReturnParamMust().getCodeName(), false);
			if(LogicReturnType.LOGICPARAM.value.equals(strReturnType)) {
				iPSDELogicSession.setResult(iDELogicParamRuntime.getValue(iPSDELogicSession));
			}
			else {
				iPSDELogicSession.setResult(iDELogicParamRuntime.get(iPSDELogicSession, iPSDEEndLogic.getDstFieldName()));
			}
			return;
		}
		
		throw new Exception(String.format("无法识别的返回值类型[%1$s]", strReturnType));
		
	}
	
}
