package net.ibizsys.model.engine.dataentity.logic;

import java.util.List;

import org.springframework.util.ObjectUtils;

import net.ibizsys.model.dataentity.logic.IPSDEDebugParamLogic;
import net.ibizsys.model.dataentity.logic.IPSDELogicParam;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineHolder;

/**
 * 实体调试输出逻辑参数节点运行时对象
 * @author lionlau
 *
 */
public class PSDELogicDebugParamNodeAddin extends PSDELogicNodeAddinBase{

	@Override
	public void init(IPSModelEngineHolder iPSModelEngineHolder, IPSModelEngine iPSModelEngine, Object data) throws Exception {
		if (!(data instanceof IPSDEDebugParamLogic)) {
			throw new Exception(String.format("模型类型不正确"));
		}
		super.init(iPSModelEngineHolder, iPSModelEngine, data);
	}

	@Override
	public IPSDEDebugParamLogic getPSDELogicNode() {
		return (IPSDEDebugParamLogic) super.getPSDELogicNode();
	}

	@Override
	protected void onExecute(IPSDELogicSession iPSDELogicEngineSession) throws Throwable {
		
		IPSDEDebugParamLogic iPSDEDebugParamLogic = getPSDELogicNode();
		
		
		if(iPSDEDebugParamLogic.getDstPSDELogicParam() != null) {
			iPSDELogicEngineSession.debugParam(iPSDEDebugParamLogic.getDstPSDELogicParam());
		}
		else {
			//未指定时输出全部参数
			List<IPSDELogicParam> psDELogicParamList = iPSDELogicEngineSession.getPSDELogicEngine().getPSDELogic().getPSDELogicParams();
			if(!ObjectUtils.isEmpty(psDELogicParamList)) {
				for(IPSDELogicParam iPSDELogicParam : psDELogicParamList) {
					iPSDELogicEngineSession.debugParam(iPSDELogicParam);
				}
			}
		}
	}
	
}
