package net.ibizsys.model.engine.dataentity.logic;

import net.ibizsys.model.dataentity.logic.IPSDEDENotifyLogic;
import net.ibizsys.model.dataentity.notify.IPSDENotify;
import net.ibizsys.model.engine.dataentity.notify.IPSDENotifyEngine;

/**
 * 实体调用实体通知节点运行时对象
 * @author lionlau
 *
 */
public class PSDELogicDENotifyNodeAddin extends PSDELogicNodeAddinBase<IPSDELogicEngine<?>, IPSDEDENotifyLogic>{

//	@Override
//	public void init(IPSModelEngineHolder iPSModelEngineHolder, IPSModelEngine iPSModelEngine, Object data) throws Exception {
//		if (!(data instanceof IPSDEDENotifyLogic)) {
//			throw new Exception(String.format("模型类型不正确"));
//		}
//		super.init(iPSModelEngineHolder, iPSModelEngine, data);
//	}
//
//	@Override
//	public IPSDEDENotifyLogic getPSDELogicNode() {
//		return (IPSDEDENotifyLogic) super.getPSDELogicNode();
//	}


	@Override
	protected void onExecute(IPSDELogicSession iPSDELogicSession) throws Throwable {
		
		IPSDEDENotifyLogic iPSDEDENotifyLogic = getPSDELogicNode();
		
		Object objParam = iPSDELogicSession.getLogicParamValue(iPSDEDENotifyLogic.getDstPSDELogicParamMust().getCodeName());
	
		
		if(iPSDELogicSession.isOutputDebugInfo()) {
			iPSDELogicSession.debugInfo(String.format("通知参数[%1$s] ==> %2$s", iPSDEDENotifyLogic.getDstPSDELogicParamMust().getCodeName(), objParam));
		}
		
		IPSDENotify dstPSDENotify = iPSDEDENotifyLogic.getDstPSDENotifyMust();
		IPSDENotifyEngine dstPSDENotifyEngine = this.getPSModelEngineHolder().getPSModelEngine(dstPSDENotify, IPSDENotifyEngine.class);
		
		dstPSDENotifyEngine.send(PSDELogicParamAddin.asObjects(objParam));
		
		if(iPSDELogicSession.isOutputDebugInfo()) {
			iPSDELogicSession.debugInfo(String.format("调用通知[%1$s]", dstPSDENotify.getName()));
		}
		
		iPSDELogicSession.setLastReturn(null);
		
	}
	
}
