package net.ibizsys.model.engine.dataentity.logic;

import java.util.List;

import net.ibizsys.model.dataentity.logic.IPSDEDELogicLogic;
import net.ibizsys.model.dataentity.logic.IPSDELogic;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineHolder;

/**
 * 实体调用实体处理逻辑节点运行时对象
 * @author lionlau
 *
 */
public class PSDELogicDELogicNodeAddin extends PSDELogicNodeAddinBase{

	@Override
	public void init(IPSModelEngineHolder iPSModelEngineHolder, IPSModelEngine iPSModelEngine, Object data) throws Exception {
		if (!(data instanceof IPSDEDELogicLogic)) {
			throw new Exception(String.format("模型类型不正确"));
		}
		super.init(iPSModelEngineHolder, iPSModelEngine, data);
	}

	@Override
	public IPSDEDELogicLogic getPSDELogicNode() {
		return (IPSDEDELogicLogic) super.getPSDELogicNode();
	}

	@Override
	protected void onExecute(IPSDELogicSession iPSDELogicSession) throws Throwable {
		
		IPSDEDELogicLogic iPSDEDELogicLogic = getPSDELogicNode();
		
		Object objParam = iPSDELogicSession.getLogicParamValue(iPSDEDELogicLogic.getDstPSDELogicParamMust().getCodeName());
		if(iPSDELogicSession.isOutputDebugInfo()) {
			iPSDELogicSession.debugInfo(String.format("逻辑参数[%1$s] ==> %2$s", iPSDEDELogicLogic.getDstPSDELogicParamMust().getCodeName(), objParam));
		}
		IPSDELogic dstPSDELogic = iPSDEDELogicLogic.getDstPSDELogicMust();
		
		IPSDELogicEngine dstPSDELogicEngine = this.getPSModelEngineHolder().getPSModelEngine(dstPSDELogic, IPSDELogicEngine.class);
				
		List list = PSDELogicParamAddin.asList(objParam);
		if(list != null) {
			Object objRet = null;
			for(Object item : list) {
				objRet = dstPSDELogicEngine.execute(new Object[] {item});
				
				if(iPSDELogicSession.isOutputDebugInfo()) {
					iPSDELogicSession.debugInfo(String.format("调用逻辑[%1$s][%2$s] ==> %3$s", dstPSDELogic.getName(), item, objRet));
				}
				
				if(IPSDELogicEngine.BREAK_VALUE == objRet) {
					break;
				}
			}
			
			
			
			iPSDELogicSession.setLastReturn(objRet);
		}
		else {
			Object objRet = dstPSDELogicEngine.execute(new Object[] {objParam});
			
			if(iPSDELogicSession.isOutputDebugInfo()) {
				iPSDELogicSession.debugInfo(String.format("调用逻辑[%1$s] ==> %2$s", dstPSDELogic.getName(), objRet));
			}
			
			iPSDELogicSession.setLastReturn(objRet);
		}
	}
	
}
