package net.ibizsys.model.engine.dataentity.logic;

import net.ibizsys.model.dataentity.datasync.IPSDEDataSync;
import net.ibizsys.model.dataentity.logic.IPSDEDEDataSyncLogic;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.dataentity.datasync.IPSDEDataSyncEngine;

/**
 * 实体调用实体数据同步节点运行时对象
 * @author lionlau
 *
 */
public class PSDELogicDEDataSyncNodeAddin extends PSDELogicNodeAddinBase{

	@Override
	public void init(IPSModelEngineHolder iPSModelEngineHolder, IPSModelEngine iPSModelEngine, Object data) throws Exception {
		if (!(data instanceof IPSDEDEDataSyncLogic)) {
			throw new Exception(String.format("模型类型不正确"));
		}
		super.init(iPSModelEngineHolder, iPSModelEngine, data);
	}

	@Override
	public IPSDEDEDataSyncLogic getPSDELogicNode() {
		return (IPSDEDEDataSyncLogic) super.getPSDELogicNode();
	}

	@Override
	protected void onExecute(IPSDELogicSession iPSDELogicSession) throws Throwable {
		
		IPSDEDEDataSyncLogic iPSDEDEDataSyncLogic = getPSDELogicNode();
	
		Object objParam = iPSDELogicSession.getLogicParamValue(iPSDEDEDataSyncLogic.getDstPSDELogicParamMust().getCodeName());
		
		if(iPSDELogicSession.isOutputDebugInfo()) {
			iPSDELogicSession.debugInfo(String.format("同步参数[%1$s] ==> %2$s", iPSDEDEDataSyncLogic.getDstPSDELogicParamMust().getCodeName(), objParam));
		}
		
		IPSDEDataSync dstPSDEDataSync = iPSDEDEDataSyncLogic.getDstPSDEDataSyncMust();
		
		IPSDEDataSyncEngine<?> dstPSDEDataSyncEngine = this.getPSModelEngineHolder().getPSModelEngine(dstPSDEDataSync, IPSDEDataSyncEngine.class);
		
		//IDEDataSyncOutRuntime dstDEDataSyncOutRuntime = dstDataEntityRuntimeBase.getDEDataSyncOutRuntime(dstPSDEDataSync);
		//dstDEDataSyncOutRuntime.send(dstPSDEDataSync.getEventType(), objParam, null);
		
		//需要判断传入参数类型
		
		
		
		dstPSDEDataSyncEngine.sendDirect(dstPSDEDataSync.getEventType(), PSDELogicParamAddinBase.asObjects(objParam));
		
		if(iPSDELogicSession.isOutputDebugInfo()) {
			iPSDELogicSession.debugInfo(String.format("数据同步[%1$s]", dstPSDEDataSync.getName()));
		}
		iPSDELogicSession.setLastReturn(null);
		
	}
	
}
