package net.ibizsys.model.engine.dataentity.logic;

import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.dataentity.logic.IPSDEDEDataSetLogic;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.dataentity.ds.IPSDEDataSetEngine;

/**
 * 实体调用实体数据集节点运行时对象
 * @author lionlau
 *
 */
public class PSDELogicDEDataSetNodeAddin extends PSDELogicNodeAddinBase{

	@Override
	public void init(IPSModelEngineHolder iPSModelEngineHolder, IPSModelEngine iPSModelEngine, Object data) throws Exception {
		if (!(data instanceof IPSDEDEDataSetLogic)) {
			throw new Exception(String.format("模型类型不正确"));
		}
		super.init(iPSModelEngineHolder, iPSModelEngine, data);
	}

	@Override
	public IPSDEDEDataSetLogic getPSDELogicNode() {
		return (IPSDEDEDataSetLogic) super.getPSDELogicNode();
	}

	@Override
	protected void onExecute(IPSDELogicSession iPSDELogicSession) throws Throwable {
		
		IPSDEDEDataSetLogic iPSDEDEDataSetLogic = getPSDELogicNode();
		
		Object objParam = iPSDELogicSession.getLogicParamValue(iPSDEDEDataSetLogic.getDstPSDELogicParamMust().getCodeName());
		
		if(iPSDELogicSession.isOutputDebugInfo()) {
			iPSDELogicSession.debugInfo(String.format("过滤参数[%1$s] ==> %2$s", iPSDEDEDataSetLogic.getDstPSDELogicParamMust().getCodeName(), objParam));
		}
		
		IPSDEDataSet dstPSDEDataSet = iPSDEDEDataSetLogic.getDstPSDEDataSetMust();

		IPSDEDataSetEngine dstPSDEDataSetEngine = this.getPSModelEngineHolder().getPSModelEngine(dstPSDEDataSet, IPSDEDataSetEngine.class);
		
		Object objRet = dstPSDEDataSetEngine.execute(new Object[] {objParam});
		if(iPSDELogicSession.isOutputDebugInfo()) {
			iPSDELogicSession.debugInfo(String.format("调用数据集[%1$s] ==> %2$s", dstPSDEDataSet.getName(), objRet));
		}
		iPSDELogicSession.setLastReturn(objRet);
		
		if(iPSDEDEDataSetLogic.getRetPSDELogicParam() != null) {
			IPSDELogicParamAddin retDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDEDEDataSetLogic.getRetPSDELogicParam().getCodeName(), false);
			retDELogicParamRuntime.bind(iPSDELogicSession, objRet);
			
			if(iPSDELogicSession.isOutputDebugInfo()) {
				iPSDELogicSession.debugInfo(String.format("绑定返回值[%1$s] <== %2$s", retDELogicParamRuntime.getCodeName(), objRet));
			}
		}
		
	}
	
}
