package net.ibizsys.model.engine.dataentity.logic;

import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.logic.IPSDEDEDataQueryLogic;
import net.ibizsys.model.engine.dataentity.IPSDataEntityEngine;
import net.ibizsys.model.engine.dataentity.ds.IPSDEDataQueryEngine;

/**
 * 实体调用实体查询节点运行时对象
 * @author lionlau
 *
 */
public class PSDELogicDEDataQueryNodeAddin extends PSDELogicNodeAddinBase<IPSDELogicEngine<?>, IPSDEDEDataQueryLogic>{

//	@Override
//	public void init(IPSModelEngineHolder iPSModelEngineHolder, IPSModelEngine iPSModelEngine, Object data) throws Exception {
//		if (!(data instanceof IPSDEDEDataQueryLogic)) {
//			throw new Exception(String.format("模型类型不正确"));
//		}
//		super.init(iPSModelEngineHolder, iPSModelEngine, data);
//	}
//
//	@Override
//	public IPSDEDEDataQueryLogic getPSDELogicNode() {
//		return (IPSDEDEDataQueryLogic) super.getPSDELogicNode();
//	}

	@Override
	protected void onExecute(IPSDELogicSession iPSDELogicSession) throws Throwable {
		
		IPSDEDEDataQueryLogic iPSDEDEDataQueryLogic = getPSDELogicNode();
		
		Object objParam = iPSDELogicSession.getLogicParamValue(iPSDEDEDataQueryLogic.getDstPSDELogicParamMust().getCodeName());
		
		if(iPSDELogicSession.isOutputDebugInfo()) {
			iPSDELogicSession.debugInfo(String.format("过滤参数[%1$s] ==> %2$s", iPSDEDEDataQueryLogic.getDstPSDELogicParamMust().getCodeName(), objParam));
		}
		
		
		IPSDEDataQuery dstPSDEDataQuery = iPSDEDEDataQueryLogic.getDstPSDEDataQuery();
		if(dstPSDEDataQuery == null) {
			IPSDataEntityEngine dstPSDataEntityEngine = this.getPSModelEngineHolder().getPSModelEngine(iPSDEDEDataQueryLogic.getDstPSDataEntityMust(), IPSDataEntityEngine.class);
			dstPSDEDataQuery = dstPSDataEntityEngine.getDefaultPSDEDataQuery();
		}
		
		if(dstPSDEDataQuery == null) {
			throw new Exception(String.format("未指定数据查询对象"));
		}
		
		
		IPSDEDataQueryEngine dstPSDEDataQueryEngine = this.getPSModelEngineHolder().getPSModelEngine(dstPSDEDataQuery, IPSDEDataQueryEngine.class);
		
		Object objRet = dstPSDEDataQueryEngine.execute(new Object[] {objParam});
		if(iPSDELogicSession.isOutputDebugInfo()) {
			iPSDELogicSession.debugInfo(String.format("调用查询[%1$s] ==> %2$s", dstPSDEDataQuery.getName(), objRet));
		}
		iPSDELogicSession.setLastReturn(objRet);
		
		if(iPSDEDEDataQueryLogic.getRetPSDELogicParam() != null) {
			IPSDELogicParamAddin retDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDEDEDataQueryLogic.getRetPSDELogicParam().getCodeName(), false);
			retDELogicParamRuntime.bind(iPSDELogicSession, objRet);
			
			if(iPSDELogicSession.isOutputDebugInfo()) {
				iPSDELogicSession.debugInfo(String.format("绑定返回值[%1$s] <== %2$s", retDELogicParamRuntime.getCodeName(), objRet));
			}
		}
		
	}
	
}
