package net.ibizsys.model.engine.dataentity.logic;

import net.ibizsys.model.dataentity.logic.IPSDEDEActionLogic;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.dataentity.action.IPSDEActionEngine;

/**
 * 实体调用实体行为节点运行时对象
 * @author lionlau
 *
 */
public class PSDELogicDEActionNodeAddin extends PSDELogicNodeAddinBase{

	@Override
	public void init(IPSModelEngineHolder iPSModelEngineHolder, IPSModelEngine iPSModelEngine, Object data) throws Exception {
		if (!(data instanceof IPSDEDEActionLogic)) {
			throw new Exception(String.format("模型类型不正确"));
		}
		super.init(iPSModelEngineHolder, iPSModelEngine, data);
	}

	@Override
	public IPSDEDEActionLogic getPSDELogicNode() {
		return (IPSDEDEActionLogic) super.getPSDELogicNode();
	}

	@Override
	protected void onExecute(IPSDELogicSession iPSDELogicEngineSession) throws Throwable {
		
		IPSDEDEActionLogic iPSDEDEActionLogic = getPSDELogicNode();
		
		Object objParam = iPSDELogicEngineSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDEDEActionLogic.getDstPSDELogicParamMust().getCodeName(), false).getValue(iPSDELogicEngineSession);
		
		if(iPSDELogicEngineSession.isOutputDebugInfo()) {
			iPSDELogicEngineSession.debugInfo(String.format("行为参数[%1$s] ==> %2$s", iPSDEDEActionLogic.getDstPSDELogicParamMust().getCodeName(), objParam));
		}
		
		IPSDEActionEngine dstPSDEActionEngine = this.getPSModelEngineHolder().getPSModelEngine(iPSDEDEActionLogic.getDstPSDEActionMust(), IPSDEActionEngine.class);
		
		
		Object objRet = dstPSDEActionEngine.execute(new Object[] {objParam});
		if(iPSDELogicEngineSession.isOutputDebugInfo()) {
			iPSDELogicEngineSession.debugInfo(String.format("调用行为[%1$s] ==> %2$s", iPSDEDEActionLogic.getDstPSDEActionMust().getName(), objRet));
		}
		iPSDELogicEngineSession.setLastReturn(objRet);
		if(iPSDEDEActionLogic.getRetPSDELogicParam() != null) {
			IPSDELogicParamAddin retDELogicParamRuntime = iPSDELogicEngineSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDEDEActionLogic.getRetPSDELogicParam().getCodeName(), false);
			retDELogicParamRuntime.bind(iPSDELogicEngineSession, objRet);
			
			if(iPSDELogicEngineSession.isOutputDebugInfo()) {
				iPSDELogicEngineSession.debugInfo(String.format("绑定返回值[%1$s] <== %2$s", retDELogicParamRuntime.getCodeName(), objRet));
			}
		}
	}
	
}
