package net.ibizsys.model.engine.dataentity.logic;

import net.ibizsys.model.dataentity.logic.IPSDECopyParamLogic;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineHolder;

/**
 * 实体拷贝逻辑参数节点运行时对象
 * @author lionlau
 *
 */
public class PSDELogicCopyParamNodeAddin extends PSDELogicNodeAddinBase{

	@Override
	public void init(IPSModelEngineHolder iPSModelEngineHolder, IPSModelEngine iPSModelEngine, Object data) throws Exception {
		if (!(data instanceof IPSDECopyParamLogic)) {
			throw new Exception(String.format("模型类型不正确"));
		}
		super.init(iPSModelEngineHolder, iPSModelEngine, data);
	}

	@Override
	public IPSDECopyParamLogic getPSDELogicNode() {
		return (IPSDECopyParamLogic) super.getPSDELogicNode();
	}

	@Override
	protected void onExecute(IPSDELogicSession iPSDELogicEngineSession) throws Throwable {
		
		IPSDECopyParamLogic iPSDECopyParamLogic = getPSDELogicNode();
	

		IPSDELogicParamAddin srcDELogicParamRuntime = iPSDELogicEngineSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDECopyParamLogic.getSrcPSDELogicParamMust().getCodeName(), false);
		IPSDELogicParamAddin dstDELogicParamRuntime = iPSDELogicEngineSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDECopyParamLogic.getDstPSDELogicParamMust().getCodeName(), false);
		
		
		srcDELogicParamRuntime.copyTo(iPSDELogicEngineSession, dstDELogicParamRuntime.getValue(iPSDELogicEngineSession), iPSDECopyParamLogic.getCopyFields(), iPSDECopyParamLogic.isCopyIfNotExists());
		
		if(iPSDELogicEngineSession.isOutputDebugInfo()) {
			iPSDELogicEngineSession.debugInfo(String.format("拷贝参数[%1$s] ==> %2$s", srcDELogicParamRuntime.getCodeName(), dstDELogicParamRuntime.getCodeName()));
		}
		
		iPSDELogicEngineSession.setLastReturn(null);
	}
	
}
