package net.ibizsys.model.engine.dataentity.logic;

import org.springframework.util.StringUtils;

import net.ibizsys.model.dataentity.logic.IPSDEBindParamLogic;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineHolder;

/**
 * 实体绑定逻辑参数节点运行时对象
 * @author lionlau
 *
 */
public class PSDELogicBindParamNodeAddin extends PSDELogicNodeAddinBase{

	@Override
	public void init(IPSModelEngineHolder iPSModelEngineHolder, IPSModelEngine iPSModelEngine, Object data) throws Exception {
		if (!(data instanceof IPSDEBindParamLogic)) {
			throw new Exception(String.format("模型类型不正确"));
		}
		super.init(iPSModelEngineHolder, iPSModelEngine, data);
	}

	@Override
	public IPSDEBindParamLogic getPSDELogicNode() {
		return (IPSDEBindParamLogic) super.getPSDELogicNode();
	}

	@Override
	protected void onExecute(IPSDELogicSession iPSDELogicEngineSession) throws Throwable {
		
		IPSDEBindParamLogic iPSDEBindParamLogic = getPSDELogicNode();

		
		IPSDELogicParamAddin srcDELogicParamAddin = iPSDELogicEngineSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDEBindParamLogic.getSrcPSDELogicParamMust().getCodeName(), false);
		IPSDELogicParamAddin dstDELogicParamAddin = iPSDELogicEngineSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDEBindParamLogic.getDstPSDELogicParamMust().getCodeName(), false);
		String strSrcFieldName = iPSDEBindParamLogic.getSrcFieldName();
		Object objValue = null;
		if(StringUtils.hasLength(strSrcFieldName)){
			objValue = srcDELogicParamAddin.get(iPSDELogicEngineSession, strSrcFieldName);
			if(iPSDELogicEngineSession.isOutputDebugInfo()) {
				iPSDELogicEngineSession.debugInfo(String.format("源参数[%1$s]属性[%2$s] ==> %3$s", srcDELogicParamAddin.getCodeName(), strSrcFieldName, objValue));
			}
		}
		else {
			objValue = srcDELogicParamAddin.getValue(iPSDELogicEngineSession);
			if(iPSDELogicEngineSession.isOutputDebugInfo()) {
				iPSDELogicEngineSession.debugInfo(String.format("源参数[%1$s] ==> %2$s", srcDELogicParamAddin.getCodeName(), objValue));
			}
		}
		
		dstDELogicParamAddin.bind(iPSDELogicEngineSession, objValue);
		
		if(iPSDELogicEngineSession.isOutputDebugInfo()) {
			iPSDELogicEngineSession.debugInfo(String.format("绑定参数[%1$s] <== %2$s", dstDELogicParamAddin.getCodeName(), objValue));
		}
		iPSDELogicEngineSession.setLastReturn(null);
	}
	
}
