package net.ibizsys.model.engine.dataentity.logic;

import org.springframework.util.StringUtils;

import net.ibizsys.model.dataentity.logic.IPSDEAppendParamLogic;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineHolder;

/**
 * 实体附加列表逻辑参数节点运行时对象
 * 
 * @author lionlau
 *
 */
public class PSDELogicAppendParamNodeAddin extends PSDELogicNodeAddinBase {

	@Override
	public void init(IPSModelEngineHolder iPSModelEngineHolder, IPSModelEngine iPSModelEngine, Object data) throws Exception {
		if (!(data instanceof IPSDEAppendParamLogic)) {
			throw new Exception(String.format("模型类型不正确"));
		}
		super.init(iPSModelEngineHolder, iPSModelEngine, data);
	}

	@Override
	public IPSDEAppendParamLogic getPSDELogicNode() {
		return (IPSDEAppendParamLogic) super.getPSDELogicNode();
	}

	@Override
	protected void onExecute(IPSDELogicSession iPSDELogicEngineSession) throws Throwable {

		IPSDEAppendParamLogic iPSDEAppendParamLogic = getPSDELogicNode();

		IPSDELogicParamAddin dstPSDELogicParamAddin = iPSDELogicEngineSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDEAppendParamLogic.getDstPSDELogicParamMust().getCodeName(), false);
		IPSDELogicParamAddin srcPSDELogicParamAddin = iPSDELogicEngineSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDEAppendParamLogic.getSrcPSDELogicParamMust().getCodeName(), false);
		String strSrcFieldName = iPSDEAppendParamLogic.getSrcFieldName();

		Object objValue = null;
		if (StringUtils.hasLength(strSrcFieldName)) {
			objValue = srcPSDELogicParamAddin.get(iPSDELogicEngineSession, strSrcFieldName);
			if (iPSDELogicEngineSession.isOutputDebugInfo()) {
				iPSDELogicEngineSession.debugInfo(String.format("源参数[%1$s]属性[%2$s] ==> %3$s", srcPSDELogicParamAddin.getCodeName(), strSrcFieldName, objValue));
			}
		} else {
			objValue = srcPSDELogicParamAddin.getValue(iPSDELogicEngineSession);
			if (iPSDELogicEngineSession.isOutputDebugInfo()) {
				iPSDELogicEngineSession.debugInfo(String.format("源参数[%1$s] ==> %2$s", srcPSDELogicParamAddin.getCodeName(), objValue));
			}
		}

		dstPSDELogicParamAddin.append(iPSDELogicEngineSession, iPSDEAppendParamLogic.getDstIndex(), objValue, iPSDEAppendParamLogic.getSrcIndex(), iPSDEAppendParamLogic.getSrcSize());

		if (iPSDELogicEngineSession.isOutputDebugInfo()) {
			if (iPSDEAppendParamLogic.getSrcIndex() >= 0) {
				iPSDELogicEngineSession.debugInfo(String.format("附加数组参数[%1$s][%2$s] <== %3$s{%4$s, %5$s}", dstPSDELogicParamAddin.getCodeName(), iPSDEAppendParamLogic.getDstIndex(), objValue, iPSDEAppendParamLogic.getSrcIndex(), iPSDEAppendParamLogic.getSrcSize()));
			} else {
				iPSDELogicEngineSession.debugInfo(String.format("附加数组参数[%1$s][%2$s] <== %3$s", dstPSDELogicParamAddin.getCodeName(), iPSDEAppendParamLogic.getDstIndex(), objValue));
			}
		}

		iPSDELogicEngineSession.setLastReturn(null);
	}

}
