package net.ibizsys.model.engine.dataentity.logic;

import java.util.List;

import net.ibizsys.model.dataentity.logic.IPSDELogicLink;
import net.ibizsys.model.dataentity.logic.IPSDELogicNode;
import net.ibizsys.model.dataentity.logic.IPSDELogicNodeParam;
import net.ibizsys.model.dataentity.logic.IPSDELogicParam;

/**
 * 实体逻辑执行会话
 * @author lionlau
 *
 */
public interface IPSDELogicSession {

	
	/**
	 * 调试信息类型：进入节点
	 */
	public final static String DEBUGTYPE_ENTERNODE = "enternode";
	
	/**
	 * 调试信息类型：进入连接
	 */
	public final static String DEBUGTYPE_ENTERLINK = "enterlink";
	
	/**
	 * 调试信息类型：离开节点
	 */
	public final static String DEBUGTYPE_EXITNODE = "exitnode";
	
	/**
	 * 调试信息类型：调试信息
	 */
	public final static String DEBUGTYPE_DEBUGINFO = "debuginfo";
	
	/**
	 * 调试信息类型：调试参数
	 */
	public final static String DEBUGTYPE_DEBUGPARAM = "debugparam";
	
	/**
	 * 实体逻辑运行时对象
	 * @return
	 */
	IPSDELogicEngine getPSDELogicEngine();
	
//	/**
//	 * 获取逻辑参数，该方法已废弃，使用 getParamObject 代替 
//	 * @param name
//	 * @return
//	 */
//	@Deprecated
//	IEntity getParam(String name) throws Throwable;
//	
//	
//	/**
//	 * 设置逻辑参数，该方法已废弃，使用 setParamObject 代替 
//	 * @param name
//	 * @param iEntity
//	 */
//	@Deprecated
//	void setParam(String name, IEntity iEntity);
//	
//	
//	
//	/**
//	 * 获取逻辑参数，该方法已废弃，使用 getParamObject 代替 
//	 * @param name
//	 * @return
//	 */
//	@Deprecated
//	IEntity getParam(String name, boolean tryMode) throws Throwable;
	
	
	/**
	 * 获取逻辑参数
	 * @param name
	 * @return
	 */
	Object getParam(String name) throws Throwable;
	
	
	/**
	 * 设置逻辑参数
	 * @param name
	 * @param value
	 */
	void setParam(String name, Object value);
	
	
	
	/**
	 * 获取逻辑参数
	 * @param name
	 * @return
	 */
	Object getParam(String name, boolean tryMode) throws Exception;
	
	
	/**
	 * 获取逻辑参数
	 * @param iPSDELogicParam
	 * @return
	 */
	Object getParam(IPSDELogicParam  iPSDELogicParam) throws Exception;
	
	
	/**
	 * 设置逻辑参数
	 * @param iPSDELogicParam
	 * @param value
	 */
	void setParam(IPSDELogicParam  iPSDELogicParam, Object value);
	
	
	
	/**
	 * 获取逻辑参数
	 * @param iPSDELogicParam
	 * @return
	 */
	Object getParam(IPSDELogicParam  iPSDELogicParam, boolean tryMode) throws Exception;
	
//	
//	/**
//	 * 获取用户上下文
//	 * @return
//	 */
//	ISecurityContext getUserContext();
//

	
	
	/**
	 * 获取返回结果
	 * @return
	 */
	Object getResult();
	
	
	/**
	 * 设置返回结果
	 * @return
	 */
	void setResult(Object object);
	
	
	
	/**
	 * 获取上一次逻辑节点调用返回值
	 * @return
	 */
	Object getLastReturn();
	
	
	/**
	 * 设置上一次逻辑节点调用返回值
	 * @param object
	 */
	void setLastReturn(Object object);
	
	
	/**
	 * 调试进入节点
	 * @param iPSDELogicNode
	 */
	void debugEnterNode(IPSDELogicNode iPSDELogicNode);
	

	
	/**
	 * 调试离开节点
	 * @param iPSDELogicNode
	 */
	void debugExitNode(IPSDELogicNode iPSDELogicNode);
	
	
	/**
	 * 调试进入节点连接
	 * @param iPSDELogicNode
	 * @param iPSDELogicLink
	 */
	void debugEnterLink(IPSDELogicNode iPSDELogicNode, IPSDELogicLink iPSDELogicLink);
	
	
	
	/**
	 * 调试逻辑参数
	 * @param iPSDELogicParam
	 */
	void debugParam(IPSDELogicParam iPSDELogicParam);
	
	
	
	/**
	 * 获取调试信息数组节点
	 * @return
	 */
	List getDebugData();
	
	
//	/**
//	 * 获取当前导航上下文
//	 * @return
//	 */
//	INavigateContext getNavigateContext();
//	
//	
	
	
	/**
	 * 调试信息
	 * @param strInfo
	 */
	void debugInfo(String strInfo);
	
	
	/**
	 * 是否输出调试信息
	 * @return
	 */
	boolean isOutputDebugInfo();
	
//	/**
//	 * 设置当前应用上下文
//	 * @param iAppContext
//	 */
//	void setAppContext(IAppContext iAppContext);
	
	
	
//	/**
//	 * 获取指定参数的指定属性值
//	 * @param strParam
//	 * @param strField
//	 * @return
//	 * @throws Throwable
//	 */
//	Object value(String  strParam, String strField) throws Throwable;
//	
//	
//	/**
//	 * 获取指定参数的指定实际值
//	 * @param strParam
//	 * @return
//	 * @throws Throwable
//	 */
//	Object value(String  strParam) throws Throwable;
	
	
	/**
	 * 计算节点参数值
	 * @param iPSDELogicNodeParam
	 * @return
	 * @throws Throwable
	 */
	Object getNodeParamValue(IPSDELogicNodeParam iPSDELogicNodeParam) throws Exception;
	
	
	/**
	 * 计算获取参数值
	 * @param strLogicParamCodeName
	 * @return
	 * @throws Throwable
	 */
	Object getLogicParamValue(String strLogicParamCodeName) throws Exception;
	
	
	/**
	 * 获取调试模式
	 * @return
	 */
	int getDebugMode();
	
	
}
