package net.ibizsys.model.engine.dataentity.logic;

import java.util.List;
import java.util.Map;

import net.ibizsys.model.dataentity.logic.IPSDELogicParam;
import net.ibizsys.model.engine.plugin.IPSModelEngineAddin2;

/**
 * 实体处理逻辑变量运行时对象接口
 * @author lionlau
 *
 */
public interface IPSDELogicParamAddin<E extends IPSDELogicEngine<?>, M extends IPSDELogicParam> extends IPSModelEngineAddin2<E, M>{

	/**
	 * 参数标识：列表长度
	 */
	public static String PARAM_SIZE = "size";
	
	
	/**
	 * 参数标识：列表长度
	 */
	public static String PARAM_LENGTH = "length";
	
	
	
	/**
	 * 参数标识：总记录数
	 */
	public final String PARAM_TOTAL = "total";
	
	
	/**
	 * 参数标识：文件Url来源
	 */
	public final String PARAM_URL = "url";
	
	
	
//	/**
//	 * 获取实体逻辑参数模型对象
//	 * @return
//	 */
//	IPSDELogicParam getPSDELogicParam();
	
	/**
	 * 获取代码标识
	 * @return
	 */
	String getCodeName();
	
//	/**
//	 * 获取实体逻辑运行时对象
//	 * @return
//	 */
//	IDELogicRuntime getDELogicRuntime();
//	
//	
//	/**
//	 * 获取实体运行时对象
//	 * @return
//	 */
//	IDataEntityRuntime getDataEntityRuntime();
	
//	/**
//	 * 获取实体处理逻辑参数对象
//	 * @return
//	 */
//	IPSDELogicParam getPSDELogicParam();

	
	/**
	 * 开始会话
	 * @param iDELogicSession
	 * @throws Throwable
	 */
	void beginSession(IPSDELogicSession iDELogicSession) ;
	
	
	
	/**
	 * 结束会话
	 * @param iDELogicSession
	 */
	void endSession(IPSDELogicSession iDELogicSession);
	
	
	
//	
//	
//	/**
//	 * 获取实际参数对象
//	 * @param iDELogicSession
//	 * @return
//	 * @throws Throwable
//	 */
//	@Deprecated
//	Object getParamObject(IPSDELogicSession iDELogicSession);
//	
	
	/**
	 * 获取实际对象
	 * @param iDELogicSession
	 * @return
	 * @throws Throwable
	 */
	Object getValue(IPSDELogicSession iDELogicSession);
	
	/**
	 * 获取实际参数直接变量清单对象
	 * @param iDELogicSession
	 * @return
	 * @throws Throwable
	 */
	Map<String, Object> any(IPSDELogicSession iDELogicSession);

	/**
	 * 设置指定属性值
	 * @param iDELogicSession
	 * @param strName
	 * @param objValue
	 * @throws Throwable
	 */
	void set(IPSDELogicSession iDELogicSession, String strName, Object objValue);

	/**
	 * 重置指定属性变量
	 * @param iDELogicSession
	 * @param strName
	 * @throws Throwable
	 */
	void reset(IPSDELogicSession iDELogicSession, String strName);

	/**
	 * 重置全部属性
	 * @param iDELogicSession
	 * @throws Throwable
	 */
	void resetAll(IPSDELogicSession iDELogicSession);

	/**
	 * 拷贝当前变量到指定变量
	 * @param iDELogicSession
	 * @param dstDELogicParamRuntime
	 * @throws Throwable
	 */
	void copyTo(IPSDELogicSession iDELogicSession, Object dstParam);
	

	/**
	 * 拷贝当前变量到指定变量
	 * @param iDELogicSession
	 * @param dstParam
	 * @param fieldList 拷贝的属性集合
	 * @param bCopyIfNotExists 是否仅拷贝不存在的属性
	 * @throws Throwable
	 */
	void copyTo(IPSDELogicSession iDELogicSession, Object dstParam, List<String> fieldList, boolean bCopyIfNotExists) ;

	/**
	 * 拷贝当前变量到指定变量
	 * @param dstParam
	 * @param fieldList 拷贝的属性集合
	 * @param bCopyIfNotExists 是否仅拷贝不存在的属性
	 * @throws Throwable
	 */
	void copyTo(Object dstParam, List<String> fieldList, boolean bCopyIfNotExists) ;
	
	/**
	 * 获取指定属性值
	 * @param iDELogicSession
	 * @param strName
	 * @return
	 * @throws Throwable
	 */
	Object get(IPSDELogicSession iDELogicSession, String strName);

	
	/**
	 * 判断是否包括指定属性
	 * @param iDELogicSession
	 * @param strName
	 * @return
	 * @throws Throwable
	 */
	boolean contains(IPSDELogicSession iDELogicSession, String strName);
	
	
	
	/**
	 * 绑定指定参数对象
	 * @param iDELogicSession
	 * @param paramObject
	 * @throws Throwable
	 */
	void bind(IPSDELogicSession iDELogicSession, Object paramObject);
	
	
	/**
	 *重新建立参数对象
	 * @param iDELogicSession
	 * @throws Throwable
	 */
	void renew(IPSDELogicSession iDELogicSession);
	
	
	
	/**
	 * 附加参数对象
	 * @param iDELogicSession
	 * @param nPos
	 * @param paramObject
	 * @param nSrcPos
	 * @param nSrcLength
	 * @throws Throwable
	 */
	void append(IPSDELogicSession iDELogicSession, int nPos, Object paramObject, int nSrcPos, int nSrcLength);
	
	
	
	/**
	 * 排序参数对象
	 * @param iDELogicSession
	 * @param strField
	 * @param strSortDir
	 * @throws Throwable
	 */
	void sort(IPSDELogicSession iDELogicSession, String strField, String strSortDir);
	
	
	
	/**
	 * 获取变量数组长度
	 * @param iDELogicSession
	 * @throws Throwable
	 */
	int count(IPSDELogicSession iDELogicSession);
	
	

	/**
	 * 对数据变量进行相关聚合计算
	 * @param iDELogicSession
	 * @param strField
	 * @param strAggMode
	 * @throws Throwable
	 */
	Object aggregate(IPSDELogicSession iDELogicSession, String strField, String strAggMode);
	
	
	
	/**
	 * 输出调试信息
	 * @param iDELogicSession
	 * @param objectNode
	 */
	void debug(IPSDELogicSession iDELogicSession, Map<String, Object> data);
	
	
	
	/**
	 * 获取实际对象
	 * @return
	 * @throws Throwable
	 */
	Object getValue();
	
	/**
	 * 获取实际参数直接变量清单对象
	 * @return
	 * @throws Throwable
	 */
	Map<String, Object> any();

	/**
	 * 设置指定属性值
	 * @param strName
	 * @param objValue
	 * @throws Throwable
	 */
	void set(String strName, Object objValue);

	/**
	 * 重置指定属性变量
	 * @param strName
	 * @throws Throwable
	 */
	void reset(String strName);

	/**
	 * 重置全部属性
	 * @param iDELogicSession
	 * @throws Throwable
	 */
	void resetAll();

	/**
	 * 拷贝当前变量到指定变量
	 * @param dstParam
	 * @throws Throwable
	 */
	void copyTo(Object dstParam);

	/**
	 * 获取指定属性值
	 * @param strName
	 * @return
	 * @throws Throwable
	 */
	Object get(String strName);

	
	/**
	 * 判断是否包括指定属性
	 * @param iDELogicSession
	 * @param strName
	 * @return
	 * @throws Throwable
	 */
	boolean contains(String strName);
	
	
	
	/**
	 * 绑定指定参数对象
	 * @param paramObject
	 * @throws Throwable
	 */
	void bind(Object paramObject);
	
	
	/**
	 *重新建立参数对象
		 * @throws Throwable
	 */
	void renew();
	
	
	
	/**
	 * 附加参数对象
	 * @param nPos
	 * @param paramObject
	 * @param nSrcPos
	 * @param nSrcLength
	 * @throws Throwable
	 */
	void append(int nPos, Object paramObject, int nSrcPos, int nSrcLength);
	
	
	
	/**
	 * 排序参数对象
	 * @param strField
	 * @param strSortDir
	 * @throws Throwable
	 */
	void sort(String strField, String strSortDir);
	
	
	
	/**
	 * 获取变量数组长度
	 * @throws Throwable
	 */
	int count();
	
	

	/**
	 * 对数据变量进行相关聚合计算
	 * @param strField
	 * @param strAggMode
	 * @throws Throwable
	 */
	Object aggregate(String strField, String strAggMode);
	
}
