package net.ibizsys.model.engine.dataentity.logic;

import java.util.List;

import net.ibizsys.model.dataentity.logic.IPSDELogic;
import net.ibizsys.model.engine.IPSModelEngine;

/**
 * 实体逻辑运行时对象接口
 * @author lionlau
 *
 */
public interface IPSDELogicEngine<M extends IPSDELogic> extends IPSModelEngine<M>{

	/**
	 * break值
	 */
	public final static Object BREAK_VALUE = new Object();
	
	
	/**
	 * 获取相关模型
	 * @return
	 */
	IPSDELogic getPSDELogic();
	
	/**
	 * 执行实体逻辑
	 * @param args
	 * @return
	 * @throws Throwable
	 */
	Object execute(Object[] args);
	
	/**
	 * 获取逻辑参数运行时对象
	 * @param name
	 * @return
	 */
	IPSDELogicParamAddin getPSDELogicParamAddin(String name, boolean tryMode);
	
	
	
	/**
	 * 获取逻辑节点运行时对象
	 * @param name
	 * @return
	 */
	IPSDELogicNodeAddin getPSDELogicNodeAddin(String name, boolean tryMode);
	

	
	
	/**
	 * 获取默认实体逻辑参数运行时对象
	 * @return
	 */
	IPSDELogicParamAddin getDefaultPSDELogicParamAddin();
	
	
	/**
	 * 获取逻辑参数引擎集合
	 * @return
	 */
	List<IPSDELogicParamAddin> getPSDELogicParamAddins();
	
	
}
