package net.ibizsys.model.engine.dataentity.dataflow;

import java.util.HashMap;
import java.util.Map;

import org.springframework.util.Assert;

public abstract class PSDEDataFlowSessionBase<E extends IPSDEDataFlowEngine<?>> implements IPSDEDataFlowSession<E>{

	private final E iPSDEDataFlowEngine;
	private Map<String, Object> paramMap = new HashMap<>();
	
	public PSDEDataFlowSessionBase(E iPSDEDataFlowEngine, Map<String, Object> params) {
		Assert.notNull(iPSDEDataFlowEngine, "传入数据流引擎对象无效");
		this.iPSDEDataFlowEngine = iPSDEDataFlowEngine;
		if(params!=null) {
			this.paramMap.putAll(params);
		}
	}
	
	@Override
	public E getPSDEDataFlowEngine() {
		return this.iPSDEDataFlowEngine;
	}
	
	
	@Override
	public Object getParam(String strName) throws Exception {
		return this.getParam(strName, false);
	}

	@Override
	public void setParam(String strName, Object object) {
		paramMap.put(strName, object);
	}

	@Override
	public Object getParam(String strName, boolean bTryMode) throws Exception {
		Object obj =  paramMap.get(strName);
		if(obj != null || bTryMode) {
			return obj;
		}
		throw new Exception(String.format("未存在指定参数[%1$s]", strName));
	}
	
	@Override
	public Object getContextValue(String type, String name) throws Exception {
		return this.getContextValue(type, name, false);
	}
	
	@Override
	public Object getContextValue(String type, String name, boolean tryMode) throws Exception {
		Object obj =  getParam(type, true);
		if(obj == null) {
			 if(tryMode) {
				 return null;
			 }
			 throw new Exception(String.format("未存在上下文[%1$s]", type));
			
		}
		if(obj instanceof Map) {
			Map map = (Map)obj;
			Object item = map.get(name);
			if(item != null || tryMode) {
				return item;
			}
			throw new Exception(String.format("上下文[%1$s]未存在指定参数[%2$s]", type, name));
		}
		else {
			throw new Exception(String.format("上下文[%1$s]值类型不正确", type));
		}
	}
}
