package net.ibizsys.model.engine.dataentity.dataflow;

import org.springframework.util.ObjectUtils;

import net.ibizsys.model.PSModelEnums.DEDataFlowLinkType;
import net.ibizsys.model.dataentity.dataflow.IPSDEDataFlowLink;
import net.ibizsys.model.dataentity.dataflow.IPSDEDataFlowNode;
import net.ibizsys.model.engine.plugin.PSModelEngineAddin2Base;

public abstract class PSDEDataFlowNodeAddinBase<E extends IPSDEDataFlowEngine<?>, M extends IPSDEDataFlowNode> extends PSModelEngineAddin2Base<E, M> implements IPSDEDataFlowNodeAddin<E, M> {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(PSDEDataFlowNodeAddinBase.class);
	
	private IPSDEDataFlowNode dataStreamPSDEDataFlowNode = null;
	private IPSDEDataFlowNode dataStream2PSDEDataFlowNode = null;
	
	protected M getPSDEDataFlowNode() {
		return this.getAddinData();
	}
	
//	@Override
//	public void init(IPSModelEngineHolder iPSModelEngineHolder, E iPSModelEngine, Object data) throws Exception {
//		if(!(data instanceof IPSDEDataFlowNode)) {
//			throw new Exception(String.format("模型类型不正确"));
//		}
//		super.init(iPSModelEngineHolder, iPSModelEngine, data);
//	}
	
//	
//	
//	@Override
//	protected IPSDEDataFlowNode getAddinData() {
//		return (IPSDEDataFlowNode)super.getAddinData();
//	}
//	
//	@Override
//	public IPSDEDataFlowNode getPSDEDataFlowNode() {
//		return this.getAddinData();
//	}
//	
//	@Override
//	public IPSDEDataFlowEngine getPSModelEngine() {
//		return (IPSDEDataFlowEngine)super.getPSModelEngine();
//	}
//	
//	@Override
//	public IPSDEDataFlowEngine<?> getPSDEDataFlowEngine() {
//		return this.getPSModelEngine();
//	}
	

	
	@Override
	protected void onInit() throws Exception {
		
		java.util.List<IPSDEDataFlowLink> psDEDataFlowLinks = this.getPSModelEngine().getPSModelObject().getPSDEDataFlowLinks();
		if(!ObjectUtils.isEmpty(psDEDataFlowLinks)) {
			for(IPSDEDataFlowLink iPSDEDataFlowLink : psDEDataFlowLinks) {
				if(iPSDEDataFlowLink.getDstPSDEDataFlowNodeMust().getId().equals(this.getAddinData().getId())) {
					if(DEDataFlowLinkType.DATASTREAM.value.equals(iPSDEDataFlowLink.getLinkType())) {
						if(this.dataStreamPSDEDataFlowNode != null) {
							throw new Exception(String.format("出现重复的数据源节点[%1$s]", iPSDEDataFlowLink.getSrcPSDEDataFlowNodeMust().getName()));
						}
						this.dataStreamPSDEDataFlowNode = iPSDEDataFlowLink.getSrcPSDEDataFlowNodeMust();
						continue;
					}
					
					if(DEDataFlowLinkType.DATASTREAM2.value.equals(iPSDEDataFlowLink.getLinkType())) {
						if(this.dataStream2PSDEDataFlowNode != null) {
							throw new Exception(String.format("出现重复的数据源2节点[%1$s]", iPSDEDataFlowLink.getSrcPSDEDataFlowNodeMust().getName()));
						}
						this.dataStream2PSDEDataFlowNode = iPSDEDataFlowLink.getSrcPSDEDataFlowNodeMust();
						continue;
					}
					
					throw new Exception(String.format("无法识别的连接类型[%1$s]", iPSDEDataFlowLink.getLinkType()));
				}
			}
		}
		
		super.onInit();
	}
	
	protected IPSDEDataFlowNode getDataStream(boolean tryMode) throws Exception{
		if(this.dataStreamPSDEDataFlowNode != null || tryMode) {
			return this.dataStreamPSDEDataFlowNode;
		}
		throw new Exception(String.format("未定义数据源节点"));
	}
	
	
	protected IPSDEDataFlowNode getDataStream2(boolean tryMode) throws Exception{
		if(this.dataStream2PSDEDataFlowNode != null || tryMode) {
			return this.dataStream2PSDEDataFlowNode;
		}
		throw new Exception(String.format("未定义数据源2节点"));
	}
	
	
	
	@Override
	public String getName() {
		return this.getPSModelEngine().getName();
	}
	
	@Override
	public String getFullName() {
		return String.format("数据流节点[%1$s]", this.getName());
	}
	
	
	
}
	
