package net.ibizsys.model.engine.dataentity.dataflow;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;

import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.PSModelEnums.DataFlowSubType;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.dataflow.IPSDEDataFlow;
import net.ibizsys.model.dataentity.dataflow.IPSDEDataFlowNode;
import net.ibizsys.model.engine.PSModelEngineBase;
import net.ibizsys.model.engine.PSModelEngineException;
import net.ibizsys.model.engine.util.IAction;
import net.ibizsys.model.util.JsonUtils;

public abstract class PSDEDataFlowEngineBase<M extends IPSDEDataFlow> extends PSModelEngineBase<M> implements IPSDEDataFlowEngine<M>{

	private Map<String, IPSDEDataFlowNodeAddin<?,?>> psDEDataFlowNodeAddinMap = new LinkedHashMap<>();
	
	@Override
	protected void onInit() throws Exception {
		
		//建立各节点运行时对象
		onPreparePSDEDataFlowNodeAddins();
		
		
		super.onInit();
	}
	
	protected void onPreparePSDEDataFlowNodeAddins() throws Exception {
		List<IPSDEDataFlowNode> psDEDataFlowNodeList = this.getPSModelObject().getPSDEDataFlowNodes();
		if(psDEDataFlowNodeList != null) {
			for(IPSDEDataFlowNode iPSDEDataFlowNode : psDEDataFlowNodeList) {
				IPSDEDataFlowNodeAddin<?,?> iPSDEDataFlowNodeAddin = this.getPSModelEngineHolder().getPSModelEngineAddin(this, iPSDEDataFlowNode, IPSDEDataFlowNodeAddin.class);
				psDEDataFlowNodeAddinMap.put(iPSDEDataFlowNode.getCodeName().toUpperCase(), iPSDEDataFlowNodeAddin);
			}
		}
	}
	
	
	@Override
	public Collection<? extends IPSDEDataFlowNodeAddin<?,?>> getPSDEDataFlowNodeAddins() {
		
		if(ObjectUtils.isEmpty(psDEDataFlowNodeAddinMap)) {
			return null;
		}
		
		return this.psDEDataFlowNodeAddinMap.values();
	}
	
	@Override
	public IPSDEDataFlowNodeAddin<?,?> getPSDEDataFlowNodeAddin(String name, boolean tryMode) {
		IPSDEDataFlowNodeAddin<?,?> iPSDEDataFlowNodeAddin =  psDEDataFlowNodeAddinMap.get(name.toUpperCase());
		if(iPSDEDataFlowNodeAddin != null || tryMode) {
			return iPSDEDataFlowNodeAddin;
		}
		throw new PSModelEngineException(this, String.format("未存在指定节点[%1$s]", name));
	}
	

	@Override
	public void execute(Object[] args) {
		this.executeAction("执行流处理", new IAction<Object>() {
			@Override
			public Object execute(Object[] args) throws Throwable {
				if(DataFlowSubType.PACKAGE.value.equals(getPSModelObject().getLogicSubType())) {
					onExecutePackage(args);
					return null;
				}
				onExecute(args);
				return null;
			}
		}, args);
	}

	protected void onExecute(Object[] args) throws Throwable{
		throw new Exception("没有实现");
	}
	
	protected void onExecutePackage(Object[] args) throws Throwable{
		
		String packageModel = this.getPSModelObject().getPackageModel();
		if(!StringUtils.hasLength(packageModel)) {
			throw new Exception("未指定包模型");
		}
		
		Map<String, IPSDEDataFlow> psDEDataFlowMap = new LinkedHashMap<String, IPSDEDataFlow>();
		ArrayNode arrayNode = JsonUtils.toArrayNode(packageModel);
		
		for(int i = 0; i<arrayNode.size(); i++) {
			JsonNode jsonNode = arrayNode.get(i);
			if(jsonNode.isTextual()) {
				String id = jsonNode.asText();
				if(!StringUtils.hasLength(id)) {
					continue;
				}
				psDEDataFlowMap.put(id.toLowerCase(), null);
			}
		} 
		
		if(ObjectUtils.isEmpty(psDEDataFlowMap)) {
			throw new Exception("未指定包模型");
		}
		
		java.util.List<IPSDataEntity> psDataEntityList = this.getPSModelEngineHolder().getPSSystemService().getPSSystem().getAllPSDataEntities();
		if (!ObjectUtils.isEmpty(psDataEntityList)) {
			for (IPSDataEntity iPSDataEntity : psDataEntityList) {
				java.util.List<IPSDEDataFlow> psDEDataFlowList = iPSDataEntity.getAllPSDEDataFlows();
				if (!ObjectUtils.isEmpty(psDEDataFlowList)) {
					for (IPSDEDataFlow iPSDEDataFlow : psDEDataFlowList) {

						String tag = PSModelUtils.calcFullUniqueTag(iPSDEDataFlow, true);
						if(!psDEDataFlowMap.containsKey(tag)) {
							continue;
						}
						psDEDataFlowMap.put(tag, iPSDEDataFlow);
					}
				}
			}
		}
		
		for(java.util.Map.Entry<String, IPSDEDataFlow> entry : psDEDataFlowMap.entrySet()) {
			if(entry.getValue() == null) {
				throw new Exception(String.format("无法获取指定数据流[%1$s]", entry.getKey()));
			}
		}
		
		this.onExecutePSDEDataFlows(psDEDataFlowMap.values().toArray(new IPSDEDataFlow[psDEDataFlowMap.size()]), args);
	}
	
	protected void onExecutePSDEDataFlows(IPSDEDataFlow[] psDEDataFlows, Object[] args) throws Throwable{
		throw new Exception("没有实现");
	}
	
}