package net.ibizsys.model.engine.dataentity.dataflow;

/**
 * @author lionlau
 *
 */
public interface IPSDEDataFlowSession<E extends IPSDEDataFlowEngine> {

	
	/**
	 * 获取实体数据流引擎对象
	 * @return
	 */
	E getPSDEDataFlowEngine();
	
	
	/**
	 * 获取逻辑参数
	 * @param name
	 * @return
	 */
	Object getParam(String name) throws Exception;
	
	
	/**
	 * 设置逻辑参数
	 * @param objParam
	 * @param iEntity
	 */
	void setParam(String name, Object objParam);
	
	
	
	/**
	 * 获取逻辑参数
	 * @param name
	 * @return
	 */
	Object getParam(String name, boolean tryMode) throws Exception;
	
	
	
	
	/**
	 * 获取上下文值
	 * @param type
	 * @param name
	 * @return
	 * @throws Throwable
	 */
	Object getContextValue(String type, String name) throws Exception;
	
	
	/**
	 * 获取上下文值
	 * @param type
	 * @param name
	 * @param tryMode 
	 * @return
	 * @throws Throwable
	 */
	Object getContextValue(String type, String name, boolean tryMode) throws Exception;
}
