package net.ibizsys.model.engine.dataentity.action;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import net.ibizsys.model.PSModelEnums.DEActionType;
import net.ibizsys.model.dataentity.action.IPSDEAction;
import net.ibizsys.model.engine.PSModelEngineBase;
import net.ibizsys.model.engine.util.IAction;

public abstract class PSDEActionEngineBase<M extends IPSDEAction> extends PSModelEngineBase<M> implements IPSDEActionEngine<M>{

	private static final Log log = LogFactory.getLog(PSDEActionEngineBase.class);
	
	private IPSDEActionInputAddin iPSDEActionInputEngine = null;
	private IPSDEActionReturnAddin iPSDEActionReturnEngine = null;
	private DEActionType actionType = null;
	
	@Override
	protected void onInit() throws Exception {
		this.actionType = DEActionType.from(this.getPSModelObject().getActionType());
		this.iPSDEActionInputEngine = this.getPSModelEngineHolder().getPSModelEngineAddin(this, this.getPSModelObject().getPSDEActionInputMust(), IPSDEActionInputAddin.class);
		this.iPSDEActionReturnEngine = this.getPSModelEngineHolder().getPSModelEngineAddin(this, this.getPSModelObject().getPSDEActionReturnMust(), IPSDEActionReturnAddin.class);
		
		super.onInit();
	}
	
	
	
	public DEActionType getActionType() {
		return this.actionType;
	}

	@Override
	public Object execute(Object[] args) {
		return this.executeAction("执行行为", new IAction<Object>() {
			@Override
			public Object execute(Object[] args) throws Throwable {
				return onExecute(args);
			}
		}, args);
	}

	protected Object onExecute(Object[] args) throws Throwable {
		
		switch(getActionType()) {
		case REMOTE:
		case SCRIPT:
		case USERCREATE:
		case USERSYSUPDATE:
		case USERCUSTOM:
		case USERUPDATE:
		case BUILTIN:
		case DELOGIC:
		
		case SELECTBYKEY:
			break;
		}
		
		throw new Exception("没有实现");
	}
}