package net.ibizsys.model.engine.database.sql;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.springframework.util.ObjectUtils;

import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.plugin.PSModelEngineAddinBase;
import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;

public abstract class SQLGenEngineBase<E extends IPSModelEngine<?>> extends PSModelEngineAddinBase<E, String> implements ISQLGenEngine<E> {

	public String getDBType() {
		return this.getAddinData();
	}
	
	@Override
	protected String getAddinData() {
		return (String)super.getAddinData();
	}

	@Override
	public String generate(IPSDEDataSet iPSDEDataSet, Map<String, Object> params) {
		try {
			return this.onGenerate(iPSDEDataSet, params);
		}
		catch (Throwable ex) {
			throw new PSModelEngineAddinException(this, String.format("生成数据集SQL发生异常，%1$s", ex.getMessage()), ex);
		}
	}
	
	protected String onGenerate(IPSDEDataSet iPSDEDataSet, Map<String, Object> params) throws Throwable{
		List<String> sqlList = new ArrayList<String>();
		
		if(ObjectUtils.isEmpty(iPSDEDataSet.getPSDEDataQueries())) {
			throw new Exception("未包含数据查询");
		}
		
		for(IPSDEDataQuery iPSDEDataQuery : iPSDEDataSet.getPSDEDataQueries()) {
			String sql = this.generate(iPSDEDataQuery, params);
			sqlList.add(sql);
		}
		
		if(sqlList.size() == 1) {
			return sqlList.get(0);
		}
		else {
			StringBuilder sb = new StringBuilder();
			for(int i = 0;i<sqlList.size();i++) {
				if( i != 0) {
					sb.append("UNION");
				}
				sb.append("\n");
				sb.append(sqlList.get(i));
			}
			return sb.toString();
		}
	}

	@Override
	public String generate(IPSDEDataQuery iPSDEDataQuery, Map<String, Object> params) {
		try {
			return this.onGenerate(iPSDEDataQuery, params);
		}
		catch (Throwable ex) {
			throw new PSModelEngineAddinException(this, String.format("生成数据查询集SQL发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	protected String onGenerate(IPSDEDataQuery iPSDEDataQuery, Map<String, Object> params) throws Throwable{
		throw new Exception("没有实现");
	}
	
	
	
}
