package net.ibizsys.model.engine.database.sql;

import java.util.Map;

import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.plugin.IPSModelEngineAddin;

/**
 * SQL 代码生成引擎对象接口
 * @author lionlau
 *
 */
public interface ISQLGenEngine<E extends IPSModelEngine<?>> extends IPSModelEngineAddin<E, String> {

	
	/**
	 * 生成实体数据集代码
	 * @param iPSDEDataSet
	 * @param params
	 * @return
	 */
	String generate(IPSDEDataSet iPSDEDataSet, Map<String, Object> params);
	
	
	
	/**
	 * 生成实体数据查询代码
	 * @param iPSDEDataQuery
	 * @param params
	 * @return
	 */
	String generate(IPSDEDataQuery iPSDEDataQuery, Map<String, Object> params);
}
