package net.ibizsys.model.engine.database;

import java.util.List;

import org.springframework.util.StringUtils;

import net.ibizsys.model.PSModelEnums.DBObjNameCaseMode;
import net.ibizsys.model.engine.service.PSSubSysServiceAPIEngineBaseBase;
import net.ibizsys.model.engine.util.ISQLSupportable;
import net.ibizsys.model.service.IPSSubSysServiceAPIBase;

public abstract class PSSysDBSchemeEngineBaseBase<T extends IPSSubSysServiceAPIBase> extends PSSubSysServiceAPIEngineBaseBase<T> implements IPSSysDBSchemeEngineBase<T>, ISQLSupportable {

	private DBObjNameCaseMode dbObjNameCaseMode = DBObjNameCaseMode.DEFAULT;
	private String dbType = null;
	private String dbObjNameCase = DBObjNameCaseMode.DEFAULT.value;
	
	protected void setDBType(String dbType) {
		this.dbType = dbType;
	}
	
	@Override
	public String getDBType() {
		return this.dbType;
	}
	
	//@Override
	public String getDBObjNameCase() {
		return this.dbObjNameCase;
	}
	
	protected void setDBObjNameCase(String dbObjNameCase) {
		if(!StringUtils.hasLength(dbObjNameCase)) {
			dbObjNameCase = DBObjNameCaseMode.LCASE.value;
		}
		
		this.dbObjNameCase = dbObjNameCase;
		this.dbObjNameCaseMode = DBObjNameCaseMode.from(this.dbObjNameCase);
		
	}
	
	public DBObjNameCaseMode getDBObjNameCaseMode() {
		return this.dbObjNameCaseMode;
	}
	
	/**
	 * 获取实际数据库对象名称
	 * @param name
	 * @return
	 */
	protected String getRealDBObjName(String name) {
		if(!StringUtils.hasLength(name) || this.getDBObjNameCaseMode() == DBObjNameCaseMode.DEFAULT) {
			return name;
		}
		else
			if(this.getDBObjNameCaseMode() == DBObjNameCaseMode.LCASE) {
				return name.toLowerCase();
			}
			else
				if(this.getDBObjNameCaseMode() == DBObjNameCaseMode.UCASE) {
					return name.toUpperCase();
				}
		return name;
	}
	
	@Override
	public List executeSelectSQL(String strSQL, List<Object> params) {
		// TODO Auto-generated method stub
		return null;
	}

	protected List onExecuteSelectSQL(String strSQL, List<Object> params) throws Throwable {
		throw new Exception("没有实现");
	}

	@Override
	public int executeSQL(String strSQL, List<Object> params) {
		// TODO Auto-generated method stub
		return 0;
	}

	protected int onExecuteSQL(String strSQL, List<Object> params) throws Throwable {
		throw new Exception("没有实现");
	}

	@Override
	public boolean isEnableSQL() {
		return false;
	}

}
