package net.ibizsys.model.engine.database;

import java.util.Map;

import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.database.IPSSysDBScheme;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataQueryCode;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.database.sql.ISQLGenEngine;
import net.ibizsys.model.engine.util.IAction;


public abstract class PSSysDBSchemeEngineBase<T extends IPSSysDBScheme> extends PSSysDBSchemeEngineBaseBase<T> implements IPSSysDBSchemeEngine<T> {

	
	private ISQLGenEngine iSQLGenEngine = null;
	
	@Override
	public void init(IPSModelEngineHolder iPSModelEngineContext, String id, T iPSSysDBScheme) throws Exception {
		this.setConfigFolder("sysdbscheme." + PSModelUtils.calcUniqueTag(iPSSysDBScheme.getPSSysModelGroup(), iPSSysDBScheme.getDSLink()));
		super.init(iPSModelEngineContext, id, iPSSysDBScheme);
	}
	
	
	@Override
	protected void onPrepareSetting() throws Exception {
		this.setDBType(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".dbtype", "MYSQL5"));
		if(StringUtils.hasLength(this.getPSModelObject().getDBObjNameCase())) {
			this.setDBObjNameCase(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".dbobjnamecase", this.getPSModelObject().getDBObjNameCase()));
		}
		
		super.onPrepareSetting();
	}
	
	@Override
	protected void onInit() throws Exception {
		
		super.onInit();
	}
	
	public IPSSysDBScheme getPSSysDBScheme() {
		return getPSModelObject();
	}
	
	
	
	
	@Override
	public boolean isEnableSQL() {
		return true;
	}
	
	protected ISQLGenEngine getSQLGenEngine(boolean tryMode) throws Exception{
		if(this.iSQLGenEngine != null || tryMode) {
			return this.iSQLGenEngine;
		}
		
		ISQLGenEngine iSQLGenEngine = this.getPSModelEngineHolder().getPSModelEngineAddin(this, this.getDBType(), ISQLGenEngine.class);
		this.iSQLGenEngine = iSQLGenEngine;
		return this.iSQLGenEngine;
	}
	
	protected void setSQLGenEngine(ISQLGenEngine iSQLGenEngine) {
		this.iSQLGenEngine = iSQLGenEngine;
	}


	@Override
	public String getSQL(IPSDEDataSet iPSDEDataSet, Map<String, Object> params) {
		return this.executeAction("获取数据集SQL代码", new IAction<String>() {
			@Override
			public String execute(Object[] args) throws Throwable {
				return onGetSQL(iPSDEDataSet, params);
			}
		}, String.class);
	}

	protected String onGetSQL(IPSDEDataSet iPSDEDataSet, Map<String, Object> params) throws Throwable{
//		List<IPSDEDataQuery> psDEDataQueryList = iPSDEDataSet.getPSDEDataQueries();
//		if(ObjectUtils.isEmpty(psDEDataQueryList)) {
//			throw new Exception("未定义任何数据查询");
//		}
//		
//		for(IPSDEDataQuery iPSDEDataQuery : psDEDataQueryList) {
//			if(ObjectUtils.isEmpty(iPSDEDataQuery.getAllPSDEDataQueryCodes())) {
//				throw new Exception("未定义查询代码");
//			}
//			
//			IPSDEDataQueryCode iPSDEDataQueryCode = this.getPSDEDataQueryCode(iPSDEDataQuery, false);
//			return iPSDEDataQueryCode.getQueryCode();
//		}
//		
//		throw new Exception("未定义查询代码");
		
		return getSQLGenEngine(false).generate(iPSDEDataSet, params);
	}

	protected IPSDEDataQueryCode getPSDEDataQueryCode(IPSDEDataQuery iPSDEDataQuery, boolean tryMode) throws Exception{
		if(!ObjectUtils.isEmpty(iPSDEDataQuery.getAllPSDEDataQueryCodes())) {
			for(IPSDEDataQueryCode iPSDEDataQueryCode : iPSDEDataQuery.getAllPSDEDataQueryCodes()) {
				if(this.getDBType().equalsIgnoreCase(iPSDEDataQueryCode.getDBType())) {
					return iPSDEDataQueryCode;
				}
			}
		}
		
		if(tryMode) {
			return null;
		}
		throw new Exception(String.format("未定义查询代码[%1$s]", this.getDBType()));
	}
	
	@Override
	public String getSQL(IPSDEDataQuery iPSDEDataQuery, Map<String, Object> params) {
		return this.executeAction("获取数据查询SQL代码", new IAction<String>() {
			@Override
			public String execute(Object[] args) throws Throwable {
				return onGetSQL(iPSDEDataQuery, params);
			}
		}, String.class);
	}
	
	protected String onGetSQL(IPSDEDataQuery iPSDEDataQuery, Map<String, Object> params) throws Throwable{
		throw new Exception("没有实现");
	}
	
	
}
