package net.ibizsys.model.engine.database;

import java.util.Map;

import net.ibizsys.model.database.IPSSysDBScheme;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.service.IPSSubSysServiceAPIEngineBase;

/**
 * 系统大数据架构引擎对象接口
 * @author lionlau
 *
 */
public interface IPSSysDBSchemeEngine<M extends IPSSysDBScheme> extends IPSModelEngine<M>, IPSSubSysServiceAPIEngineBase<M>{

	/**
	 * 获取数据库类型
	 * @return
	 */
	String getDBType();
	
	
	
	/**
	 * 获取传入数据集的SQL代码
	 * @param iPSDEDataSet
	 * @param params
	 * @return
	 */
	String getSQL(IPSDEDataSet iPSDEDataSet, Map<String, Object> params);
	
	
	
	/**
	 * 获取传入数据查询的SQL代码
	 * @param iPSDEDataQuery
	 * @param params
	 * @return
	 */
	String getSQL(IPSDEDataQuery iPSDEDataQuery, Map<String, Object> params);
}
