package net.ibizsys.model.engine.ba;

import org.springframework.util.StringUtils;

import net.ibizsys.model.PSModelEnums.DBObjNameCaseMode;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.ba.IPSSysBDScheme;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.database.PSSysDBSchemeEngineBaseBase;
import net.ibizsys.model.engine.database.sql.ISQLGenEngine;


public abstract class PSSysBDSchemeEngineBase<M extends IPSSysBDScheme> extends PSSysDBSchemeEngineBaseBase<M> implements IPSSysBDSchemeEngine<M> {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(PSSysBDSchemeEngineBase.class);
	
	private ISQLGenEngine iSQLGenEngine = null;
	private String dbName = null;
	
	
	
	
	@Override
	public void init(IPSModelEngineHolder iPSModelEngineContext, String id, M iPSModelObject) throws Exception {
		if(iPSModelObject.getPSSysModelGroup()!=null) {
			this.setConfigFolder("sysbdscheme." + PSModelUtils.calcUniqueTag(iPSModelObject.getPSSysModelGroup(), iPSModelObject.getCodeName()));
		}
		else {
			this.setConfigFolder("sysbdscheme." + PSModelUtils.calcUniqueTag(iPSModelObject.getPSSystemModule(), iPSModelObject.getCodeName()));
		}
		
		super.init(iPSModelEngineContext, id, iPSModelObject);
	}
	
	
	@Override
	protected void onPrepareSetting() throws Exception {
		this.setDBType(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".dbtype", null));
		if(!StringUtils.hasLength(this.getDBType())) {
			this.setDBType(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".bdtype", null));
		}
		
		if(StringUtils.hasLength(this.getPSModelObject().getCodeName())) {
			this.setDBName(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".dbname", this.getPSModelObject().getCodeName().toLowerCase()));
		}
		else {
			this.setDBName(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".dbname", null));
		}
		if(StringUtils.hasLength(this.getPSModelObject().getDBObjNameCase())) {
			this.setDBObjNameCase(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".dbobjnamecase", this.getPSModelObject().getDBObjNameCase()));
		}
		
		super.onPrepareSetting();
	}
	
	@Override
	protected void onInit() throws Exception {
		
		super.onInit();
	}
	

	
	
	protected void setDBName(String dbName) {
		this.dbName = dbName;
	}
	
	@Override
	public String getDBName() {
		return this.dbName;
	}
	
	
	
	@Override
	public boolean isEnableSQL() {
		return false;
	}
	
	protected ISQLGenEngine getSQLGenEngine(boolean tryMode) throws Exception{
		if(this.iSQLGenEngine != null || tryMode) {
			return this.iSQLGenEngine;
		}
		
		ISQLGenEngine iSQLGenEngine = this.getPSModelEngineHolder().getPSModelEngineAddin(this, this.getDBType(), ISQLGenEngine.class);
		this.iSQLGenEngine = iSQLGenEngine;
		return this.iSQLGenEngine;
	}
	
	protected void setSQLGenEngine(ISQLGenEngine iSQLGenEngine) {
		this.iSQLGenEngine = iSQLGenEngine;
	}

	protected String getRealDBObjName(String name) {
		if(StringUtils.hasLength(name)) {
			if(this.getDBObjNameCaseMode() == DBObjNameCaseMode.DEFAULT) {
				
			}
			else
				if(this.getDBObjNameCaseMode() == DBObjNameCaseMode.LCASE) {
					return name.toLowerCase();
				}
				else
					if(this.getDBObjNameCaseMode() == DBObjNameCaseMode.UCASE) {
						return name.toUpperCase();
					}
		}
		return name;
	}
//
//	@Override
//	public String getSQL(IPSDEDataSet iPSDEDataSet, Map<String, Object> params) {
//		return this.executeAction("获取数据集SQL代码", new IAction<String>() {
//			@Override
//			public String execute(Object[] args) throws Throwable {
//				return onGetSQL(iPSDEDataSet, params);
//			}
//		}, String.class);
//	}
//
//	protected String onGetSQL(IPSDEDataSet iPSDEDataSet, Map<String, Object> params) throws Throwable{
////		List<IPSDEDataQuery> psDEDataQueryList = iPSDEDataSet.getPSDEDataQueries();
////		if(ObjectUtils.isEmpty(psDEDataQueryList)) {
////			throw new Exception("未定义任何数据查询");
////		}
////		
////		for(IPSDEDataQuery iPSDEDataQuery : psDEDataQueryList) {
////			if(ObjectUtils.isEmpty(iPSDEDataQuery.getAllPSDEDataQueryCodes())) {
////				throw new Exception("未定义查询代码");
////			}
////			
////			IPSDEDataQueryCode iPSDEDataQueryCode = this.getPSDEDataQueryCode(iPSDEDataQuery, false);
////			return iPSDEDataQueryCode.getQueryCode();
////		}
////		
////		throw new Exception("未定义查询代码");
//		
//		return getSQLGenEngine(false).generate(iPSDEDataSet, params);
//	}
//
//	protected IPSDEDataQueryCode getPSDEDataQueryCode(IPSDEDataQuery iPSDEDataQuery, boolean tryMode) throws Exception{
//		if(!ObjectUtils.isEmpty(iPSDEDataQuery.getAllPSDEDataQueryCodes())) {
//			for(IPSDEDataQueryCode iPSDEDataQueryCode : iPSDEDataQuery.getAllPSDEDataQueryCodes()) {
//				if(this.getDBType().equalsIgnoreCase(iPSDEDataQueryCode.getDBType())) {
//					return iPSDEDataQueryCode;
//				}
//			}
//		}
//		
//		if(tryMode) {
//			return null;
//		}
//		throw new Exception(String.format("未定义查询代码[%1$s]", this.getDBType()));
//	}
//	
//	@Override
//	public String getSQL(IPSDEDataQuery iPSDEDataQuery, Map<String, Object> params) {
//		return this.executeAction("获取数据查询SQL代码", new IAction<String>() {
//			@Override
//			public String execute(Object[] args) throws Throwable {
//				return onGetSQL(iPSDEDataQuery, params);
//			}
//		}, String.class);
//	}
//	
//	protected String onGetSQL(IPSDEDataQuery iPSDEDataQuery, Map<String, Object> params) throws Throwable{
//		throw new Exception("没有实现");
//	}
//	
	
}
