package net.ibizsys.model.engine.ba;

import net.ibizsys.model.ba.IPSSysBDScheme;
import net.ibizsys.model.engine.database.IPSSysDBSchemeEngineBase;
import net.ibizsys.model.engine.service.IPSSubSysServiceAPIEngineBase;

/**
 * 系统数据库架构引擎对象接口
 * @author lionlau
 *
 */
public interface IPSSysBDSchemeEngine<T extends IPSSysBDScheme> extends IPSSysDBSchemeEngineBase<T>, IPSSubSysServiceAPIEngineBase<T>{

	
	/**
	 * 获取数据库类型
	 * @return
	 */
	String getDBType();
	
	
	
	/**
	 * 获取数据库名称
	 * @return
	 */
	String getDBName();

	
	
	/**
	 * 获取对象名称大小写转化
	 * @return
	 */
	String getDBObjNameCase();
}
