package net.ibizsys.model.engine;

import java.util.List;

import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

import net.ibizsys.model.PSModelEnums.StdDataType;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.ds.IPSDEFilterDTO;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import net.ibizsys.model.engine.plugin.PSModelEngineAddinBase;
import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;
import net.ibizsys.model.engine.util.IEntity;
import net.ibizsys.model.engine.util.ISearchContext;
import net.ibizsys.model.engine.util.JsonUtils;
import net.ibizsys.model.util.DataTypeUtils;

public class PSSystemUtil extends PSModelEngineAddinBase<IPSSystemEngine<?>, Object> implements IPSSystemUtil {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(PSSystemUtil.class);
	
	@Override
	public String getName() {
		return "系统辅助组件";
	}
	

	@Override
	public IEntity createEntity() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IEntity createEntity(Object source) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public IEntity createEntity(Object source, int fieldCaseMode) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Object createEntityDTO(IPSDataEntity iPSDataEntity) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Object createEntityDTO(IPSDEMethodDTO iPSDEMethodDTO) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public ISearchContext createSearchContext() {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Object createSearchContextDTO(IPSDataEntity iPSDataEntity) {
		// TODO Auto-generated method stub
		return null;
	}

	@Override
	public Object createSearchContextDTO(IPSDEFilterDTO iPSDEFilterDTO) {
		// TODO Auto-generated method stub
		return null;
	}
	

	@Override
	public Object serialize(Object obj) {
		Assert.notNull(obj, "不能传入空对象");
		try {
			return JsonUtils.toString(obj);
		} catch (Exception ex) {
			throw new PSModelEngineAddinException(this, String.format("序列化数据对象列表发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	@Override
	public <T> T deserialize(Object objData, Class<T> cls) {
		if (!(objData instanceof String)) {
			throw new PSModelEngineAddinException(this, String.format("无法识别的输入数据"));
		}
		Assert.hasLength((String) objData, "不能传入空数据");
		try {
			return (T) JsonUtils.as((String) objData, cls);

		} catch (Exception ex) {
			throw new PSModelEngineAddinException(this, String.format("反序列化数据对象列表发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	@Override
	public Object convertValue(int dataType, String strValue) {
		try {
			return DataTypeUtils.parse(dataType, strValue);
		} catch (Exception ex) {
			throw new PSModelEngineAddinException(this, String.format("转化值[%1$s]至目标类型[%2$s]发生异常，%3$s", strValue, StdDataType.from(dataType).value, ex.getMessage()), ex);
		}
	}

	@Override
	public Object convertValue(int dataType, Object value) {
		try {
			return DataTypeUtils.convert(dataType, value);
		} catch (Exception ex) {
				throw new PSModelEngineAddinException(this, String.format("转化值[%1$s]至目标类型[%2$s]发生异常，%3$s", value, StdDataType.from(dataType).value, ex.getMessage()), ex);
		}
	}
	
	@Override
	public List convertListValue(int dataType, Object value) {
		
		if(ObjectUtils.isEmpty(value)) {
			return null;
		}
		
		if(value instanceof List) {
			List list = (List)value;
			for(int i = 0;i<list.size();i++) {
				Object item = list.get(i);
				item = this.convertValue(dataType, item);
				list.set(i, item);
			}
			return list;
		}
		
		if(value instanceof String) {
			return this.convertListValue(dataType, (String)value);
		}
		else {
			String strValue = JsonUtils.toString(value);
			return this.convertListValue(dataType, strValue);
		}
		
	}
	
	@Override
	public List convertListValue(int dataType, String strValue) {
		
		if(ObjectUtils.isEmpty(strValue)) {
			return null;
		}
		
		List list = JsonUtils.asList(strValue);
		if(ObjectUtils.isEmpty(list)) {
			return null;
		}
		
		for(int i = 0;i<list.size();i++) {
			Object item = list.get(i);
			item = this.convertValue(dataType, item);
			list.set(i, item);
		}
		return list;
	}
	
	
	@Override
	public boolean testValueCond(Object objSrcValue, String strOp, Object objDstValue, int nSrcValueDataType) {
		try {
			return DataTypeUtils.testCond(objSrcValue, strOp, objDstValue, nSrcValueDataType);
		} catch (Exception ex) {
			throw new PSModelEngineAddinException(this, String.format("判断值条件发生异常，%1$s", ex.getMessage()), ex);
		}
	}

	@Override
	public long compareValue(Object objSrcValue, Object objDstValue, int nValueDataType) {
		return DataTypeUtils.compare(nValueDataType, objSrcValue, objDstValue);
	}

	

}
