package net.ibizsys.model.engine;

import net.ibizsys.model.engine.plugin.PSModelEngineAddinBase;

public class PSSystemLogger extends PSModelEngineAddinBase<IPSSystemEngine<?>, Object> implements IPSSystemLogger {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(PSSystemLogger.class);
	
	@Override
	public String getName() {
		return "系统日志";
	}

	@Override
	public void trace(String logCat, String info, Object data) {
		this.log(LOGLEVEL_TRACE, logCat, info, data);
	}

	@Override
	public void debug(String logCat, String info, Object data) {
		this.log(LOGLEVEL_DEBUG, logCat, info, data);
	}

	@Override
	public void info(String logCat, String info, Object data) {
		this.log(LOGLEVEL_INFO, logCat, info, data);
	}

	@Override
	public void warn(String logCat, String info, Object data) {
		this.log(LOGLEVEL_WARN, logCat, info, data);
	}

	@Override
	public void error(String logCat, String info, Object data) {
		this.log(LOGLEVEL_ERROR, logCat, info, data);
	}

	@Override
	public void fatal(String logCat, String info, Object data) {
		this.log(LOGLEVEL_FATAL, logCat, info, data);
	}

	@Override
	public void log(int logLevel, String logCat, String info, Object data) {
		switch (logLevel) {
		case LOGLEVEL_TRACE:
			log.trace(String.format("[%1$s] %2$s", logCat, info));
			break;
		case LOGLEVEL_DEBUG:
			log.debug(String.format("[%1$s] %2$s", logCat, info));
			break;
		case LOGLEVEL_WARN:
			log.warn(String.format("[%1$s] %2$s", logCat, info));
			break;
		case LOGLEVEL_INFO:
			log.info(String.format("[%1$s] %2$s", logCat, info));
			break;
		case LOGLEVEL_ERROR:
			log.error(String.format("[%1$s] %2$s", logCat, info));
			break;
		case LOGLEVEL_FATAL:
			log.fatal(String.format("[%1$s] %2$s", logCat, info));
			break;
		default:
			log.warn(String.format("[%1$s] %2$s", logCat, info));
			break;
		}
	}

	@Override
	public void logAudit(int logLevel, String logCat, String info, String personId, String strAddress, Object data) {
		switch (logLevel) {
		case LOGLEVEL_TRACE:
			log.trace(String.format("[AUDIT][%1$s] %2$s", logCat, info));
			break;
		case LOGLEVEL_DEBUG:
			log.debug(String.format("[AUDIT][%1$s] %2$s", logCat, info));
			break;
		case LOGLEVEL_WARN:
			log.warn(String.format("[AUDIT][%1$s] %2$s", logCat, info));
			break;
		case LOGLEVEL_INFO:
			log.info(String.format("[AUDIT][%1$s] %2$s", logCat, info));
			break;
		case LOGLEVEL_ERROR:
			log.error(String.format("[AUDIT][%1$s] %2$s", logCat, info));
			break;
		case LOGLEVEL_FATAL:
			log.fatal(String.format("[AUDIT][%1$s] %2$s", logCat, info));
			break;
		default:
			log.warn(String.format("[AUDIT][%1$s] %2$s", logCat, info));
			break;
		}
	}

	@Override
	public void logEvent(int logLevel, String logCat, String info, Object data) {
		switch (logLevel) {
		case LOGLEVEL_TRACE:
			log.trace(String.format("[EVENT][%1$s] %2$s", logCat, info));
			break;
		case LOGLEVEL_DEBUG:
			log.debug(String.format("[EVENT][%1$s] %2$s", logCat, info));
			break;
		case LOGLEVEL_WARN:
			log.warn(String.format("[EVENT][%1$s] %2$s", logCat, info));
			break;
		case LOGLEVEL_INFO:
			log.info(String.format("[EVENT][%1$s] %2$s", logCat, info));
			break;
		case LOGLEVEL_ERROR:
			log.error(String.format("[EVENT][%1$s] %2$s", logCat, info));
			break;
		case LOGLEVEL_FATAL:
			log.fatal(String.format("[EVENT][%1$s] %2$s", logCat, info));
			break;
		default:
			log.warn(String.format("[%1$s] %2$s", logCat, info));
			break;
		}
	}

	@Override
	public void logPO(int logLevel, String logCat, String info, String deName, String action, long time, Object data) {
		switch (logLevel) {
		case LOGLEVEL_TRACE:
			log.trace(String.format("[PO][%1$s] %2$s", logCat, info));
			break;
		case LOGLEVEL_DEBUG:
			log.debug(String.format("[PO][%1$s] %2$s", logCat, info));
			break;
		case LOGLEVEL_WARN:
			log.warn(String.format("[PO][%1$s] %2$s", logCat, info));
			break;
		case LOGLEVEL_INFO:
			log.info(String.format("[PO][%1$s] %2$s", logCat, info));
			break;
		case LOGLEVEL_ERROR:
			log.error(String.format("[PO][%1$s] %2$s", logCat, info));
			break;
		case LOGLEVEL_FATAL:
			log.fatal(String.format("[PO][%1$s] %2$s", logCat, info));
			break;
		default:
			log.warn(String.format("[PO][%1$s] %2$s", logCat, info));
			break;
		}
	}

}
