package net.ibizsys.model.engine;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

import net.ibizsys.model.IPSSystem;
import net.ibizsys.model.engine.security.ISecurityContext;
import net.ibizsys.model.engine.security.SecurityContextHolder;
import net.ibizsys.model.engine.service.client.IWebClient;
import net.ibizsys.model.engine.sysutil.IPSSysUtilEngine;
import net.ibizsys.model.engine.util.IAction;
import net.ibizsys.model.res.IPSSysUtil;

public abstract class PSSystemEngineBase<M extends IPSSystem> extends PSModelEngineBase<M> implements IPSSystemEngine<M> {

	private static final org.apache.commons.logging.Log log = org.apache.commons.logging.LogFactory.getLog(PSSystemEngineBase.class);

	private boolean loaded = false;

	private java.util.Date loadedDate = null;

	private ThreadPoolExecutor workThreadPoolExecutor = null;
	private ScheduledExecutorService timerThreadPoolExecutor = null;

	protected class TimerTask {
		public long time;
		public Runnable runnable;
		public ISecurityContext securityContext;
		public Object tag;
		public String name;
	}

	private List<TimerTask> timerTaskList = new ArrayList<TimerTask>();
	private List<TimerTask> timerTaskList2 = new ArrayList<TimerTask>();
	// private Set<Object> autowareObjectList = new LinkedHashSet<Object>();
	// private boolean bAutowareObjectList = true;

	private boolean threadRunFlag = false;
	private IWebClient<?, ?> defaultWebClient = null;

//	@Override
//	public void init(IPSModelEngineHolder iPSModelEngineHolder, String id, IPSModelObject iPSModelObject) throws Exception {
//		if (!(iPSModelObject instanceof IPSSystem)) {
//			throw new Exception("类型不正确");
//		}
//
//		super.init(iPSModelEngineHolder, id, iPSModelObject);
//
//	}

	@Override
	protected void onInit() throws Exception {

	}

	@Override
	public void start() throws Exception {
		this.onBeforeStart();
		// 启动计时器相关
		this.onStart();
		this.onAfterStart();
		this.markLoaded();
	}

	@Override
	public void shutdown() {
		this.onShutdown();
	}
	
	protected void onShutdown() {
		this.shutdownThreadPoolExecutors();
	}

//	@Override
//	public IPSSystem getPSModelObject() {
//		return (IPSSystem) super.getPSModelObject();
//	}

	public IPSSystem getPSSystem() {
		return (IPSSystem) super.getPSModelObject();
	}

	@Override
	protected void prepareSetting() throws Exception {
		super.prepareSetting();
		prepareThreadPoolExecutors();
	}

//	@Override
//	public Object serialize(Object obj) {
//		return JsonUtils.toString(obj);
//	}
//
//	@Override
//	public <T> T deserialize(Object obj, Class<T> cls) {
//		return JsonUtils.as(obj, cls);
//	}

	


	@Override
	public Object getGlobalParam(String name) {
		// TODO Auto-generated method stub
		return null;
	}

	protected void prepareThreadPoolExecutors() throws Exception {
		this.threadRunFlag = true;

		this.workThreadPoolExecutor = this.createWorkThreadPoolExecutor();
		this.timerThreadPoolExecutor = this.createScheduleThreadPoolExecutor();
		this.timerThreadPoolExecutor.scheduleAtFixedRate(new Runnable() {
			@Override
			public void run() {
				timerThreadRun();

			}
		}, this.getTimerThreadTimer(), this.getTimerThreadTimer(), TimeUnit.MILLISECONDS);
	}

	protected void shutdownThreadPoolExecutors() {
		if (!this.threadRunFlag) {
			return;
		}
		this.threadRunFlag = false;

		this.shutdownWorkThreadPoolExecutor();

		this.shutdownScheduleThreadPoolExecutor();
	}

	protected ThreadPoolExecutor createWorkThreadPoolExecutor() {
		ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(5, getWorkThreadMaximumPoolSize(), 30, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(getWorkThreadBlockingQueueSize()), new ThreadPoolExecutor.AbortPolicy());
		return threadPoolExecutor;
	}

	protected ScheduledExecutorService createScheduleThreadPoolExecutor() {
		return Executors.newScheduledThreadPool(1);
	}

	protected void shutdownWorkThreadPoolExecutor() {
		if (this.workThreadPoolExecutor != null) {
			try {
				this.workThreadPoolExecutor.shutdownNow();
			} catch (Throwable ex) {
				log.error(String.format("关闭工作线程池发生异常，%1$s", ex.getMessage()), ex);
			}
			this.workThreadPoolExecutor = null;
		}
	}

	protected void shutdownScheduleThreadPoolExecutor() {
		if (this.timerThreadPoolExecutor != null) {
			try {
				this.timerThreadPoolExecutor.shutdownNow();
			} catch (Throwable ex) {
				log.error(String.format("关闭定时线程池发生异常，%1$s", ex.getMessage()), ex);
			}
			this.timerThreadPoolExecutor = null;
		}
	}

	protected int getWorkThreadMaximumPoolSize() {
		return 40;
	}

	protected int getWorkThreadBlockingQueueSize() {
		return 2000;
	}

	protected int getTimerThreadTimer() {
		return 1000;
	}

	private void timerThreadRun() {

		if (!this.isThreadRun()) {
			return;
		}

		synchronized (this.timerTaskList) {
			if (this.timerTaskList.size() == 0) {
				return;
			}
			this.timerTaskList2.addAll(this.timerTaskList);
			this.timerTaskList.clear();
		}

		long nCurrentTime = System.currentTimeMillis();

		while (this.timerTaskList2.size() > 0) {
			TimerTask timerTask = timerTaskList2.remove(0);
			if (nCurrentTime >= timerTask.time) {
				ISecurityContext last = SecurityContextHolder.getCurrent();
				SecurityContextHolder.setCurrent(getThreadTaskSecurityContext(timerTask.securityContext));
				threadRun(timerTask.runnable, -1);
				SecurityContextHolder.setCurrent(last);
			} else {
				synchronized (this.timerTaskList) {
					this.timerTaskList.add(timerTask);
				}
			}
		}
	}

	@Override
	public void threadRun(Runnable runnable) {
		threadRun(runnable, -1, null);
	}

	@Override
	public void threadRun(Runnable runnable, long nTime) {
		threadRun(runnable, nTime, null);
	}

	@Override
	public void threadRun(Runnable runnable, long nTime, String strTaskName) {

		if (!this.isThreadRun()) {
			return;
		}

		final ISecurityContext iSecurityContext = SecurityContextHolder.getCurrent();
		if (nTime <= 0) {
			Assert.notNull(this.workThreadPoolExecutor, "后台作业线程池对象无效");
			this.workThreadPoolExecutor.execute(new Runnable() {
				@Override
				public void run() {
					ISecurityContext last = SecurityContextHolder.getCurrent();
					SecurityContextHolder.setCurrent(getThreadTaskSecurityContext(iSecurityContext));
					runnable.run();
					SecurityContextHolder.setCurrent(last);
				}
			});
		} else {
			TimerTask timerTask = new TimerTask();
			timerTask.runnable = runnable;
			timerTask.time = nTime;
			timerTask.securityContext = iSecurityContext;
			timerTask.name = strTaskName;
			synchronized (this.timerTaskList) {
				if (StringUtils.hasLength(strTaskName)) {
					for (int i = 0; i < this.timerTaskList.size(); i++) {
						TimerTask item = timerTaskList.get(i);
						if (StringUtils.hasLength(item.name)) {
							if (item.name.equals(strTaskName)) {
								timerTaskList.remove(i);
								break;
							}
						}
					}
				}
				this.timerTaskList.add(timerTask);
			}
		}
	}

	@Override
	public void threadCancel(String strTaskName) {

		if (!this.isThreadRun()) {
			return;
		}

		Assert.hasLength(strTaskName, "未传入取消任务的名称");
		synchronized (this.timerTaskList) {
			for (int i = 0; i < this.timerTaskList.size(); i++) {
				TimerTask item = timerTaskList.get(i);
				if (StringUtils.hasLength(item.name)) {
					if (item.name.equals(strTaskName)) {
						timerTaskList.remove(i);
						break;
					}
				}
			}
		}
	}

	@Override
	public Object asyncExecute(IAction<?> iAction, Object[] args, Object actionTag) {
		this.threadRun(new Runnable() {
			@Override
			public void run() {
				try {
					iAction.execute(args);
				} catch (Throwable e) {
					log.error(e);
				}
			}
		});
		return null;
	}

	// @Override
	// public Object sseExecute(IAction iAction, Object[] args, Object
	// actionTag, long nTimeout) throws Throwable {
	// return this.asyncExecute(iAction, args, actionTag);
	// }

	protected ISecurityContext getThreadTaskSecurityContext(ISecurityContext iSecurityContext) {
		return iSecurityContext;
	}

	protected boolean isThreadRun() {
		return this.threadRunFlag;
	}

	@Override
	public IWebClient<?, ?> getDefaultWebClient() {
		if (this.defaultWebClient == null) {
			try {
				this.defaultWebClient = this.getPSModelEngineHolder().getPSModelEngineAddin(this, null, IWebClient.class);
			} catch (Exception ex) {
				throw new PSModelEngineException(this, String.format("建立系统默认客户端对象发生异常，%1$s", ex.getMessage()), ex);
			}
		}
		return this.defaultWebClient;
	}

	protected void onBeforeStart() throws Exception {

		// 建立系统日志适配器
		// if (this.getSystemLogAdapter() == null) {
		// try {
		// this.prepareSystemLogAdapter();
		// } catch (Exception ex) {
		// throw new SystemRuntimeException(this,
		// String.format("准备系统日志适配器对象发生异常，%1$s", ex.getMessage()), ex);
		// }
		// }
		//
		// // 准备系统文件夹
		// try {
		// prepareSystemFolders();
		// } catch (Exception ex) {
		// throw new SystemRuntimeException(this,
		// String.format("准备系统文件夹发生异常，%1$s", ex.getMessage()), ex);
		// }
		//
		// // 准备系统引用
		// java.util.List<IPSSysRef> psSysRefs =
		// this.getPSSystem().getAllPSSysRefs();
		// if (!ObjectUtils.isEmpty(psSysRefs)) {
		// for (IPSSysRef iPSSysRef : psSysRefs) {
		// this.registerPSSysRef(iPSSysRef);
		// }
		// }
		//
		// // 准备系统资源
		// java.util.List<IPSSysResource> psSysResources =
		// this.getPSSystem().getAllPSSysResources();
		// if (!ObjectUtils.isEmpty(psSysResources)) {
		// for (IPSSysResource iPSSysResource : psSysResources) {
		// this.registerPSSysResource(iPSSysResource);
		// }
		// }

		// 准备系统基础功能组件
		java.util.List<IPSSysUtil> psSysUtils = this.getPSSystem().getAllPSSysUtils();
		if (psSysUtils != null) {
			for (IPSSysUtil iPSSysUtil : psSysUtils) {

				// 处理排序值小于 100
				if (iPSSysUtil.getOrderValue() >= 0 && iPSSysUtil.getOrderValue() < 100) {
					this.getPSModelEngineHolder().getPSModelEngine(iPSSysUtil, IPSSysUtilEngine.class);
				}
			}
		}

		// // 准备系统模块
		// java.util.List<IPSSystemModule> psSystemModules =
		// this.getPSSystem().getAllPSSystemModules();
		// if (psSystemModules != null) {
		// for (IPSSystemModule iPSSystemModule : psSystemModules) {
		// this.registerPSSystemModule(iPSSystemModule);
		// }
		// }
		//
		// // 准备系统实体组
		// java.util.List<IPSSysDEGroup> psDEGroups =
		// this.getPSSystem().getAllPSSysDEGroups();
		// if (psDEGroups != null) {
		// for (IPSDEGroup iPSDEGroup : psDEGroups) {
		// this.registerPSDEGroup(iPSDEGroup);
		// }
		// }
		//
		// // 准备系统数据库体系
		// java.util.List<IPSSysDBScheme> psSysDBSchemes =
		// this.getPSSystem().getAllPSSysDBSchemes();
		// if (psSysDBSchemes != null) {
		// for (IPSSysDBScheme iPSSysDBScheme : psSysDBSchemes) {
		// this.registerPSSysDBScheme(iPSSysDBScheme);
		// }
		// }
		//
		// // 准备系统大数据体系
		// java.util.List<IPSSysBDScheme> psSysBDSchemes =
		// this.getPSSystem().getAllPSSysBDSchemes();
		// if (psSysBDSchemes != null) {
		// for (IPSSysBDScheme iPSSysBDScheme : psSysBDSchemes) {
		// ISysBDSchemeRuntime iSysBDSchemeRuntime =
		// this.registerPSSysBDScheme(iPSSysBDScheme);
		// if (iSysBDSchemeRuntime != null) {
		// if (iSysBDSchemeRuntime.isDefaultMode() &&
		// this.getDefaultSysBDSchemeRuntime() == null) {
		// this.setDefaultSysBDSchemeRuntime(iSysBDSchemeRuntime);
		// }
		// }
		// }
		// }
		//
		// // 准备系统默认大数据体系
		// if (this.getDefaultSysBDSchemeRuntime() == null) {
		// try {
		// this.prepareDefaultSysBDSchemeRuntime();
		// } catch (Exception ex) {
		// throw new SystemRuntimeException(this,
		// String.format("准备系统默认大数据体系运行时对象发生异常，%1$s", ex.getMessage()), ex);
		// }
		// }
		//
		// // 准备系统外部服务接口
		// java.util.List<IPSSubSysServiceAPI> psSubSysServiceAPIs =
		// this.getPSSystem().getAllPSSubSysServiceAPIs();
		// if (psSubSysServiceAPIs != null) {
		// for (IPSSubSysServiceAPI iPSSubSysServiceAPI : psSubSysServiceAPIs) {
		// this.registerPSSubSysServiceAPI(iPSSubSysServiceAPI);
		// }
		// }

		// // 建立系统持久化适配器
		// ISystemPersistentAdapter iSystemPersistentAdapter =
		// this.createSystemPersistentAdapter();
		// if (iSystemPersistentAdapter != null) {
		// iSystemPersistentAdapter.init(this.getSystemRuntimeContext());
		// this.iSystemPersistentAdapter = iSystemPersistentAdapter;
		// }
		//
		// ISystemAccessManager iSystemAccessManager =
		// this.createSystemAccessManager();
		// if (iSystemAccessManager != null) {
		// iSystemAccessManager.init(this.getSystemRuntimeContext());
		// this.iSystemAccessManager = iSystemAccessManager;
		// }
		//
		// java.util.List<IPSDataEntity> psDataEntityList =
		// this.getPSSystem().getAllPSDataEntities();
		// if (psDataEntityList != null) {
		// for (IPSDataEntity iPSDataEntity : psDataEntityList) {
		// if (StringUtils.hasLength(iPSDataEntity.getId())) {
		// psDataEntityMap.put(iPSDataEntity.getId(), iPSDataEntity);
		// }
		// if (StringUtils.hasLength(iPSDataEntity.getName())) {
		// psDataEntityMap.put(iPSDataEntity.getName().toLowerCase(),
		// iPSDataEntity);
		// if (iPSDataEntity.getPSSystemModule() != null) {
		// psDataEntityMap.put(PSModelUtils.calcUniqueTag(iPSDataEntity.getPSSystemModule(),
		// iPSDataEntity.getName()), iPSDataEntity);
		// }
		// }
		// }
		//
		// }

		// super.onBeforeStart();

		psSysUtils = this.getPSSystem().getAllPSSysUtils();
		if (psSysUtils != null) {
			for (IPSSysUtil iPSSysUtil : psSysUtils) {
				this.getPSModelEngineHolder().getPSModelEngine(iPSSysUtil, IPSSysUtilEngine.class);
			}
		}

		// // 准备系统数据同步代理
		// java.util.List<IPSSysDataSyncAgent> psSysDataSyncAgents =
		// this.getPSSystem().getAllPSSysDataSyncAgents();
		// if (psSysDataSyncAgents != null) {
		// // 先注册输出
		// for (IPSSysDataSyncAgent iPSSysDataSyncAgent : psSysDataSyncAgents) {
		// String strSyncDir = iPSSysDataSyncAgent.getSyncDir();
		// if (SysDataSyncAgentDirs.INOUT.equals(strSyncDir) ||
		// SysDataSyncAgentDirs.OUT.equals(strSyncDir)) {
		// this.getSysDataSyncAgentRuntime(iPSSysDataSyncAgent);
		// }
		// }
		// // 再注册输入
		// for (IPSSysDataSyncAgent iPSSysDataSyncAgent : psSysDataSyncAgents) {
		// String strSyncDir = iPSSysDataSyncAgent.getSyncDir();
		// // 先输出
		// if (SysDataSyncAgentDirs.IN.equals(strSyncDir)) {
		// this.getSysDataSyncAgentRuntime(iPSSysDataSyncAgent);
		// }
		// }
		// }
		//
		// // 预载实体模型
		// if (psDataEntityList != null) {
		// for (IPSDataEntity iPSDataEntity : psDataEntityList) {
		// try {
		// if (testPreloadPSDataEntity(iPSDataEntity)) {
		// IDataEntityRuntime iDataEntityRuntime =
		// this.getDataEntityRuntime(iPSDataEntity.getId());
		// // 调用该语句执行预载
		// iDataEntityRuntime.getKeyPSDEField();
		// }
		// } catch (Exception ex) {
		// throw new SystemRuntimeException(this,
		// String.format("预载实体[%1$s]运行时对象发生异常，%2$s", iPSDataEntity.getName(),
		// ex.getMessage()), ex);
		// }
		// }
		// }
		//
		// // 准备系统服务接口
		// java.util.List<IPSSysServiceAPI> psSysServiceAPIs =
		// this.getPSSystem().getAllPSSysServiceAPIs();
		// if (psSysServiceAPIs != null) {
		// Map<String, String> enableAPIMap = null;
		// String strEnableAPIs =
		// this.getSystemRuntimeSetting().getEnableAPIs();
		// if (StringUtils.hasLength(strEnableAPIs)) {
		// enableAPIMap = new HashMap<String, String>();
		// String[] apis = strEnableAPIs.toLowerCase().split("[;]");
		// for (String api : apis) {
		// enableAPIMap.put(api, "");
		// }
		// }
		//
		// for (IPSSysServiceAPI iPSSysServiceAPI : psSysServiceAPIs) {
		// boolean bEnable = true;
		//
		// /**
		// * 非本地服务类型接口检查是否部署
		// */
		// if
		// (!ServiceType.LOCAL.value.equals(iPSSysServiceAPI.getServiceType()))
		// {
		//
		// if (enableAPIMap != null) {
		// bEnable = false;
		// // 判断是否注册接口，判断代码标识及名称
		// if (StringUtils.hasLength(iPSSysServiceAPI.getCodeName())) {
		// bEnable =
		// enableAPIMap.containsKey(iPSSysServiceAPI.getCodeName().toLowerCase());
		// }
		// if (!bEnable) {
		// if (StringUtils.hasLength(iPSSysServiceAPI.getName())) {
		// bEnable =
		// enableAPIMap.containsKey(iPSSysServiceAPI.getName().toLowerCase());
		// }
		// }
		// }
		// }
		//
		// if (!bEnable) {
		// log.warn(String.format("系统[%1$s]服务接口[%2$s]未启用，忽略加载",
		// this.getDeploySystemId(), iPSSysServiceAPI.getName()));
		// continue;
		// }
		//
		// this.registerPSSysServiceAPI(iPSSysServiceAPI);
		// }
		// }
		// // 准备系统前端应用
		// if (isEnableAppGateway()) {
		// java.util.List<IPSApplication> psApplications =
		// this.getPSSystem().getAllPSApps();
		// if (psApplications != null) {
		// for (IPSApplication iPSApplication : psApplications) {
		// this.registerPSApplication(iPSApplication);
		// }
		// }
		// }
		//
		// // 准备系统后台任务
		// java.util.List<IPSSysBackService> psSysBackServices =
		// this.getPSSystem().getAllPSSysBackServices();
		// if (psSysBackServices != null) {
		// for (IPSSysBackService iPSSysBackService : psSysBackServices) {
		// this.registerPSSysBackService(iPSSysBackService);
		// }
		// }
	}

	protected void onStart() throws Exception {

		// 启动系统功能
		java.util.List<IPSSysUtil> psSysUtils = this.getPSSystem().getAllPSSysUtils();
		if (psSysUtils != null) {
			for (IPSSysUtil iPSSysUtil : psSysUtils) {
				IPSSysUtilEngine<?> iPSSysUtilEngine = this.getPSModelEngineHolder().getPSModelEngine(iPSSysUtil, IPSSysUtilEngine.class);
				try {
					iPSSysUtilEngine.install();
				} catch (Throwable ex) {
					throw new Exception(String.format("安装系统功能组件[%1$s]发生异常，%2$s", iPSSysUtilEngine.getName(), ex.getMessage()), ex);
				}
			}
		}
	}

	protected void onAfterStart() throws Exception {

	}

	/**
	 * 系统加载触发
	 * 
	 * @throws Exception
	 */
	protected void onLoad() throws Exception {

	}

	// @Override
	// public boolean isLoaded() {
	// return this.loaded;
	// }

	protected void markLoaded() throws Exception {
		if (this.loaded) {
			return;
		}
		this.loaded = true;
		this.loadedDate = new java.util.Date();
		this.onLoad();
		// this.fireSystemEvent(SYSTEMEVENT_LOAD, null);
	}

	// @Override
	// public Date getLoadedDate() {
	// return this.loadedDate;
	// }
}
