package net.ibizsys.model.engine;

import net.ibizsys.model.util.Errors;

public class PSModelEngineException extends RuntimeException{

	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;
	
	private int nErrorCode = Errors.INTERNALERROR;
	private IPSModelEngine iPSModelEngine = null;


	public PSModelEngineException(IPSModelEngine iPSModelEngine, String strInfo) {
		super(strInfo);
		this.iPSModelEngine = iPSModelEngine;
	}
	
	public PSModelEngineException(IPSModelEngine iPSModelEngine, String strInfo,int nErrorCode) {
		super(strInfo);
		this.nErrorCode = nErrorCode;
		this.iPSModelEngine = iPSModelEngine;
	}
	
	public PSModelEngineException(IPSModelEngine iPSModelEngine, String strInfo, Throwable throwable) {
		super(strInfo, throwable);
		this.iPSModelEngine = iPSModelEngine;
	}
	
	public PSModelEngineException(IPSModelEngine iPSModelEngine, String strInfo,int nErrorCode, Throwable throwable) {
		super(strInfo, throwable);
		this.nErrorCode = nErrorCode;
		this.iPSModelEngine = iPSModelEngine;
	}
	
	public IPSModelEngine getPSModelEngine() {
		return iPSModelEngine;
	}
	
	public int getErrorCode() {
		return nErrorCode;
	}
	
	public String getFullMessage() {
		if(getPSModelEngine()!=null) {
			return String.format("[%1$s]%2$s", this.getPSModelEngine().getFullName(), this.getMessage());
		}
		return this.getMessage();
	}
	
	public static void rethrow(IPSModelEngine iPSModelEngine, Throwable ex) {
		if(ex instanceof PSModelEngineException) {
			PSModelEngineException psModelEngineException = (PSModelEngineException)ex;
			if(psModelEngineException.getPSModelEngine() == iPSModelEngine) {
				throw (PSModelEngineException)ex;
			}
		}
	}
}
