package net.ibizsys.model.engine;

import java.util.List;

import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.ds.IPSDEFilterDTO;
import net.ibizsys.model.dataentity.service.IPSDEMethodDTO;
import net.ibizsys.model.engine.plugin.IPSModelEngineAddin;
import net.ibizsys.model.engine.util.IEntity;
import net.ibizsys.model.engine.util.ISearchContext;

public interface IPSSystemUtil extends IPSModelEngineAddin<IPSSystemEngine<?>, Object>{

	/**
	 * 建立数据对象
	 * @return
	 */
	IEntity createEntity();
	
	
	/**
	 * 建立数据对象
	 * @param source 数据源
	 * @return
	 */
	IEntity createEntity(Object source);
	
	
	/**
	 * 建立数据对象
	 * @param source 数据源
	 * @param fieldCaseMode 属性转换模式 
	 * @return
	 */
	IEntity createEntity(Object source, int fieldCaseMode);
	
	
	
	/**
	 * 建立数据对象DTO
	 * @param iPSDataEntity
	 * @param source
	 * @return
	 */
	Object createEntityDTO(IPSDataEntity iPSDataEntity);
	
	
	/**
	 * 建立数据对象DTO
	 * @param iPSDEMethodDTO
	 * @param source
	 * @return
	 */
	Object createEntityDTO(IPSDEMethodDTO iPSDEMethodDTO);
	
	
	/**
	 * 建立过滤器对象
	 * @return
	 */
	ISearchContext createSearchContext();
	
	
	/**
	 * 建立过滤器DTO
	 * @param iPSDataEntity
	 * @param source
	 * @return
	 */
	Object createSearchContextDTO(IPSDataEntity iPSDataEntity);
	
	
	/**
	 * 建立过滤器DTO
	 * @param iPSDEFilterDTO
	 * @param source
	 * @return
	 */
	Object createSearchContextDTO(IPSDEFilterDTO iPSDEFilterDTO);
	
	
	/**
	 * 将序列化对象到数据
	 * @param obj
	 * @return
	 */
	Object serialize(Object obj); 
	
	
	/**
	 * 将数据反序列化到对象
	 * @param objData
	 * @param cls 类型
	 * @return
	 */
	<T> T deserialize(Object obj, Class<T> cls);
	
	
	/**
	 * 转化实际值
	 * @param stdDataType
	 * @param value
	 * @return
	 * @throws Exception
	 */
	Object convertValue(int stdDataType, String value);
	
	
	/**
	 * 转化实际值
	 * @param stdDataType
	 * @param value
	 * @return
	 * @throws Exception
	 */
	Object convertValue(int stdDataType, Object value);
	
	
	/**
	 * 转化实际列表值
	 * @param stdDataType
	 * @param value
	 * @return
	 * @throws Exception
	 */
	List convertListValue(int stdDataType, String value);
	
	
	/**
	 * 转化实际列表值
	 * @param stdDataType
	 * @param value
	 * @return
	 * @throws Exception
	 */
	List convertListValue(int stdDataType, Object value);
	
	
	/**
	 * 测试值条件
	 * @param srcValue
	 * @param strOp
	 * @param dstValue
	 * @param valueDataType
	 * @return
	 */
	boolean testValueCond(Object srcValue, String op, Object dstValue, int valueDataType);
	
	
	
	/**
	 * 对比值
	 * @param srcValue
	 * @param dstValue
	 * @param valueDataType
	 * @return
	 */
	long compareValue(Object srcValue, Object dstValue, int valueDataType);
}
