package net.ibizsys.model.engine;

import net.ibizsys.model.engine.plugin.IPSModelEngineAddin;

/**
 * 系统日志对象对象接口
 * @author lionlau
 *
 */
public interface IPSSystemLogger extends IPSModelEngineAddin<IPSSystemEngine<?>, Object>{

	/**
	 * 日志级别，调试
	 */
	public final static int LOGLEVEL_TRACE = 5000;
	
	/**
	 * 日志级别，调试
	 */
	public final static int LOGLEVEL_DEBUG = 10000;
	
	/**
	 * 日志级别，信息
	 */
	public final static int LOGLEVEL_INFO = 20000;
	
	/**
	 * 日志级别，警告
	 */
	public final static int LOGLEVEL_WARN = 30000;
	
	/**
	 * 日志级别，错误
	 */
	public final static int LOGLEVEL_ERROR = 40000;
	
	/**
	 * 日志级别，致命
	 */
	public final static int LOGLEVEL_FATAL = 50000;
	
	
	void trace(String strCat, String strInfo, Object objData);
	
	void debug(String strCat, String strInfo, Object objData);
	
	void info(String strCat, String strInfo, Object objData);
	
	void warn(String strCat, String strInfo, Object objData);
	
	void error(String strCat, String strInfo, Object objData);
	
	void fatal(String strCat, String strInfo, Object objData);
	
	
	/**
	 * 日志常规信息
	 * @param nLogLevel
	 * @param strCat
	 * @param strInfo
	 * @param objData
	 */
	void log(int nLogLevel, String strCat, String strInfo, Object objData);

	
	/**
	 * 日志审计信息
	 * @param nLogLevel
	 * @param strCat
	 * @param strInfo
	 * @param strPersonId
	 * @param strAddress
	 * @param objData
	 */
	void logAudit(int nLogLevel, String strCat, String strInfo, String strPersonId, String strAddress, Object objData);

	/**
	 * 日志事件
	 * @param nLogLevel
	 * @param strCat
	 * @param strInfo
	 * @param objData
	 */
	void logEvent(int nLogLevel, String strCat, String strInfo, Object objData);

	
	/**
	 * 日志性能优化信息
	 * @param nLogLevel
	 * @param strCat
	 * @param strInfo
	 * @param strDEName
	 * @param strAction
	 * @param nTime
	 * @param objData
	 */
	void logPO(int nLogLevel, String strCat, String strInfo, String strDEName, String strAction, long nTime, Object objData);
}
