package net.ibizsys.model.engine;

import net.ibizsys.model.IPSSystem;
import net.ibizsys.model.engine.service.client.IWebClient;
import net.ibizsys.model.engine.util.IAction;

public interface IPSSystemEngine<M extends IPSSystem> extends IPSModelEngine<M>{

	/**
	 * 启动
	 */
	void start() throws Exception;
	
	
	/**
	 * 关闭
	 */
	void shutdown() ;
	
	
	
	
	
	
	
	/**
	 * 获取全部参数
	 * @param name
	 * @return
	 */
	Object getGlobalParam(String name);
	
	
	
	/**
	 * 线程运行
	 * @param runnable
	 */
	void threadRun(java.lang.Runnable runnable);
	
	
	/**
	 * 线程运行
	 * @param runnable
	 * @param time 预期运行时间（毫秒），-1 为立刻执行
	 */
	void threadRun(java.lang.Runnable runnable, long time);
	
	
	/**
	 * 线程运行
	 * @param runnable
	 * @param time 预期运行时间（毫秒），-1 为立刻执行
	 * @param taskName 任务名称
	 */
	void threadRun(java.lang.Runnable runnable, long time, String taskName);
	
	
	/**
	 * 取消线程运行
	 * @param taskName
	 */
	void threadCancel(String taskName);
	
	
	/**
	 * 异步运行作业
	 * @param iAction
	 * @param args
	 * @param actionTag
	 * @return
	 * @throws Throwable
	 */
	Object asyncExecute(IAction<?> iAction, Object[] args, Object actionTag);
	
	
	
	/**
	 * 获取默认Web客户端
	 * @return
	 */
	IWebClient<?,?> getDefaultWebClient();
}
