package net.ibizsys.model.engine;

import java.util.Map;
import java.util.Set;

import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSSystemService;
import net.ibizsys.model.engine.plugin.IPSModelEngineAddin;

/**
 * 模型引擎容器对象
 * @author lionlau
 *
 */
public interface IPSModelEngineHolder {

//	/**
//	 * 
//	 * @return
//	 */
//	String getId();
	
	/**
	 * 配置目录：前端应用
	 */
	final static String CONFIGFOLDER_APP = "app";
	
	/**
	 * 配置目录：系统引用
	 */
	final static String CONFIGFOLDER_SYSREF = "sysref";
	
	/**
	 * 配置目录：大数据库体系
	 */
	final static String CONFIGFOLDER_SYSBDSCHEME = "sysbdscheme";
	
	
	/**
	 * 配置目录：系统集成代理
	 */
	final static String CONFIGFOLDER_SYSEAIAGENT = "syseaiagent";
	
	
	/**
	 * 配置目录：系统资源
	 */
	final static String CONFIGFOLDER_SYSRESOURCE = "sysresource";
	
	
	/**
	 * 配置目录：数据库体系
	 */
	final static String CONFIGFOLDER_SYSDBSCHEME = "sysdbscheme";
	
	
	/**
	 * 配置目录：检索体系
	 */
	final static String CONFIGFOLDER_SYSSEARCHSCHEME = "syssearchscheme";
	
	
	/**
	 * 获取系统模型服务对象
	 * @return
	 * @throws Exception
	 */
	IPSSystemService getPSSystemService();
	
	
	/**
	 * 获取系统模型引擎对象
	 * @return
	 * @throws Exception
	 */
	IPSSystemEngine<?> getPSSystemEngine();
	
	
//	/**
//	 * 获取系统模型引擎对象
//	 * @param psModelEngineCls
//	 * @return
//	 * @throws Exception
//	 */
//	<T extends IPSSystemEngine> T getPSSystemEngine(Class<T> psModelEngineCls) throws Exception;
	
	/**
	 * 获取模型引擎对象
	 * @param iPSModelObject
	 * @param psModelEngineCls
	 * @return
	 * @throws Exception
	 */
	<T extends IPSModelEngine<?>> T getPSModelEngine(IPSModelObject iPSModelObject, Class<T> psModelEngineCls) throws Exception;
	
	/**
	 * 获取模型引擎对象
	 * @param iPSModelObject
	 * @param psModelEngineCls
	 * @param subType 子类型
	 * @return
	 * @throws Exception
	 */
	<T extends IPSModelEngine<?>> T getPSModelEngine(IPSModelObject iPSModelObject, Class<T> psModelEngineCls, String subType) throws Exception;
	
	
	
	/**
	 * 获取模型引擎插件对象
	 * @param iPSModelEngine
	 * @param data 插件数据
	 * @return
	 * @throws Exception
	 */
	<T extends IPSModelEngineAddin<?,?>> T getPSModelEngineAddin(IPSModelEngine<?> iPSModelEngine, Object data, Class<T> psModelEngineCls) throws Exception;
	
	/**
	 * 获取模型引擎插件对象
	 * @param iPSModelEngine
	 * @param data 插件数据
	 * @param subType 子类型
	 * @return
	 * @throws Exception
	 */
	<T extends IPSModelEngineAddin<?,?>> T getPSModelEngineAddin(IPSModelEngine<?> iPSModelEngine, Object data, Class<T> psModelEngineCls, String subType) throws Exception;
	
	
	
	/**
	 * 获取系统日志对象
	 * @return
	 */
	IPSSystemLogger getPSSystemLogger();
	
	
	/**
	 * 获取系统辅助对象
	 * @return
	 */
	IPSSystemUtil getPSSystemUtil();
	
	
	
	/**
	 * 获取动态配置参数
	 * @param key
	 * @return
	 */
	Object getParam(String key);
	
	
	/**
	 * 获取动态配置参数
	 * @param key
	 * @param defaultvalue
	 * @return
	 */
	String getParam(String key, String defaultValue) ;
	
	
	/**
	 * 获取动态配置参数
	 * @param key
	 * @param defaultvalue
	 * @return
	 */
	int getParam(String key, int defaultvalue) throws Exception;
	
	
	/**
	 * 获取动态配置参数
	 * @param key
	 * @param defaultvalue
	 * @return
	 */
	long getParam(String key, long defaultvalue) throws Exception;
	
	
	/**
	 * 获取动态配置参数
	 * @param key
	 * @param defaultvalue
	 * @return
	 */
	double getParam(String key, double defaultvalue) throws Exception;
	
	
	
	
	/**
	 * 获取动态配置参数
	 * @param key
	 * @param defaultvalue
	 * @return
	 */
	boolean getParam(String key, boolean defaultvalue) throws Exception;
	
	
	
	/**
	 * 设置动态配置参数
	 * @param key
	 * @param objValue
	 */
	void setParam(String key, Object value);
	
	
	
	
	
	/**
	 * 获取指定父键的参数集合
	 * @param pkey
	 * @param params
	 * @return
	 */
	Map<String, Object> getParams(String pkey, Map<String, Object> params);
	
	
	
	/**
	 * 设置参数集合，附加父键
	 * @param pkey
	 * @param params
	 */
	void setParams(String pkey, Map<String, Object> params);
	
	
	/**
	 * 设置参数集合，附加父键（目标键不存在时）
	 * @param pkey
	 * @param params
	 */
	void setParamsIf(String pkey, Map<String, Object> params);
	
	
	/**
	 * 判断指定参数是否存在
	 * @param key
	 * @return
	 */
	boolean containsParam(String key);
	
	
	
	/**
	 * 删除参数
	 * @param key
	 */
	void removeParam(String key);
	
	/**
	 * 删除指定父键名参数
	 * @param key
	 */
	void removeParams(String pkey);
	
	
	/**
	 * 删除键名集合
	 * @param keys
	 */
	void removeParams(Set<String> keys) throws Exception;
	
	
	
	/**
	 * 获取模型引擎工厂
	 * @return
	 */
	IPSModelEngineFactory getPSModelEngineFactory();
}
