package net.ibizsys.model.engine;

import net.ibizsys.model.IPSModelObject;

/**
 * 模型引擎对象接口
 * @author lionlau
 *
 */
public interface IPSModelEngine<M extends IPSModelObject> {

	
	/**
	 * 初始化
	 * @param iPSModelEngineHolder
	 * @param id
	 * @param iPSModelObject
	 * @throws Exception
	 */
	void init(IPSModelEngineHolder iPSModelEngineHolder, String id, M iPSModelObject) throws Exception;

	
	
	/**
	 * 获取模型引擎标识
	 * @return
	 */
	String getId();
	
	
	
	/**
	 * 获取名称
	 * @return
	 */
	String getName();
	
	
	/**
	 * 获取完整名称
	 * @return
	 */
	String getFullName();
	
//	/**
//	 * 模型引擎执行
//	 * @param args
//	 * @return
//	 * @throws Throwable
//	 */
//	Object execute(Object[] args) throws Throwable;
	
	
	/**
	 * 获取相关模型对象
	 * @return
	 */
	M getPSModelObject();
	
	
	
	/**
	 * 获取引擎所在的引擎容器
	 * @return
	 */
	IPSModelEngineHolder getPSModelEngineHolder();
}
