/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.engine.util;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.LinkedHashMap;
import java.util.Map;
import net.ibizsys.model.engine.util.IEntity;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class EntityBase
implements IEntity {
    @JsonIgnore
    private Map<String, Object> paramMap = null;

    @Override
    public Object get(String name) {
        if (!StringUtils.hasLength((String)name)) {
            return null;
        }
        name = this.getRealName(name);
        if (this.paramMap != null) {
            return this.paramMap.get(name);
        }
        return null;
    }

    @Override
    @JsonAnySetter
    public void set(String name, Object value) {
        if (!StringUtils.hasLength((String)name)) {
            return;
        }
        name = this.getRealName(name);
        if (this.paramMap == null) {
            this.paramMap = this.createAny();
        }
        this.paramMap.put(name, value);
    }

    @Override
    public boolean contains(String name) {
        if (!StringUtils.hasLength((String)name)) {
            return false;
        }
        name = this.getRealName(name);
        if (this.paramMap != null) {
            return this.paramMap.containsKey(name);
        }
        return false;
    }

    @Override
    public void reset(String name) {
        if (!StringUtils.hasLength((String)name)) {
            return;
        }
        name = this.getRealName(name);
        if (this.paramMap != null) {
            this.paramMap.remove(name);
        }
    }

    @Override
    public void resetAll() {
        this.onResetAll();
    }

    protected void onResetAll() {
        this.paramMap = null;
    }

    @JsonIgnore
    protected int getNameCaseMode() {
        return 0;
    }

    protected String getRealName(String name) {
        switch (this.getNameCaseMode()) {
            case 1: {
                return name.toLowerCase();
            }
            case 2: {
                return name.toUpperCase();
            }
        }
        return name;
    }

    @Override
    public void copyTo(IEntity iEntity) {
        if (this.paramMap != null) {
            for (Map.Entry<String, Object> entry : this.paramMap.entrySet()) {
                iEntity.set(entry.getKey(), entry.getValue());
            }
        }
    }

    @Override
    @JsonAnyGetter
    public Map<String, Object> any() {
        return this.paramMap;
    }

    @JsonIgnore
    protected void setAny(Map<String, Object> map) {
        this.setAny(map, false);
    }

    @JsonIgnore
    protected void setAny(Map<String, Object> map, boolean bCopyMode) {
        if (bCopyMode) {
            if (map == null) {
                this.paramMap = null;
            } else {
                this.paramMap = this.createAny();
                this.paramMap.putAll(map);
            }
        } else {
            this.paramMap = map;
        }
    }

    @JsonIgnore
    protected Map<String, Object> createAny() {
        return new LinkedHashMap<String, Object>();
    }

    @JsonIgnore
    public void putAll(Map<String, Object> map) {
        Assert.notNull(map, (String)"\u4f20\u5165\u53c2\u6570\u65e0\u6548");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
    }
}

