/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.engine.service.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.plugin.IPSModelEngineAddin;
import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;
import net.ibizsys.model.engine.service.client.IWebClientRep;
import net.ibizsys.model.engine.service.client.WebClientBase;
import net.ibizsys.model.engine.service.client.WebClientRep;
import net.ibizsys.model.engine.service.client.WebClientResponseException;
import net.ibizsys.model.engine.util.IEntity;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.text.StringSubstitutor;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPatch;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class WebClient
extends WebClientBase<IPSModelEngine<?>, Object> {
    private static final Log log = LogFactory.getLog(WebClient.class);

    @Override
    public <T> T getProxyClient(Class<?> cls) {
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected <T> IWebClientRep<T> onGet(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Class<T> cls, Object objTag) throws Throwable {
        try {
            String strQueryParam;
            if (StringUtils.hasLength((String)this.getServiceUrl())) {
                strUri = String.format("%1$s%2$s", this.getServiceUrl(), strUri);
            }
            if (uriParams != null) {
                StringSubstitutor sub = new StringSubstitutor(uriParams);
                sub.setVariablePrefix("{");
                sub.setVariableSuffix("}");
                strUri = sub.replace(strUri);
            }
            if (queries != null && StringUtils.hasLength((String)(strQueryParam = WebClient.getUrlParams(queries, false)))) {
                strUri = strUri.indexOf("?") == -1 ? strUri + "?" : strUri + "&";
                strUri = strUri + strQueryParam;
            }
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                Object t;
                CloseableHttpResponse closeableHttpResponse;
                int statusCode;
                Map<String, ?> globalHeaders;
                HttpGet request = new HttpGet(strUri);
                if (headers != null) {
                    for (String string : headers.keySet()) {
                        request.addHeader(string, (String)headers.get(string));
                    }
                }
                if ((globalHeaders = this.getHeaders()) != null) {
                    for (String strHeader : globalHeaders.keySet()) {
                        request.addHeader(strHeader, (String)globalHeaders.get(strHeader));
                    }
                }
                if ((statusCode = (closeableHttpResponse = httpClient.execute((HttpUriRequest)request)).getStatusLine().getStatusCode()) < 200 || statusCode >= 300) {
                    String statusText = closeableHttpResponse.getStatusLine().getReasonPhrase();
                    throw this.createWebClientResponseException(statusCode, statusText, (HttpResponse)closeableHttpResponse);
                }
                String responseBody = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
                LinkedMultiValueMap headersMap = null;
                if (closeableHttpResponse.getAllHeaders() != null) {
                    headersMap = new LinkedMultiValueMap();
                    for (Header header : closeableHttpResponse.getAllHeaders()) {
                        headersMap.add((Object)header.getName(), (Object)header.getValue());
                    }
                }
                if (cls.isAssignableFrom(String.class)) {
                    t = responseBody;
                    WebClientRep<String> webClientRep = new WebClientRep<String>((String)t, (MultiValueMap<String, String>)headersMap);
                    return webClientRep;
                }
                t = WebClient.getMapper().readValue(responseBody, cls);
                WebClientRep<Object> webClientRep = new WebClientRep<Object>(t, (MultiValueMap<String, String>)headersMap);
                return webClientRep;
            }
        }
        catch (Throwable ex) {
            PSModelEngineAddinException.rethrow(this, ex);
            throw new PSModelEngineAddinException((IPSModelEngineAddin)this, String.format("\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected <T> IWebClientRep<T> onPost(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object body, String strContentType, Class<T> cls, Object objTag) throws Throwable {
        try {
            String strQueryParam;
            if (StringUtils.hasLength((String)this.getServiceUrl())) {
                strUri = String.format("%1$s%2$s", this.getServiceUrl(), strUri);
            }
            if (uriParams != null) {
                StringSubstitutor sub = new StringSubstitutor(uriParams);
                sub.setVariablePrefix("{");
                sub.setVariableSuffix("}");
                strUri = sub.replace(strUri);
            }
            if (queries != null && StringUtils.hasLength((String)(strQueryParam = WebClient.getUrlParams(queries, false)))) {
                strUri = strUri.indexOf("?") == -1 ? strUri + "?" : strUri + "&";
                strUri = strUri + strQueryParam;
            }
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                Object t;
                CloseableHttpResponse closeableHttpResponse;
                int statusCode;
                Map<String, ?> globalHeaders;
                HttpPost request = new HttpPost(strUri);
                if (headers != null) {
                    for (String string : headers.keySet()) {
                        request.addHeader(string, (String)headers.get(string));
                    }
                }
                if ((globalHeaders = this.getHeaders()) != null) {
                    for (String strHeader : globalHeaders.keySet()) {
                        request.addHeader(strHeader, (String)globalHeaders.get(strHeader));
                    }
                }
                if (body != null) {
                    request.setEntity(this.getHttpEntity(strContentType, body));
                }
                if ((statusCode = (closeableHttpResponse = httpClient.execute((HttpUriRequest)request)).getStatusLine().getStatusCode()) < 200 || statusCode >= 300) {
                    String statusText = closeableHttpResponse.getStatusLine().getReasonPhrase();
                    throw this.createWebClientResponseException(statusCode, statusText, (HttpResponse)closeableHttpResponse);
                }
                String responseBody = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
                LinkedMultiValueMap headersMap = null;
                if (closeableHttpResponse.getAllHeaders() != null) {
                    headersMap = new LinkedMultiValueMap();
                    for (Header header : closeableHttpResponse.getAllHeaders()) {
                        headersMap.add((Object)header.getName(), (Object)header.getValue());
                    }
                }
                if (cls.isAssignableFrom(String.class)) {
                    t = responseBody;
                    WebClientRep<String> webClientRep = new WebClientRep<String>((String)t, (MultiValueMap<String, String>)headersMap);
                    return webClientRep;
                }
                t = WebClient.getMapper().readValue(responseBody, cls);
                WebClientRep<Object> webClientRep = new WebClientRep<Object>(t, (MultiValueMap<String, String>)headersMap);
                return webClientRep;
            }
        }
        catch (Throwable ex) {
            PSModelEngineAddinException.rethrow(this, ex);
            throw new PSModelEngineAddinException((IPSModelEngineAddin)this, String.format("\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected <T> IWebClientRep<T> onPut(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object body, String strContentType, Class<T> cls, Object objTag) throws Throwable {
        try {
            String strQueryParam;
            if (StringUtils.hasLength((String)this.getServiceUrl())) {
                strUri = String.format("%1$s%2$s", this.getServiceUrl(), strUri);
            }
            if (uriParams != null) {
                StringSubstitutor sub = new StringSubstitutor(uriParams);
                sub.setVariablePrefix("{");
                sub.setVariableSuffix("}");
                strUri = sub.replace(strUri);
            }
            if (queries != null && StringUtils.hasLength((String)(strQueryParam = WebClient.getUrlParams(queries, false)))) {
                strUri = strUri.indexOf("?") == -1 ? strUri + "?" : strUri + "&";
                strUri = strUri + strQueryParam;
            }
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                Object t;
                CloseableHttpResponse closeableHttpResponse;
                int statusCode;
                Map<String, ?> globalHeaders;
                HttpPut request = new HttpPut(strUri);
                if (headers != null) {
                    for (String string : headers.keySet()) {
                        request.addHeader(string, (String)headers.get(string));
                    }
                }
                if ((globalHeaders = this.getHeaders()) != null) {
                    for (String strHeader : globalHeaders.keySet()) {
                        request.addHeader(strHeader, (String)globalHeaders.get(strHeader));
                    }
                }
                if (body != null) {
                    request.setEntity(this.getHttpEntity(strContentType, body));
                }
                if ((statusCode = (closeableHttpResponse = httpClient.execute((HttpUriRequest)request)).getStatusLine().getStatusCode()) < 200 || statusCode >= 300) {
                    String statusText = closeableHttpResponse.getStatusLine().getReasonPhrase();
                    throw this.createWebClientResponseException(statusCode, statusText, (HttpResponse)closeableHttpResponse);
                }
                String responseBody = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
                LinkedMultiValueMap headersMap = null;
                if (closeableHttpResponse.getAllHeaders() != null) {
                    headersMap = new LinkedMultiValueMap();
                    for (Header header : closeableHttpResponse.getAllHeaders()) {
                        headersMap.add((Object)header.getName(), (Object)header.getValue());
                    }
                }
                if (cls.isAssignableFrom(String.class)) {
                    t = responseBody;
                    WebClientRep<String> webClientRep = new WebClientRep<String>((String)t, (MultiValueMap<String, String>)headersMap);
                    return webClientRep;
                }
                t = WebClient.getMapper().readValue(responseBody, cls);
                WebClientRep<Object> webClientRep = new WebClientRep<Object>(t, (MultiValueMap<String, String>)headersMap);
                return webClientRep;
            }
        }
        catch (Throwable ex) {
            PSModelEngineAddinException.rethrow(this, ex);
            throw new PSModelEngineAddinException((IPSModelEngineAddin)this, String.format("\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected <T> IWebClientRep<T> onPatch(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object body, String strContentType, Class<T> cls, Object objTag) throws Throwable {
        try {
            String strQueryParam;
            if (StringUtils.hasLength((String)this.getServiceUrl())) {
                strUri = String.format("%1$s%2$s", this.getServiceUrl(), strUri);
            }
            if (uriParams != null) {
                StringSubstitutor sub = new StringSubstitutor(uriParams);
                sub.setVariablePrefix("{");
                sub.setVariableSuffix("}");
                strUri = sub.replace(strUri);
            }
            if (queries != null && StringUtils.hasLength((String)(strQueryParam = WebClient.getUrlParams(queries, false)))) {
                strUri = strUri.indexOf("?") == -1 ? strUri + "?" : strUri + "&";
                strUri = strUri + strQueryParam;
            }
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                Object t;
                CloseableHttpResponse closeableHttpResponse;
                int statusCode;
                Map<String, ?> globalHeaders;
                HttpPatch request = new HttpPatch(strUri);
                if (headers != null) {
                    for (String string : headers.keySet()) {
                        request.addHeader(string, (String)headers.get(string));
                    }
                }
                if ((globalHeaders = this.getHeaders()) != null) {
                    for (String strHeader : globalHeaders.keySet()) {
                        request.addHeader(strHeader, (String)globalHeaders.get(strHeader));
                    }
                }
                if (body != null) {
                    request.setEntity(this.getHttpEntity(strContentType, body));
                }
                if ((statusCode = (closeableHttpResponse = httpClient.execute((HttpUriRequest)request)).getStatusLine().getStatusCode()) < 200 || statusCode >= 300) {
                    String statusText = closeableHttpResponse.getStatusLine().getReasonPhrase();
                    throw this.createWebClientResponseException(statusCode, statusText, (HttpResponse)closeableHttpResponse);
                }
                String responseBody = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
                LinkedMultiValueMap headersMap = null;
                if (closeableHttpResponse.getAllHeaders() != null) {
                    headersMap = new LinkedMultiValueMap();
                    for (Header header : closeableHttpResponse.getAllHeaders()) {
                        headersMap.add((Object)header.getName(), (Object)header.getValue());
                    }
                }
                if (cls.isAssignableFrom(String.class)) {
                    t = responseBody;
                    WebClientRep<String> webClientRep = new WebClientRep<String>((String)t, (MultiValueMap<String, String>)headersMap);
                    return webClientRep;
                }
                t = WebClient.getMapper().readValue(responseBody, cls);
                WebClientRep<Object> webClientRep = new WebClientRep<Object>(t, (MultiValueMap<String, String>)headersMap);
                return webClientRep;
            }
        }
        catch (Throwable ex) {
            PSModelEngineAddinException.rethrow(this, ex);
            throw new PSModelEngineAddinException((IPSModelEngineAddin)this, String.format("\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected <T> IWebClientRep<T> onDelete(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Class<T> cls, Object objTag) throws Throwable {
        try {
            String strQueryParam;
            if (StringUtils.hasLength((String)this.getServiceUrl())) {
                strUri = String.format("%1$s%2$s", this.getServiceUrl(), strUri);
            }
            if (uriParams != null) {
                StringSubstitutor sub = new StringSubstitutor(uriParams);
                sub.setVariablePrefix("{");
                sub.setVariableSuffix("}");
                strUri = sub.replace(strUri);
            }
            if (queries != null && StringUtils.hasLength((String)(strQueryParam = WebClient.getUrlParams(queries, false)))) {
                strUri = strUri.indexOf("?") == -1 ? strUri + "?" : strUri + "&";
                strUri = strUri + strQueryParam;
            }
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                Object t;
                CloseableHttpResponse closeableHttpResponse;
                int statusCode;
                Map<String, ?> globalHeaders;
                HttpDelete request = new HttpDelete(strUri);
                if (headers != null) {
                    for (String string : headers.keySet()) {
                        request.addHeader(string, (String)headers.get(string));
                    }
                }
                if ((globalHeaders = this.getHeaders()) != null) {
                    for (String strHeader : globalHeaders.keySet()) {
                        request.addHeader(strHeader, (String)globalHeaders.get(strHeader));
                    }
                }
                if ((statusCode = (closeableHttpResponse = httpClient.execute((HttpUriRequest)request)).getStatusLine().getStatusCode()) < 200 || statusCode >= 300) {
                    String statusText = closeableHttpResponse.getStatusLine().getReasonPhrase();
                    throw this.createWebClientResponseException(statusCode, statusText, (HttpResponse)closeableHttpResponse);
                }
                String responseBody = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
                LinkedMultiValueMap headersMap = null;
                if (closeableHttpResponse.getAllHeaders() != null) {
                    headersMap = new LinkedMultiValueMap();
                    for (Header header : closeableHttpResponse.getAllHeaders()) {
                        headersMap.add((Object)header.getName(), (Object)header.getValue());
                    }
                }
                if (cls.isAssignableFrom(String.class)) {
                    t = responseBody;
                    WebClientRep<String> webClientRep = new WebClientRep<String>((String)t, (MultiValueMap<String, String>)headersMap);
                    return webClientRep;
                }
                t = WebClient.getMapper().readValue(responseBody, cls);
                WebClientRep<Object> webClientRep = new WebClientRep<Object>(t, (MultiValueMap<String, String>)headersMap);
                return webClientRep;
            }
        }
        catch (Throwable ex) {
            PSModelEngineAddinException.rethrow(this, ex);
            throw new PSModelEngineAddinException((IPSModelEngineAddin)this, String.format("\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IWebClientRep<?> onUpload(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objFile, Object objTag) throws Throwable {
        try {
            String strQueryParam;
            if (StringUtils.hasLength((String)this.getServiceUrl())) {
                strUri = String.format("%1$s%2$s", this.getServiceUrl(), strUri);
            }
            if (uriParams != null) {
                StringSubstitutor sub = new StringSubstitutor(uriParams);
                sub.setVariablePrefix("{");
                sub.setVariableSuffix("}");
                strUri = sub.replace(strUri);
            }
            if (queries != null && StringUtils.hasLength((String)(strQueryParam = WebClient.getUrlParams(queries, false)))) {
                strUri = strUri.indexOf("?") == -1 ? strUri + "?" : strUri + "&";
                strUri = strUri + strQueryParam;
            }
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                HttpEntity entity;
                Map<String, ?> globalHeaders;
                HttpPost request = new HttpPost(strUri);
                if (headers != null) {
                    for (String string : headers.keySet()) {
                        request.addHeader(string, (String)headers.get(string));
                    }
                }
                if ((globalHeaders = this.getHeaders()) != null) {
                    for (String strHeader : globalHeaders.keySet()) {
                        request.addHeader(strHeader, (String)globalHeaders.get(strHeader));
                    }
                }
                if (objFile instanceof File) {
                    File file = (File)objFile;
                    entity = MultipartEntityBuilder.create().addBinaryBody("file", file, ContentType.DEFAULT_BINARY, file.getName()).build();
                    request.setEntity(entity);
                } else {
                    if (!(objFile instanceof InputStream)) throw new Exception("\u65e0\u6cd5\u8bc6\u522b\u7684\u6587\u4ef6\u5bf9\u8c61");
                    InputStream inputStream = (InputStream)objFile;
                    entity = MultipartEntityBuilder.create().addBinaryBody("file", inputStream).build();
                    request.setEntity(entity);
                }
                CloseableHttpResponse closeableHttpResponse = httpClient.execute((HttpUriRequest)request);
                int statusCode = closeableHttpResponse.getStatusLine().getStatusCode();
                if (statusCode < 200 || statusCode >= 300) {
                    String statusText = closeableHttpResponse.getStatusLine().getReasonPhrase();
                    throw this.createWebClientResponseException(statusCode, statusText, (HttpResponse)closeableHttpResponse);
                }
                String responseBody = EntityUtils.toString((HttpEntity)closeableHttpResponse.getEntity());
                LinkedMultiValueMap headersMap = null;
                if (closeableHttpResponse.getAllHeaders() != null) {
                    headersMap = new LinkedMultiValueMap();
                    for (Header header : closeableHttpResponse.getAllHeaders()) {
                        headersMap.add((Object)header.getName(), (Object)header.getValue());
                    }
                }
                Header[] headerArray = new WebClientRep(responseBody, (MultiValueMap<String, String>)headersMap);
                return headerArray;
            }
        }
        catch (Throwable ex) {
            PSModelEngineAddinException.rethrow(this, ex);
            throw new PSModelEngineAddinException((IPSModelEngineAddin)this, String.format("\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected IWebClientRep<?> onDownload(String strUri, Map<String, ?> uriParams, Map<String, ?> headers, Map<String, ?> queries, Object objFile, Object objTag) throws Throwable {
        try {
            String strQueryParam;
            if (StringUtils.hasLength((String)this.getServiceUrl())) {
                strUri = String.format("%1$s%2$s", this.getServiceUrl(), strUri);
            }
            if (uriParams != null) {
                StringSubstitutor sub = new StringSubstitutor(uriParams);
                sub.setVariablePrefix("{");
                sub.setVariableSuffix("}");
                strUri = sub.replace(strUri);
            }
            if (queries != null && StringUtils.hasLength((String)(strQueryParam = WebClient.getUrlParams(queries, false)))) {
                strUri = strUri.indexOf("?") == -1 ? strUri + "?" : strUri + "&";
                strUri = strUri + strQueryParam;
            }
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                Map<String, ?> globalHeaders;
                HttpGet request = new HttpGet(strUri);
                if (headers != null) {
                    for (String string : headers.keySet()) {
                        request.addHeader(string, (String)headers.get(string));
                    }
                }
                if ((globalHeaders = this.getHeaders()) != null) {
                    for (String strHeader : globalHeaders.keySet()) {
                        request.addHeader(strHeader, (String)globalHeaders.get(strHeader));
                    }
                }
                Object var11_16 = null;
                OutputStream outputStream = null;
                Object writer = null;
                if (objFile instanceof File) {
                    File file = (File)objFile;
                } else {
                    if (!(objFile instanceof OutputStream)) throw new Exception("\u65e0\u6cd5\u8bc6\u522b\u7684\u6587\u4ef6\u8f93\u51fa\u5bf9\u8c61");
                    outputStream = (OutputStream)objFile;
                }
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                int statusCode = response.getStatusLine().getStatusCode();
                if (statusCode < 200 || statusCode >= 300) {
                    String statusText = response.getStatusLine().getReasonPhrase();
                    throw this.createWebClientResponseException(statusCode, statusText, (HttpResponse)response);
                }
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    Header[] headerArray;
                    InputStream inStream;
                    if (outputStream == null) {
                        inStream = entity.getContent();
                        headerArray = null;
                        try {
                            void var11_18;
                            FileUtils.copyInputStreamToFile((InputStream)inStream, (File)var11_18);
                        }
                        catch (Throwable object) {
                            headerArray = object;
                            throw object;
                        }
                        finally {
                            if (inStream != null) {
                                if (headerArray != null) {
                                    try {
                                        inStream.close();
                                    }
                                    catch (Throwable throwable) {
                                        headerArray.addSuppressed(throwable);
                                    }
                                } else {
                                    inStream.close();
                                }
                            }
                        }
                    }
                    inStream = entity.getContent();
                    headerArray = null;
                    try {
                        IOUtils.copyLarge((InputStream)inStream, (OutputStream)outputStream);
                    }
                    catch (Throwable throwable) {
                        headerArray = throwable;
                        throw throwable;
                    }
                    finally {
                        if (inStream != null) {
                            if (headerArray != null) {
                                try {
                                    inStream.close();
                                }
                                catch (Throwable throwable) {
                                    headerArray.addSuppressed(throwable);
                                }
                            } else {
                                inStream.close();
                            }
                        }
                    }
                }
                EntityUtils.consume((HttpEntity)entity);
                LinkedMultiValueMap headersMap = null;
                if (response.getAllHeaders() != null) {
                    headersMap = new LinkedMultiValueMap();
                    for (Header header : response.getAllHeaders()) {
                        headersMap.add((Object)header.getName(), (Object)header.getValue());
                    }
                }
                String strFileName = null;
                List list = (List)headersMap.get((Object)"Content-Disposition");
                if (!ObjectUtils.isEmpty((Object)list) && (strFileName = (String)list.get(0)).indexOf("attachment;filename=") == 0) {
                    strFileName = strFileName.substring("attachment;filename=".length());
                }
                WebClientRep<String> webClientRep = new WebClientRep<String>(strFileName, (MultiValueMap<String, String>)headersMap);
                return webClientRep;
            }
        }
        catch (Throwable ex) {
            PSModelEngineAddinException.rethrow(this, ex);
            throw new PSModelEngineAddinException((IPSModelEngineAddin)this, String.format("\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected WebClientResponseException createWebClientResponseException(int statusCode, String statusText, HttpResponse response) {
        String responseBody = null;
        if (response != null) {
            try {
                responseBody = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (Exception ex) {
                log.error((Object)ex);
            }
            if (StringUtils.hasLength((String)responseBody) && responseBody.indexOf("{") == 0) {
                try {
                    JsonNode messageNode;
                    JsonNode jsonNode = WebClient.getMapper().readTree(responseBody);
                    if (jsonNode instanceof ObjectNode && (messageNode = ((ObjectNode)jsonNode).get("message")) != null && !messageNode.isNull()) {
                        statusText = messageNode.asText();
                    }
                }
                catch (Exception ex) {
                    log.error((Object)ex);
                }
            }
        }
        if (!StringUtils.hasLength((String)statusText)) {
            // empty if block
        }
        return new WebClientResponseException(this, statusCode, statusText, responseBody);
    }

    protected HttpEntity getHttpEntity(String strContentType, Object body) throws Exception {
        if (ObjectUtils.isEmpty((Object)strContentType) || strContentType.equals(ContentType.APPLICATION_JSON.getMimeType())) {
            String strBody = null;
            strBody = body instanceof String ? (String)body : WebClient.getOutMapper().writeValueAsString(body);
            return new StringEntity(strBody, ContentType.create((String)ContentType.APPLICATION_JSON.getMimeType(), (String)"UTF-8"));
        }
        if (strContentType.equals(ContentType.APPLICATION_FORM_URLENCODED.getMimeType())) {
            return new UrlEncodedFormEntity(this.getFormData(body), "UTF-8");
        }
        if (strContentType.equals(ContentType.TEXT_XML.getMimeType()) || strContentType.equals(ContentType.TEXT_HTML.getMimeType()) || strContentType.equals(ContentType.TEXT_PLAIN.getMimeType())) {
            String content = "";
            if (body != null) {
                content = body.toString();
            }
            return new StringEntity(content, ContentType.create((String)strContentType, (String)"UTF-8"));
        }
        throw new Exception(String.format("\u672a\u652f\u6301\u7684\u5185\u5bb9\u7c7b\u578b[%1$s]", strContentType));
    }

    protected List<NameValuePair> getFormData(Object body) throws Exception {
        Map<String, Object> map = null;
        if (body instanceof Map) {
            map = (Map<String, Object>)body;
        } else if (body instanceof IEntity) {
            map = ((IEntity)body).any();
        } else {
            throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u7684\u5185\u5bb9\u5bf9\u8c61", new Object[0]));
        }
        ArrayList<NameValuePair> formParams = new ArrayList<NameValuePair>();
        LinkedMultiValueMap parts = new LinkedMultiValueMap();
        if (map != null) {
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                Object objValue = entry.getValue();
                if (objValue == null) {
                    formParams.add((NameValuePair)new BasicNameValuePair(entry.getKey(), ""));
                    continue;
                }
                formParams.add((NameValuePair)new BasicNameValuePair(entry.getKey(), objValue.toString()));
            }
        }
        return formParams;
    }
}

