/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.engine.service;

import com.fasterxml.jackson.databind.node.ObjectNode;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.PSModelEngineException;
import net.ibizsys.model.engine.plugin.IPSModelEngineScript;
import net.ibizsys.model.engine.service.IPSSubSysServiceAPIEngine;
import net.ibizsys.model.engine.service.PSSubSysServiceAPIEngineBaseBase;
import net.ibizsys.model.engine.service.client.IWebClient;
import net.ibizsys.model.engine.service.client.IWebClientRep;
import net.ibizsys.model.engine.util.JsonUtils;
import net.ibizsys.model.service.IPSSubSysServiceAPI;
import net.ibizsys.model.system.IPSSystemModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.entity.ContentType;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class PSSubSysServiceAPIEngineBase<M extends IPSSubSysServiceAPI>
extends PSSubSysServiceAPIEngineBaseBase<M>
implements IPSSubSysServiceAPIEngine<M> {
    private static final Log log = LogFactory.getLog(PSSubSysServiceAPIEngineBase.class);
    private Map<String, Object> globalHeaderMap = null;
    private Map<String, Object> defaultHeaderMap = null;
    private IWebClient<?, ?> iWebClient = null;
    private long tokenTimeout = 0L;
    private String serviceType = null;
    private String serviceParam3 = null;
    private String serviceParam4 = null;
    private String authParam3 = null;
    private String authParam4 = null;
    private IPSModelEngineScript<?> authPSModelEngineScript = null;

    @Override
    public void init(IPSModelEngineHolder iPSModelEngineHolder, String id, M iPSModelObject) throws Exception {
        this.setConfigFolder("subsysserviceapi." + PSModelUtils.calcUniqueTag((IPSSystemModule)iPSModelObject.getPSSystemModule(), (String)iPSModelObject.getCodeName()));
        super.init(iPSModelEngineHolder, id, iPSModelObject);
    }

    @Override
    protected void onPrepareSetting() throws Exception {
        this.setServiceType(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".servicetype", ((IPSSubSysServiceAPI)this.getPSModelObject()).getServiceType()));
        this.setServiceParam3(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".serviceparam3", ((IPSSubSysServiceAPI)this.getPSModelObject()).getServiceParam3()));
        this.setServiceParam4(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".serviceparam4", ((IPSSubSysServiceAPI)this.getPSModelObject()).getServiceParam4()));
        this.setAuthParam3(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".authparam3", ((IPSSubSysServiceAPI)this.getPSModelObject()).getAuthParam3()));
        this.setAuthParam4(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".authparam4", ((IPSSubSysServiceAPI)this.getPSModelObject()).getAuthParam4()));
        super.onPrepareSetting();
    }

    @Override
    protected void onInit() throws Exception {
        this.setHeaders(null);
        super.onInit();
        this.prepareAuthUtil();
    }

    protected String getMethodScriptCode() {
        return ((IPSSubSysServiceAPI)this.getPSModelObject()).getMethodScriptCode();
    }

    protected String getAuthScriptCode() {
        return ((IPSSubSysServiceAPI)this.getPSModelObject()).getAuthScriptCode();
    }

    @Override
    public void setHeaders(Map<String, ?> headers) {
        if (this.defaultHeaderMap == null) {
            Iterator fields;
            ObjectNode objectNode;
            ConcurrentHashMap<String, String> defaultMap = new ConcurrentHashMap<String, String>();
            if (this.getPSModelObject() != null && (objectNode = ((IPSSubSysServiceAPI)this.getPSModelObject()).getHeaderParams()) != null && (fields = objectNode.fieldNames()) != null) {
                while (fields.hasNext()) {
                    String strName = (String)fields.next();
                    defaultMap.put(strName, objectNode.get(strName).textValue());
                }
            }
            this.defaultHeaderMap = Collections.unmodifiableMap(defaultMap);
        }
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        map.putAll(this.defaultHeaderMap);
        if (headers != null) {
            map.putAll(headers);
        }
        this.globalHeaderMap = map == null || map.size() == 0 ? null : Collections.unmodifiableMap(map);
    }

    @Override
    public Map<String, ?> getHeaders(boolean bAuthMode) {
        if (bAuthMode) {
            return this.defaultHeaderMap;
        }
        return this.globalHeaderMap;
    }

    @Override
    public Map<String, ?> getHeaders() {
        return this.getHeaders(false);
    }

    @Override
    public IWebClient<?, ?> getWebClient() {
        try {
            return this.getWebClient(false);
        }
        catch (Exception ex) {
            throw new PSModelEngineException((IPSModelEngine)this, String.format("WebClient\u5bf9\u8c61\u65e0\u6548\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected IWebClient<?, ?> getWebClient(boolean bTryMode) throws Exception {
        if (this.iWebClient != null || bTryMode) {
            return this.iWebClient;
        }
        this.iWebClient = this.createWebClient();
        return this.iWebClient;
    }

    protected IWebClient<?, ?> createWebClient() throws Exception {
        return this.getPSModelEngineHolder().getPSModelEngineAddin(this, null, IWebClient.class);
    }

    @Override
    public long getTokenTimeout() {
        return this.tokenTimeout;
    }

    @Override
    public void setTokenTimeout(long tokenTimeout) {
        this.tokenTimeout = tokenTimeout;
    }

    @Override
    public void tokenExpireIn(int nSeconds) {
        if (nSeconds >= 0) {
            this.setTokenTimeout(System.currentTimeMillis() + (long)(nSeconds * 1000));
        }
    }

    @Override
    public String getServiceType() {
        return this.serviceType;
    }

    protected void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    @Override
    public String getServiceParam3() {
        return this.serviceParam3;
    }

    protected void setServiceParam3(String serviceParam3) {
        this.serviceParam3 = serviceParam3;
    }

    @Override
    public String getServiceParam4() {
        return this.serviceParam4;
    }

    protected void setServiceParam4(String serviceParam4) {
        this.serviceParam4 = serviceParam4;
    }

    @Override
    public String getAuthParam3() {
        return this.authParam3;
    }

    protected void setAuthParam3(String authParam3) {
        this.authParam3 = authParam3;
    }

    @Override
    public String getAuthParam4() {
        return this.authParam4;
    }

    protected void setAuthParam4(String authParam4) {
        this.authParam4 = authParam4;
    }

    protected void prepareAuthUtil() throws Exception {
        if (StringUtils.hasLength((String)this.getAuthMode()) && !PSModelEnums.APIAuthMode.NONE.value.equals(this.getAuthMode())) {
            if (this.getAuthPSModelEngineScript() == null) {
                this.prepareAuthPSModelEngineScript();
            }
            this.runAuthTimer(true);
        }
    }

    protected IPSModelEngineScript<?> getAuthPSModelEngineScript() {
        return this.authPSModelEngineScript;
    }

    protected void setAuthPSModelEngineScript(IPSModelEngineScript<?> authPSModelEngineScript) {
        this.authPSModelEngineScript = authPSModelEngineScript;
    }

    protected void prepareAuthPSModelEngineScript() throws Exception {
        if (!StringUtils.hasLength((String)this.getAuthScriptCode())) {
            return;
        }
        this.setAuthPSModelEngineScript(this.getPSModelEngineHolder().getPSModelEngineAddin(this, this.getAuthScriptCode(), IPSModelEngineScript.class));
    }

    @Override
    public void requestTokenIf(boolean bImmediately) {
        if (this.getTokenTimeout() - System.currentTimeMillis() >= 60000L) {
            return;
        }
        this.requestToken(bImmediately);
    }

    @Override
    public void requestToken() {
        this.requestToken(false);
    }

    @Override
    public void requestToken(boolean bImmediately) {
        if (bImmediately) {
            try {
                this.onRequestToken();
            }
            catch (Throwable ex) {
                log.error((Object)String.format("\u5916\u90e8\u670d\u52a1\u63a5\u53e3[%1$s]\u8ba4\u8bc1\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
                this.setTokenTimeout(0L);
                throw new PSModelEngineException((IPSModelEngine)this, String.format("\u8ba4\u8bc1\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
        } else {
            this.setTokenTimeout(0L);
        }
    }

    protected void onRequestToken() throws Throwable {
        long nLastTokenTimeout = this.getTokenTimeout();
        this.doRequestTokenReal();
        if (this.getTokenTimeout() == nLastTokenTimeout) {
            this.setTokenTimeout(System.currentTimeMillis() + (long)this.getDefaultTokenTimeout());
        }
    }

    protected void doRequestTokenReal() throws Throwable {
        if (this.getAuthPSModelEngineScript() == null) {
            if (PSModelEnums.APIAuthMode.CLIENT_CREDENTIALS.value.equalsIgnoreCase(this.getAuthMode())) {
                this.doRequestToken_ClientCredentials();
                return;
            }
            throw new Exception(String.format("\u672a\u5b9a\u4e49\u8ba4\u8bc1\u5904\u7406\u903b\u8f91", new Object[0]));
        }
        this.getAuthPSModelEngineScript().call(new Object[0]);
    }

    protected void doRequestToken_ClientCredentials() throws Throwable {
        String credentials = String.format("%1$s:%2$s", this.getClientId(), this.getClientSecret());
        byte[] credentialsBytes = credentials.getBytes(StandardCharsets.UTF_8);
        String encodedCredentials = Base64.getEncoder().encodeToString(credentialsBytes);
        String authorization = "Basic " + encodedCredentials;
        LinkedHashMap<String, String> body = new LinkedHashMap<String, String>();
        body.put("grant_type", "client_credentials");
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put("Authorization", authorization);
        IWebClientRep<String> rep = this.getPSModelEngineHolder().getPSSystemEngine().getDefaultWebClient().post(this.getAccessTokenUrl(), null, headers, null, body, ContentType.APPLICATION_FORM_URLENCODED.getMimeType(), String.class, null);
        Map map = JsonUtils.asMap(rep.getBody());
        Object access_token = map.get("access_token");
        Object token_type = map.get("token_type");
        Object expires_in = map.get("expires_in");
        if (ObjectUtils.isEmpty(access_token)) {
            throw new Exception("\u8ba4\u77e5\u7ed3\u679c\u672a\u5305\u542b\u51ed\u8bc1\u4fe1\u606f");
        }
        if (ObjectUtils.isEmpty(token_type)) {
            token_type = "bearer";
        }
        headers.clear();
        headers.put("Authorization", String.format("%1$s %2$s", StringUtils.capitalize((String)token_type.toString()), access_token));
        this.setHeaders(headers);
        if (expires_in instanceof Integer) {
            this.tokenExpireIn((Integer)expires_in);
        }
    }

    protected void runAuthTimer() {
        this.runAuthTimer(false);
    }

    protected void runAuthTimer(boolean bTimerOnly) {
        if (!bTimerOnly) {
            try {
                this.onAuthTimer();
            }
            catch (Throwable ex) {
                log.error((Object)String.format("\u5916\u90e8\u670d\u52a1\u63a5\u53e3[%1$s]\u8ba4\u8bc1\u5b9a\u65f6\u5668\u5904\u7406\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
                this.getPSModelEngineHolder().getPSSystemLogger().error(this.getLogCat(), String.format("\u5916\u90e8\u670d\u52a1\u63a5\u53e3[%1$s]\u8ba4\u8bc1\u5b9a\u65f6\u5668\u5904\u7406\u53d1\u751f\u5f02\u5e38\uff0c%2$s", this.getName(), ex.getMessage()), ex);
            }
        }
        this.getPSModelEngineHolder().getPSSystemEngine().threadRun(new Runnable(){

            @Override
            public void run() {
                PSSubSysServiceAPIEngineBase.this.runAuthTimer();
            }
        }, System.currentTimeMillis() + 10000L, "AuthTimer_" + ((IPSSubSysServiceAPI)this.getPSModelObject()).getId());
    }

    protected void onAuthTimer() throws Throwable {
        if (this.getTokenTimeout() - System.currentTimeMillis() >= this.getRenewTokenInterval()) {
            return;
        }
        this.requestToken(true);
    }

    protected long getRenewTokenInterval() {
        return 60000L;
    }
}

