/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.engine.dataentity.logic;

import java.sql.Timestamp;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.logic.IPSDEEndLogic;
import net.ibizsys.model.dataentity.logic.IPSDELogic;
import net.ibizsys.model.dataentity.logic.IPSDELogicLink;
import net.ibizsys.model.dataentity.logic.IPSDELogicLinkCond;
import net.ibizsys.model.dataentity.logic.IPSDELogicLinkGroupCond;
import net.ibizsys.model.dataentity.logic.IPSDELogicLinkSingleCond;
import net.ibizsys.model.dataentity.logic.IPSDELogicNode;
import net.ibizsys.model.dataentity.logic.IPSDELogicParam;
import net.ibizsys.model.dataentity.logic.IPSDEThrowExceptionLogic;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.PSModelEngineBase;
import net.ibizsys.model.engine.PSModelEngineException;
import net.ibizsys.model.engine.dataentity.logic.IPSDELogicEngine;
import net.ibizsys.model.engine.dataentity.logic.IPSDELogicNodeAddin;
import net.ibizsys.model.engine.dataentity.logic.IPSDELogicParamAddin;
import net.ibizsys.model.engine.dataentity.logic.IPSDELogicSession;
import net.ibizsys.model.engine.dataentity.logic.PSDELogicSession;
import net.ibizsys.model.engine.dataentity.logic.PSDELogicSessionHolder;
import net.ibizsys.model.engine.util.ExceptionEntity;
import net.ibizsys.model.engine.util.IAction;
import net.ibizsys.model.engine.util.IEntityBase;
import net.ibizsys.model.engine.util.IExceptionEntity;
import net.ibizsys.model.util.DataTypeUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class PSDELogicEngineBase
extends PSModelEngineBase
implements IPSDELogicEngine {
    private static final Log log = LogFactory.getLog(PSDELogicEngineBase.class);
    private Map<String, IPSDELogicNodeAddin> psDELogicNodeAddinMap = new LinkedHashMap<String, IPSDELogicNodeAddin>();
    private Map<String, IPSDELogicParamAddin> psPSDELogicParamAddinMap = new LinkedHashMap<String, IPSDELogicParamAddin>();
    private IPSDELogicParamAddin defaultPSDELogicParamAddin = null;

    @Override
    public void init(IPSModelEngineHolder iPSModelEngineHolder, String id, IPSModelObject iPSModelObject) throws Exception {
        if (!(iPSModelObject instanceof IPSDELogic)) {
            throw new Exception(String.format("\u6a21\u578b\u7c7b\u578b\u4e0d\u6b63\u786e", new Object[0]));
        }
        super.init(iPSModelEngineHolder, id, iPSModelObject);
    }

    @Override
    public IPSDELogic getPSModelObject() {
        return (IPSDELogic)super.getPSModelObject();
    }

    @Override
    protected void onInit() throws Exception {
        List psDELogicParamList = this.getPSDELogic().getPSDELogicParams();
        if (psDELogicParamList != null) {
            for (IPSDELogicParam iPSDELogicParam : psDELogicParamList) {
                if (!StringUtils.hasLength((String)iPSDELogicParam.getCodeName())) {
                    throw new Exception(String.format("\u903b\u8f91\u53c2\u6570[%1$s]\u672a\u6307\u5b9a\u4ee3\u7801\u6807\u8bc6", iPSDELogicParam.getName()));
                }
                IPSDELogicParamAddin iPSDELogicParamAddin = this.getPSModelEngineHolder().getPSModelEngineAddin(this, iPSDELogicParam, IPSDELogicParamAddin.class);
                this.psPSDELogicParamAddinMap.put(iPSDELogicParam.getCodeName().toUpperCase(), iPSDELogicParamAddin);
                if (!iPSDELogicParam.isDefault()) continue;
                if (this.getDefaultPSDELogicParamAddin() != null) {
                    throw new Exception(String.format("\u5b58\u5728\u591a\u4e2a\u9ed8\u8ba4\u903b\u8f91\u53c2\u6570", new Object[0]));
                }
                this.setDefaultPSDELogicParamAddin(iPSDELogicParamAddin);
            }
        }
        if (this.getPSDELogic().isCustomCode()) {
            throw new Exception("\u672a\u652f\u6301");
        }
        List psDELogicNodeList = this.getPSDELogic().getPSDELogicNodes();
        if (psDELogicNodeList != null) {
            for (IPSDELogicNode iPSDELogicNode : psDELogicNodeList) {
                IPSDELogicNodeAddin iPSDELogicNodeAddin = this.getPSModelEngineHolder().getPSModelEngineAddin(this, iPSDELogicNode, IPSDELogicNodeAddin.class);
                this.psDELogicNodeAddinMap.put(iPSDELogicNode.getCodeName().toUpperCase(), iPSDELogicNodeAddin);
            }
        }
        this.getPSDELogic().getStartPSDELogicNodeMust();
        super.onInit();
    }

    protected IPSDELogicNodeAddin getPSDELogicNodeAddin(IPSDELogicNode iPSDELogicNode) {
        IPSDELogicNodeAddin iPSDELogicNodeAddin = null;
        try {
            iPSDELogicNodeAddin = this.getPSDELogicNodeAddin(iPSDELogicNode.getCodeName(), true);
        }
        catch (Throwable ex) {
            log.debug((Object)ex);
        }
        if (iPSDELogicNodeAddin == null) {
            throw new PSModelEngineException(this, String.format("\u65e0\u6cd5\u83b7\u53d6\u903b\u8f91\u8282\u70b9[%1$s][%2$s]\u8fd0\u884c\u65f6\u5bf9\u8c61", iPSDELogicNode.getName(), iPSDELogicNode.getLogicNodeType()));
        }
        return iPSDELogicNodeAddin;
    }

    @Override
    public IPSDELogicParamAddin getPSDELogicParamAddin(String strName, boolean bTryMode) {
        IPSDELogicParamAddin iPSDELogicParamAddin = this.psPSDELogicParamAddinMap.get(strName.toUpperCase());
        if (iPSDELogicParamAddin != null || bTryMode) {
            return iPSDELogicParamAddin;
        }
        throw new PSModelEngineException(this, String.format("\u672a\u5b58\u5728\u6307\u5b9a\u53c2\u6570[%1$s]", strName));
    }

    @Override
    public IPSDELogicNodeAddin getPSDELogicNodeAddin(String strName, boolean bTryMode) {
        IPSDELogicNodeAddin iPSDELogicNodeAddin = this.psDELogicNodeAddinMap.get(strName.toUpperCase());
        if (iPSDELogicNodeAddin != null || bTryMode) {
            return iPSDELogicNodeAddin;
        }
        throw new PSModelEngineException(this, String.format("\u672a\u5b58\u5728\u6307\u5b9a\u8282\u70b9[%1$s]", strName));
    }

    @Override
    public Object execute(Object[] args) {
        return this.executeAction("\u6267\u884c\u903b\u8f91", new IAction<Object>(){

            @Override
            public Object execute(Object[] args) throws Throwable {
                return PSDELogicEngineBase.this.onExecute(args);
            }
        }, args);
    }

    protected Object onExecute(Object[] args) throws Throwable {
        if (args == null || args.length == 0) {
            throw new Exception(String.format("\u4f20\u5165\u53c2\u6570\u65e0\u6548", new Object[0]));
        }
        IEntityBase iEntity = null;
        if (args[0] instanceof IEntityBase) {
            iEntity = (IEntityBase)args[0];
        }
        if (iEntity == null) {
            throw new PSModelEngineException(this, String.format("\u4f20\u5165\u53c2\u6570\u65e0\u6548", new Object[0]));
        }
        IPSDELogicSession iPSDELogicSession = this.createPSDELogicSession();
        List psDELogicParamList = this.getPSDELogic().getPSDELogicParams();
        if (psDELogicParamList != null && psDELogicParamList.size() > 0) {
            for (IPSDELogicParam iPSDELogicParam : psDELogicParamList) {
                if (iPSDELogicParam.isDefault()) {
                    iPSDELogicSession.setParam(iPSDELogicParam, (Object)iEntity);
                    continue;
                }
                if (iPSDELogicParam.isLastReturnParam() || iPSDELogicParam.isFilterParam() || iPSDELogicParam.isEntityListParam() || iPSDELogicParam.isEntityPageParam() || iPSDELogicParam.isFileParam() || iPSDELogicParam.isFileListParam() || iPSDELogicParam.isSimpleParam() || iPSDELogicParam.isSimpleListParam()) continue;
                if (iPSDELogicParam.isLastParam()) {
                    throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
                }
                if (!iPSDELogicParam.isSessionParam() && !iPSDELogicParam.isEnvParam()) continue;
            }
        }
        IPSDELogicSession lastDELogicSession = PSDELogicSessionHolder.getCurrent();
        try {
            PSDELogicSessionHolder.setCurrent(iPSDELogicSession);
            this.beginSession(iPSDELogicSession);
            this.executePSDELogicNode(iPSDELogicSession, this.getPSDELogic().getStartPSDELogicNodeMust());
            this.endSession(iPSDELogicSession);
            this.outputDebugInfo(iPSDELogicSession, null);
            PSDELogicSessionHolder.setCurrent(lastDELogicSession);
        }
        catch (Throwable ex) {
            this.endSession(iPSDELogicSession);
            this.outputDebugInfo(iPSDELogicSession, ex);
            PSDELogicSessionHolder.setCurrent(lastDELogicSession);
            throw ex;
        }
        return iPSDELogicSession.getResult();
    }

    protected void beginSession(IPSDELogicSession iPSDELogicSession) throws Throwable {
        if (this.psPSDELogicParamAddinMap != null) {
            for (IPSDELogicParamAddin iPSDELogicParamAddin : this.psPSDELogicParamAddinMap.values()) {
                iPSDELogicParamAddin.beginSession(iPSDELogicSession);
            }
        }
    }

    protected void endSession(IPSDELogicSession iPSDELogicSession) {
        if (this.psPSDELogicParamAddinMap != null) {
            for (IPSDELogicParamAddin iPSDELogicParamAddin : this.psPSDELogicParamAddinMap.values()) {
                iPSDELogicParamAddin.endSession(iPSDELogicSession);
            }
        }
    }

    protected void executePSDELogicNode(IPSDELogicSession iPSDELogicSession, IPSDELogicNode iPSDELogicNode) throws Throwable {
        this.onExecutePSDELogicNode(iPSDELogicSession, iPSDELogicNode);
    }

    protected void onExecutePSDELogicNode(IPSDELogicSession iPSDELogicSession, IPSDELogicNode iPSDELogicNode) throws Throwable {
        this.onExecutePSDELogicNode(iPSDELogicSession, iPSDELogicNode, true);
    }

    protected void onExecutePSDELogicNode(IPSDELogicSession iPSDELogicSession, IPSDELogicNode iPSDELogicNode, boolean bExecuteLink) throws Throwable {
        IPSDELogicNodeAddin iPSDELogicNodeAddin = this.getPSDELogicNodeAddin(iPSDELogicNode);
        iPSDELogicSession.debugEnterNode(iPSDELogicNode);
        Throwable exception = null;
        try {
            iPSDELogicNodeAddin.execute(iPSDELogicSession);
            if (iPSDELogicNode instanceof IPSDEEndLogic) {
                iPSDELogicSession.debugExitNode(iPSDELogicNode);
                return;
            }
        }
        catch (Throwable ex) {
            if (iPSDELogicNode instanceof IPSDEThrowExceptionLogic) {
                throw ex;
            }
            exception = ex;
        }
        if (!bExecuteLink) {
            if (exception != null) {
                throw exception;
            }
            return;
        }
        List psDELogicLinkList = iPSDELogicNode.getPSDELogicLinks();
        if (exception == null) {
            if (psDELogicLinkList != null && psDELogicLinkList.size() > 0) {
                Object lastReturn = iPSDELogicSession.getLastReturn();
                boolean bParallelOutput = iPSDELogicNode.isParallelOutput();
                if (bParallelOutput) {
                    int nCount = 0;
                    for (IPSDELogicLink iPSDELogicLink : psDELogicLinkList) {
                        if (iPSDELogicLink.isCatchLink() || iPSDELogicLink.isSubCallLink()) continue;
                        ++nCount;
                    }
                    if (nCount <= 1) {
                        bParallelOutput = false;
                    }
                }
                for (IPSDELogicLink iPSDELogicLink : psDELogicLinkList) {
                    if (iPSDELogicLink.isCatchLink() || iPSDELogicLink.isSubCallLink()) continue;
                    if (iPSDELogicLink.getPSDELogicLinkGroupCond() == null || iPSDELogicLink.getPSDELogicLinkGroupCond().getPSDELogicLinkConds() == null) {
                        iPSDELogicSession.debugEnterLink(iPSDELogicNode, iPSDELogicLink);
                        if (!bParallelOutput) {
                            iPSDELogicSession.debugExitNode(iPSDELogicNode);
                        }
                        iPSDELogicSession.setLastReturn(lastReturn);
                        this.executePSDELogicNode(iPSDELogicSession, iPSDELogicLink.getDstPSDELogicNodeMust());
                        if (bParallelOutput) continue;
                        return;
                    }
                    if (!this.testPSDELogicLinkCond(iPSDELogicSession, (IPSDELogicLinkCond)iPSDELogicLink.getPSDELogicLinkGroupCond())) continue;
                    iPSDELogicSession.debugEnterLink(iPSDELogicNode, iPSDELogicLink);
                    if (!bParallelOutput) {
                        iPSDELogicSession.debugExitNode(iPSDELogicNode);
                    }
                    iPSDELogicSession.setLastReturn(lastReturn);
                    this.executePSDELogicNode(iPSDELogicSession, iPSDELogicLink.getDstPSDELogicNodeMust());
                    if (bParallelOutput) continue;
                    return;
                }
            }
        } else {
            if (psDELogicLinkList != null && psDELogicLinkList.size() > 0) {
                IExceptionEntity iExceptionEntity = null;
                for (IPSDELogicLink iPSDELogicLink : psDELogicLinkList) {
                    if (!iPSDELogicLink.isCatchLink()) continue;
                    if (iExceptionEntity == null) {
                        iExceptionEntity = ExceptionEntity.from(exception);
                        iPSDELogicSession.setLastReturn(iExceptionEntity);
                    }
                    if (iPSDELogicLink.getPSDELogicLinkGroupCond() == null || iPSDELogicLink.getPSDELogicLinkGroupCond().getPSDELogicLinkConds() == null) {
                        iPSDELogicSession.debugInfo(exception.getMessage());
                        exception = null;
                        iPSDELogicSession.debugEnterLink(iPSDELogicNode, iPSDELogicLink);
                        iPSDELogicSession.debugExitNode(iPSDELogicNode);
                        this.executePSDELogicNode(iPSDELogicSession, iPSDELogicLink.getDstPSDELogicNodeMust());
                        return;
                    }
                    if (!this.testPSDELogicLinkCond(iPSDELogicSession, (IPSDELogicLinkCond)iPSDELogicLink.getPSDELogicLinkGroupCond())) continue;
                    iPSDELogicSession.debugInfo(exception.getMessage());
                    exception = null;
                    iPSDELogicSession.debugEnterLink(iPSDELogicNode, iPSDELogicLink);
                    iPSDELogicSession.debugExitNode(iPSDELogicNode);
                    this.executePSDELogicNode(iPSDELogicSession, iPSDELogicLink.getDstPSDELogicNodeMust());
                    return;
                }
            }
            if (exception != null) {
                throw exception;
            }
        }
        iPSDELogicSession.debugExitNode(iPSDELogicNode);
    }

    protected boolean testPSDELogicLinkCond(IPSDELogicSession iPSDELogicSession, IPSDELogicLinkCond iPSDELogicLinkCond) throws Throwable {
        if (iPSDELogicLinkCond instanceof IPSDELogicLinkGroupCond) {
            IPSDELogicLinkGroupCond iPSDELogicLinkGroupCond = (IPSDELogicLinkGroupCond)iPSDELogicLinkCond;
            boolean bRet = true;
            if (iPSDELogicLinkGroupCond.getGroupOP().equals("AND")) {
                if (iPSDELogicLinkGroupCond.getPSDELogicLinkConds() != null && iPSDELogicLinkGroupCond.getPSDELogicLinkConds().size() > 0) {
                    bRet = true;
                    for (IPSDELogicLinkCond childPSDELogicLinkCond : iPSDELogicLinkGroupCond.getPSDELogicLinkConds()) {
                        if (this.testPSDELogicLinkCond(iPSDELogicSession, childPSDELogicLinkCond)) continue;
                        bRet = false;
                        break;
                    }
                }
            } else if (iPSDELogicLinkGroupCond.getGroupOP().equals("OR")) {
                if (iPSDELogicLinkGroupCond.getPSDELogicLinkConds() != null && iPSDELogicLinkGroupCond.getPSDELogicLinkConds().size() > 0) {
                    bRet = false;
                    for (IPSDELogicLinkCond childPSDELogicLinkCond : iPSDELogicLinkGroupCond.getPSDELogicLinkConds()) {
                        if (!this.testPSDELogicLinkCond(iPSDELogicSession, childPSDELogicLinkCond)) continue;
                        bRet = true;
                        break;
                    }
                }
            } else {
                throw new PSModelEngineException(this, String.format("\u8fde\u63a5\u6761\u4ef6[%1$s]\u7ec4\u903b\u8f91\u64cd\u4f5c[%2$s]\u65e0\u6548", iPSDELogicLinkCond.getName(), iPSDELogicLinkGroupCond.getGroupOP()));
            }
            if (iPSDELogicLinkGroupCond.isNotMode()) {
                bRet = !bRet;
            }
            return bRet;
        }
        if (iPSDELogicLinkCond instanceof IPSDELogicLinkSingleCond) {
            IPSDELogicLinkSingleCond iPSDELogicLinkSingleCond = (IPSDELogicLinkSingleCond)iPSDELogicLinkCond;
            IPSDELogicParamAddin dstPSDELogicParamAddin = this.getPSDELogicParamAddin(iPSDELogicLinkSingleCond.getDstLogicParamMust().getCodeName(), false);
            Object objValue = null;
            String strDstFieldName = iPSDELogicLinkSingleCond.getDstFieldName();
            objValue = StringUtils.isEmpty((Object)strDstFieldName) ? dstPSDELogicParamAddin.getValue(iPSDELogicSession) : dstPSDELogicParamAddin.get(iPSDELogicSession, strDstFieldName.toLowerCase());
            Object dstValue = iPSDELogicLinkSingleCond.getParamValue();
            String strParamType = iPSDELogicLinkSingleCond.getParamType();
            if (StringUtils.hasLength((String)strParamType)) {
                if (StringUtils.isEmpty((Object)dstValue)) {
                    throw new Exception(String.format("\u8fde\u63a5\u6761\u4ef6[%1$s]\u672a\u6307\u5b9a\u53c2\u6570\u9879\u540d\u79f0", iPSDELogicLinkCond.getName()));
                }
                if (strParamType.equals(PSModelEnums.DELLCondParamType.ENTITYFIELD.value)) {
                    dstValue = dstPSDELogicParamAddin.get(iPSDELogicSession, ((String)dstValue).toLowerCase());
                } else if (strParamType.equals(PSModelEnums.DELLCondParamType.CURTIME.value)) {
                    dstValue = new Timestamp(System.currentTimeMillis());
                } else if (strParamType.equals(PSModelEnums.DELLCondParamType.SRCENTITYFIELD.value)) {
                    IPSDELogicParamAddin srcPSDELogicParamAddin = this.getPSDELogicParamAddin(iPSDELogicLinkSingleCond.getSrcLogicParamMust().getCodeName(), false);
                    dstValue = srcPSDELogicParamAddin.get(iPSDELogicSession, ((String)dstValue).toLowerCase());
                } else if (strParamType.equals(PSModelEnums.DELLCondParamType.SRCDLPARAM.value)) {
                    IPSDELogicParamAddin srcPSDELogicParamAddin = this.getPSDELogicParamAddin(iPSDELogicLinkSingleCond.getSrcLogicParamMust().getCodeName(), false);
                    dstValue = srcPSDELogicParamAddin.getValue(iPSDELogicSession);
                }
            }
            return this.testValueCond(objValue, iPSDELogicLinkSingleCond.getCondOP(), dstValue);
        }
        throw new Exception(String.format("\u65e0\u6cd5\u8bc6\u522b\u8fde\u63a5\u6761\u4ef6[%1$s][%2$s]", iPSDELogicLinkCond.getName(), iPSDELogicLinkCond.getLogicType()));
    }

    protected boolean testValueCond(Object objSrcValue, String strOP, Object objDstValue) throws Exception {
        return DataTypeUtils.testCond((Object)objSrcValue, (String)strOP, (Object)objDstValue);
    }

    protected boolean test(Object objSrcValue, String strOP, Object objDstValue) throws Exception {
        return this.testValueCond(objSrcValue, strOP, objDstValue);
    }

    protected IPSDELogicSession createPSDELogicSession() {
        return new PSDELogicSession(this);
    }

    @Override
    public IPSDELogicParamAddin getDefaultPSDELogicParamAddin() {
        return this.defaultPSDELogicParamAddin;
    }

    protected void setDefaultPSDELogicParamAddin(IPSDELogicParamAddin defaultPSDELogicParamAddin) {
        this.defaultPSDELogicParamAddin = defaultPSDELogicParamAddin;
    }

    protected void outputDebugInfo(IPSDELogicSession iPSDELogicSession, Throwable ex) {
    }
}

