/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.engine.dataentity.dataflow;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.dataentity.IPSDataEntity;
import net.ibizsys.model.dataentity.dataflow.IPSDEDataFlow;
import net.ibizsys.model.dataentity.dataflow.IPSDEDataFlowNode;
import net.ibizsys.model.engine.PSModelEngineBase;
import net.ibizsys.model.engine.PSModelEngineException;
import net.ibizsys.model.engine.dataentity.dataflow.IPSDEDataFlowEngine;
import net.ibizsys.model.engine.dataentity.dataflow.IPSDEDataFlowNodeAddin;
import net.ibizsys.model.engine.util.IAction;
import net.ibizsys.model.util.JsonUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public abstract class PSDEDataFlowEngineBase<M extends IPSDEDataFlow>
extends PSModelEngineBase<M>
implements IPSDEDataFlowEngine<M> {
    private Map<String, IPSDEDataFlowNodeAddin<?, ?>> psDEDataFlowNodeAddinMap = new LinkedHashMap();

    @Override
    protected void onInit() throws Exception {
        this.onPreparePSDEDataFlowNodeAddins();
        super.onInit();
    }

    protected void onPreparePSDEDataFlowNodeAddins() throws Exception {
        List psDEDataFlowNodeList = ((IPSDEDataFlow)this.getPSModelObject()).getPSDEDataFlowNodes();
        if (psDEDataFlowNodeList != null) {
            for (IPSDEDataFlowNode iPSDEDataFlowNode : psDEDataFlowNodeList) {
                IPSDEDataFlowNodeAddin iPSDEDataFlowNodeAddin = this.getPSModelEngineHolder().getPSModelEngineAddin(this, iPSDEDataFlowNode, IPSDEDataFlowNodeAddin.class);
                this.psDEDataFlowNodeAddinMap.put(iPSDEDataFlowNode.getCodeName().toUpperCase(), iPSDEDataFlowNodeAddin);
            }
        }
    }

    @Override
    public Collection<? extends IPSDEDataFlowNodeAddin<?, ?>> getPSDEDataFlowNodeAddins() {
        if (ObjectUtils.isEmpty(this.psDEDataFlowNodeAddinMap)) {
            return null;
        }
        return this.psDEDataFlowNodeAddinMap.values();
    }

    @Override
    public IPSDEDataFlowNodeAddin<?, ?> getPSDEDataFlowNodeAddin(String name, boolean tryMode) {
        IPSDEDataFlowNodeAddin<?, ?> iPSDEDataFlowNodeAddin = this.psDEDataFlowNodeAddinMap.get(name.toUpperCase());
        if (iPSDEDataFlowNodeAddin != null || tryMode) {
            return iPSDEDataFlowNodeAddin;
        }
        throw new PSModelEngineException(this, String.format("\u672a\u5b58\u5728\u6307\u5b9a\u8282\u70b9[%1$s]", name));
    }

    @Override
    public void execute(Object[] args) {
        this.executeAction("\u6267\u884c\u6d41\u5904\u7406", new IAction<Object>(){

            @Override
            public Object execute(Object[] args) throws Throwable {
                if (PSModelEnums.DataFlowSubType.PACKAGE.value.equals(((IPSDEDataFlow)PSDEDataFlowEngineBase.this.getPSModelObject()).getLogicSubType())) {
                    PSDEDataFlowEngineBase.this.onExecutePackage(args);
                    return null;
                }
                PSDEDataFlowEngineBase.this.onExecute(args);
                return null;
            }
        }, args);
    }

    protected void onExecute(Object[] args) throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }

    protected void onExecutePackage(Object[] args) throws Throwable {
        String packageModel = ((IPSDEDataFlow)this.getPSModelObject()).getPackageModel();
        if (!StringUtils.hasLength((String)packageModel)) {
            throw new Exception("\u672a\u6307\u5b9a\u5305\u6a21\u578b");
        }
        LinkedHashMap<String, IPSDEDataFlow> psDEDataFlowMap = new LinkedHashMap<String, IPSDEDataFlow>();
        ArrayNode arrayNode = JsonUtils.toArrayNode((Object)packageModel);
        for (int i = 0; i < arrayNode.size(); ++i) {
            String string;
            JsonNode jsonNode = arrayNode.get(i);
            if (!jsonNode.isTextual() || !StringUtils.hasLength((String)(string = jsonNode.asText()))) continue;
            psDEDataFlowMap.put(string.toLowerCase(), null);
        }
        if (ObjectUtils.isEmpty(psDEDataFlowMap)) {
            throw new Exception("\u672a\u6307\u5b9a\u5305\u6a21\u578b");
        }
        List psDataEntityList = this.getPSModelEngineHolder().getPSSystemService().getPSSystem().getAllPSDataEntities();
        if (!ObjectUtils.isEmpty((Object)psDataEntityList)) {
            for (IPSDataEntity iPSDataEntity : psDataEntityList) {
                List psDEDataFlowList = iPSDataEntity.getAllPSDEDataFlows();
                if (ObjectUtils.isEmpty((Object)psDEDataFlowList)) continue;
                for (IPSDEDataFlow iPSDEDataFlow : psDEDataFlowList) {
                    String tag = PSModelUtils.calcFullUniqueTag((IPSModelObject)iPSDEDataFlow, (boolean)true);
                    if (!psDEDataFlowMap.containsKey(tag)) continue;
                    psDEDataFlowMap.put(tag, iPSDEDataFlow);
                }
            }
        }
        for (Map.Entry entry : psDEDataFlowMap.entrySet()) {
            if (entry.getValue() != null) continue;
            throw new Exception(String.format("\u65e0\u6cd5\u83b7\u53d6\u6307\u5b9a\u6570\u636e\u6d41[%1$s]", entry.getKey()));
        }
        this.onExecutePSDEDataFlows(psDEDataFlowMap.values().toArray(new IPSDEDataFlow[psDEDataFlowMap.size()]), args);
    }

    protected void onExecutePSDEDataFlows(IPSDEDataFlow[] psDEDataFlows, Object[] args) throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }
}

