/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.engine.database.sql;

import java.util.ArrayList;
import java.util.Map;
import net.ibizsys.model.dataentity.ds.IPSDEDataQuery;
import net.ibizsys.model.dataentity.ds.IPSDEDataSet;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.database.sql.ISQLGenEngine;
import net.ibizsys.model.engine.plugin.IPSModelEngineAddin;
import net.ibizsys.model.engine.plugin.PSModelEngineAddinBase;
import net.ibizsys.model.engine.plugin.PSModelEngineAddinException;
import org.springframework.util.ObjectUtils;

public abstract class SQLGenEngineBase<E extends IPSModelEngine<?>>
extends PSModelEngineAddinBase<E, String>
implements ISQLGenEngine<E> {
    public String getDBType() {
        return this.getAddinData();
    }

    @Override
    protected String getAddinData() {
        return (String)super.getAddinData();
    }

    @Override
    public String generate(IPSDEDataSet iPSDEDataSet, Map<String, Object> params) {
        try {
            return this.onGenerate(iPSDEDataSet, params);
        }
        catch (Throwable ex) {
            throw new PSModelEngineAddinException((IPSModelEngineAddin)this, String.format("\u751f\u6210\u6570\u636e\u96c6SQL\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected String onGenerate(IPSDEDataSet iPSDEDataSet, Map<String, Object> params) throws Throwable {
        ArrayList<String> sqlList = new ArrayList<String>();
        if (ObjectUtils.isEmpty((Object)iPSDEDataSet.getPSDEDataQueries())) {
            throw new Exception("\u672a\u5305\u542b\u6570\u636e\u67e5\u8be2");
        }
        for (IPSDEDataQuery iPSDEDataQuery : iPSDEDataSet.getPSDEDataQueries()) {
            String sql = this.generate(iPSDEDataQuery, params);
            sqlList.add(sql);
        }
        if (sqlList.size() == 1) {
            return (String)sqlList.get(0);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < sqlList.size(); ++i) {
            if (i != 0) {
                sb.append("UNION");
            }
            sb.append("\n");
            sb.append((String)sqlList.get(i));
        }
        return sb.toString();
    }

    @Override
    public String generate(IPSDEDataQuery iPSDEDataQuery, Map<String, Object> params) {
        try {
            return this.onGenerate(iPSDEDataQuery, params);
        }
        catch (Throwable ex) {
            throw new PSModelEngineAddinException((IPSModelEngineAddin)this, String.format("\u751f\u6210\u6570\u636e\u67e5\u8be2\u96c6SQL\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
        }
    }

    protected String onGenerate(IPSDEDataQuery iPSDEDataQuery, Map<String, Object> params) throws Throwable {
        throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
    }
}

