/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.engine;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.IPSSystem;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSSystemEngine;
import net.ibizsys.model.engine.PSModelEngineBase;
import net.ibizsys.model.engine.PSModelEngineException;
import net.ibizsys.model.engine.security.ISecurityContext;
import net.ibizsys.model.engine.security.SecurityContextHolder;
import net.ibizsys.model.engine.service.client.IWebClient;
import net.ibizsys.model.engine.sysutil.IPSSysUtilEngine;
import net.ibizsys.model.engine.util.IAction;
import net.ibizsys.model.res.IPSSysUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class PSSystemEngineBase<M extends IPSSystem>
extends PSModelEngineBase<M>
implements IPSSystemEngine<M> {
    private static final Log log = LogFactory.getLog(PSSystemEngineBase.class);
    private boolean loaded = false;
    private Date loadedDate = null;
    private ThreadPoolExecutor workThreadPoolExecutor = null;
    private ScheduledExecutorService timerThreadPoolExecutor = null;
    private List<TimerTask> timerTaskList = new ArrayList<TimerTask>();
    private List<TimerTask> timerTaskList2 = new ArrayList<TimerTask>();
    private boolean threadRunFlag = false;
    private IWebClient<?, ?> defaultWebClient = null;

    @Override
    protected void onInit() throws Exception {
    }

    @Override
    public void start() throws Exception {
        this.onBeforeStart();
        this.onStart();
        this.onAfterStart();
        this.markLoaded();
    }

    @Override
    public void shutdown() {
        this.onShutdown();
    }

    protected void onShutdown() {
        this.shutdownThreadPoolExecutors();
    }

    public IPSSystem getPSSystem() {
        return (IPSSystem)super.getPSModelObject();
    }

    @Override
    protected void prepareSetting() throws Exception {
        super.prepareSetting();
        this.prepareThreadPoolExecutors();
    }

    @Override
    public Object getGlobalParam(String name) {
        return null;
    }

    protected void prepareThreadPoolExecutors() throws Exception {
        this.threadRunFlag = true;
        this.workThreadPoolExecutor = this.createWorkThreadPoolExecutor();
        this.timerThreadPoolExecutor = this.createScheduleThreadPoolExecutor();
        this.timerThreadPoolExecutor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                PSSystemEngineBase.this.timerThreadRun();
            }
        }, this.getTimerThreadTimer(), this.getTimerThreadTimer(), TimeUnit.MILLISECONDS);
    }

    protected void shutdownThreadPoolExecutors() {
        if (!this.threadRunFlag) {
            return;
        }
        this.threadRunFlag = false;
        this.shutdownWorkThreadPoolExecutor();
        this.shutdownScheduleThreadPoolExecutor();
    }

    protected ThreadPoolExecutor createWorkThreadPoolExecutor() {
        ThreadPoolExecutor threadPoolExecutor = new ThreadPoolExecutor(5, this.getWorkThreadMaximumPoolSize(), 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.getWorkThreadBlockingQueueSize()), new ThreadPoolExecutor.AbortPolicy());
        return threadPoolExecutor;
    }

    protected ScheduledExecutorService createScheduleThreadPoolExecutor() {
        return Executors.newScheduledThreadPool(1);
    }

    protected void shutdownWorkThreadPoolExecutor() {
        if (this.workThreadPoolExecutor != null) {
            try {
                this.workThreadPoolExecutor.shutdownNow();
            }
            catch (Throwable ex) {
                log.error((Object)String.format("\u5173\u95ed\u5de5\u4f5c\u7ebf\u7a0b\u6c60\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
            this.workThreadPoolExecutor = null;
        }
    }

    protected void shutdownScheduleThreadPoolExecutor() {
        if (this.timerThreadPoolExecutor != null) {
            try {
                this.timerThreadPoolExecutor.shutdownNow();
            }
            catch (Throwable ex) {
                log.error((Object)String.format("\u5173\u95ed\u5b9a\u65f6\u7ebf\u7a0b\u6c60\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
            this.timerThreadPoolExecutor = null;
        }
    }

    protected int getWorkThreadMaximumPoolSize() {
        return 40;
    }

    protected int getWorkThreadBlockingQueueSize() {
        return 2000;
    }

    protected int getTimerThreadTimer() {
        return 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timerThreadRun() {
        if (!this.isThreadRun()) {
            return;
        }
        List<TimerTask> list = this.timerTaskList;
        synchronized (list) {
            if (this.timerTaskList.size() == 0) {
                return;
            }
            this.timerTaskList2.addAll(this.timerTaskList);
            this.timerTaskList.clear();
        }
        long nCurrentTime = System.currentTimeMillis();
        while (this.timerTaskList2.size() > 0) {
            TimerTask timerTask = this.timerTaskList2.remove(0);
            if (nCurrentTime >= timerTask.time) {
                ISecurityContext last = SecurityContextHolder.getCurrent();
                SecurityContextHolder.setCurrent(this.getThreadTaskSecurityContext(timerTask.securityContext));
                this.threadRun(timerTask.runnable, -1L);
                SecurityContextHolder.setCurrent(last);
                continue;
            }
            List<TimerTask> list2 = this.timerTaskList;
            synchronized (list2) {
                this.timerTaskList.add(timerTask);
            }
        }
    }

    @Override
    public void threadRun(Runnable runnable) {
        this.threadRun(runnable, -1L, null);
    }

    @Override
    public void threadRun(Runnable runnable, long nTime) {
        this.threadRun(runnable, nTime, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadRun(final Runnable runnable, long nTime, String strTaskName) {
        if (!this.isThreadRun()) {
            return;
        }
        final ISecurityContext iSecurityContext = SecurityContextHolder.getCurrent();
        if (nTime <= 0L) {
            Assert.notNull((Object)this.workThreadPoolExecutor, (String)"\u540e\u53f0\u4f5c\u4e1a\u7ebf\u7a0b\u6c60\u5bf9\u8c61\u65e0\u6548");
            this.workThreadPoolExecutor.execute(new Runnable(){

                @Override
                public void run() {
                    ISecurityContext last = SecurityContextHolder.getCurrent();
                    SecurityContextHolder.setCurrent(PSSystemEngineBase.this.getThreadTaskSecurityContext(iSecurityContext));
                    runnable.run();
                    SecurityContextHolder.setCurrent(last);
                }
            });
        } else {
            TimerTask timerTask = new TimerTask();
            timerTask.runnable = runnable;
            timerTask.time = nTime;
            timerTask.securityContext = iSecurityContext;
            timerTask.name = strTaskName;
            List<TimerTask> list = this.timerTaskList;
            synchronized (list) {
                if (StringUtils.hasLength((String)strTaskName)) {
                    for (int i = 0; i < this.timerTaskList.size(); ++i) {
                        TimerTask item = this.timerTaskList.get(i);
                        if (!StringUtils.hasLength((String)item.name) || !item.name.equals(strTaskName)) continue;
                        this.timerTaskList.remove(i);
                        break;
                    }
                }
                this.timerTaskList.add(timerTask);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadCancel(String strTaskName) {
        if (!this.isThreadRun()) {
            return;
        }
        Assert.hasLength((String)strTaskName, (String)"\u672a\u4f20\u5165\u53d6\u6d88\u4efb\u52a1\u7684\u540d\u79f0");
        List<TimerTask> list = this.timerTaskList;
        synchronized (list) {
            for (int i = 0; i < this.timerTaskList.size(); ++i) {
                TimerTask item = this.timerTaskList.get(i);
                if (!StringUtils.hasLength((String)item.name) || !item.name.equals(strTaskName)) continue;
                this.timerTaskList.remove(i);
                break;
            }
        }
    }

    @Override
    public Object asyncExecute(final IAction<?> iAction, final Object[] args, Object actionTag) {
        this.threadRun(new Runnable(){

            @Override
            public void run() {
                try {
                    iAction.execute(args);
                }
                catch (Throwable e) {
                    log.error((Object)e);
                }
            }
        });
        return null;
    }

    protected ISecurityContext getThreadTaskSecurityContext(ISecurityContext iSecurityContext) {
        return iSecurityContext;
    }

    protected boolean isThreadRun() {
        return this.threadRunFlag;
    }

    @Override
    public IWebClient<?, ?> getDefaultWebClient() {
        if (this.defaultWebClient == null) {
            try {
                this.defaultWebClient = this.getPSModelEngineHolder().getPSModelEngineAddin(this, null, IWebClient.class);
            }
            catch (Exception ex) {
                throw new PSModelEngineException((IPSModelEngine)this, String.format("\u5efa\u7acb\u7cfb\u7edf\u9ed8\u8ba4\u5ba2\u6237\u7aef\u5bf9\u8c61\u53d1\u751f\u5f02\u5e38\uff0c%1$s", ex.getMessage()), ex);
            }
        }
        return this.defaultWebClient;
    }

    protected void onBeforeStart() throws Exception {
        List psSysUtils = this.getPSSystem().getAllPSSysUtils();
        if (psSysUtils != null) {
            for (IPSSysUtil iPSSysUtil : psSysUtils) {
                if (iPSSysUtil.getOrderValue() < 0 || iPSSysUtil.getOrderValue() >= 100) continue;
                this.getPSModelEngineHolder().getPSModelEngine((IPSModelObject)iPSSysUtil, IPSSysUtilEngine.class);
            }
        }
        if ((psSysUtils = this.getPSSystem().getAllPSSysUtils()) != null) {
            for (IPSSysUtil iPSSysUtil : psSysUtils) {
                this.getPSModelEngineHolder().getPSModelEngine((IPSModelObject)iPSSysUtil, IPSSysUtilEngine.class);
            }
        }
    }

    protected void onStart() throws Exception {
        List psSysUtils = this.getPSSystem().getAllPSSysUtils();
        if (psSysUtils != null) {
            for (IPSSysUtil iPSSysUtil : psSysUtils) {
                IPSSysUtilEngine iPSSysUtilEngine = this.getPSModelEngineHolder().getPSModelEngine((IPSModelObject)iPSSysUtil, IPSSysUtilEngine.class);
                try {
                    iPSSysUtilEngine.install();
                }
                catch (Throwable ex) {
                    throw new Exception(String.format("\u5b89\u88c5\u7cfb\u7edf\u529f\u80fd\u7ec4\u4ef6[%1$s]\u53d1\u751f\u5f02\u5e38\uff0c%2$s", iPSSysUtilEngine.getName(), ex.getMessage()), ex);
                }
            }
        }
    }

    protected void onAfterStart() throws Exception {
    }

    protected void onLoad() throws Exception {
    }

    protected void markLoaded() throws Exception {
        if (this.loaded) {
            return;
        }
        this.loaded = true;
        this.loadedDate = new Date();
        this.onLoad();
    }

    protected class TimerTask {
        public long time;
        public Runnable runnable;
        public ISecurityContext securityContext;
        public Object tag;
        public String name;

        protected TimerTask() {
        }
    }
}

