/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.engine;

import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.engine.IPSModelEngine;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.IPSSystemLogger;
import net.ibizsys.model.engine.IPSSystemUtil;
import net.ibizsys.model.engine.PSModelEngineException;
import net.ibizsys.model.engine.util.IAction;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public abstract class PSModelEngineBase<T extends IPSModelObject>
implements IPSModelEngine<T> {
    private IPSModelEngineHolder iPSModelEngineHolder = null;
    private T iPSModelObject = null;
    private String configFolder = null;
    private String id = null;

    @Override
    public void init(IPSModelEngineHolder iPSModelEngineHolder, String id, T iPSModelObject) throws Exception {
        Assert.notNull((Object)iPSModelEngineHolder, (String)"\u6a21\u578b\u5f15\u64ce\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548");
        Assert.hasLength((String)id, (String)"\u6a21\u578b\u5f15\u64ce\u6807\u8bc6\u65e0\u6548");
        Assert.notNull(iPSModelObject, (String)"\u6a21\u578b\u5bf9\u8c61\u65e0\u6548");
        this.id = id;
        this.iPSModelEngineHolder = iPSModelEngineHolder;
        this.iPSModelObject = iPSModelObject;
        this.prepareSetting();
        this.onInit();
    }

    protected void onInit() throws Exception {
    }

    protected void prepareSetting() throws Exception {
        this.onPrepareSetting();
    }

    protected void onPrepareSetting() throws Exception {
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.getPSModelObject().getName();
    }

    @Override
    public String getFullName() {
        return this.getName();
    }

    protected Object executeAction(String name, IAction<Object> iAction) {
        return this.executeAction(name, iAction, null, Object.class);
    }

    protected Object executeAction(String name, IAction<Object> iAction, Object[] args) {
        return this.executeAction(name, iAction, args, Object.class);
    }

    protected <T> T executeAction(String name, IAction<T> iAction, Class<T> cls) {
        return this.executeAction(name, iAction, null, cls);
    }

    protected <T> T executeAction(String name, IAction<T> iAction, Object[] args, Class<T> cls) {
        try {
            return iAction.execute(args);
        }
        catch (Throwable ex) {
            PSModelEngineException.rethrow(this, ex);
            if (StringUtils.hasLength((String)name)) {
                String message = String.format("%1$s\u53d1\u751f\u9519\u8bef\uff0c%2$s", name, ex.getMessage());
                throw new PSModelEngineException((IPSModelEngine)this, message, ex);
            }
            throw new PSModelEngineException((IPSModelEngine)this, ex.getMessage(), ex);
        }
    }

    @Override
    public T getPSModelObject() {
        return this.iPSModelObject;
    }

    @Override
    public IPSModelEngineHolder getPSModelEngineHolder() {
        return this.iPSModelEngineHolder;
    }

    protected void setConfigFolder(String configFolder) {
        this.configFolder = configFolder;
    }

    protected String getConfigFolder() {
        return this.configFolder;
    }

    protected String getLogCat() {
        return this.getFullName();
    }

    protected IPSSystemLogger getLogger() {
        return this.getPSModelEngineHolder().getPSSystemLogger();
    }

    protected IPSSystemUtil getUtil() {
        return this.getPSModelEngineHolder().getPSSystemUtil();
    }
}

