/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.engine.res;

import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.PSModelEngineBase;
import net.ibizsys.model.engine.PSModelEngineException;
import net.ibizsys.model.engine.res.IPSSysSFPluginEngine;
import net.ibizsys.model.res.IPSSysSFPlugin;
import net.ibizsys.model.system.IPSSystemModule;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public abstract class PSSysSFPluginEngineBase<X extends IPSSysSFPlugin>
extends PSModelEngineBase<X>
implements IPSSysSFPluginEngine<X> {
    private static final Log log = LogFactory.getLog(PSSysSFPluginEngineBase.class);
    private boolean runtimePlugin = false;
    private String rtObjectName = null;
    private String rtObjectCode = null;
    private Object runtimeObject = null;

    @Override
    public void init(IPSModelEngineHolder iPSModelEngineContext, String id, X iPSModelObject) throws Exception {
        this.setConfigFolder("syssfplugin." + PSModelUtils.calcUniqueTag((IPSSystemModule)iPSModelObject.getPSSystemModule(), (String)iPSModelObject.getPluginCode()));
        super.init(iPSModelEngineContext, id, iPSModelObject);
    }

    @Override
    protected void onPrepareSetting() throws Exception {
        this.setRuntimePlugin(((IPSSysSFPlugin)this.getPSModelObject()).isRuntimeObject());
        this.setRTObjectName(((IPSSysSFPlugin)this.getPSModelObject()).getRTObjectName());
        super.onPrepareSetting();
    }

    @Override
    public boolean isRuntimePlugin() {
        return this.runtimePlugin;
    }

    protected void setRuntimePlugin(boolean runtimePlugin) {
        this.runtimePlugin = runtimePlugin;
    }

    @Override
    public String getRTObjectName() {
        return this.rtObjectName;
    }

    protected void setRTObjectName(String rtObjectName) {
        this.rtObjectName = rtObjectName;
    }

    protected abstract Class<?> getRTObjectClass();

    @Override
    public <T> T getRuntimeObject(Class<T> cls, boolean bNewInstance) throws Exception {
        if (!this.isRuntimePlugin()) {
            throw new PSModelEngineException(this, String.format("\u7cfb\u7edf\u540e\u53f0\u63d2\u4ef6[%1$s]\u4e0d\u63d0\u4f9b\u8fd0\u884c\u65f6\u7ec4\u4ef6", this.getName()));
        }
        Class<?> rtObjectClass = this.getRTObjectClass();
        if (!cls.isAssignableFrom(rtObjectClass)) {
            throw new PSModelEngineException(this, String.format("\u7cfb\u7edf\u540e\u53f0\u63d2\u4ef6[%1$s]\u4e0d\u652f\u6301\u6307\u5b9a\u7c7b\u578b[%2$s]", this.getName(), cls.getCanonicalName()));
        }
        if (bNewInstance) {
            Object objItem = rtObjectClass.newInstance();
            return (T)objItem;
        }
        if (this.runtimeObject == null) {
            Object objItem = rtObjectClass.newInstance();
            this.runtimeObject = objItem;
        }
        return (T)this.runtimeObject;
    }

    @Override
    public Object getRuntimeObject(boolean bNewInstance) throws Exception {
        if (!this.isRuntimePlugin()) {
            throw new PSModelEngineException(this, String.format("\u7cfb\u7edf\u540e\u53f0\u63d2\u4ef6[%1$s]\u4e0d\u63d0\u4f9b\u8fd0\u884c\u65f6\u7ec4\u4ef6", this.getName()));
        }
        Class<?> rtObjectClass = this.getRTObjectClass();
        if (bNewInstance) {
            Object objItem = rtObjectClass.newInstance();
            return objItem;
        }
        if (this.runtimeObject == null) {
            Object objItem = rtObjectClass.newInstance();
            this.runtimeObject = objItem;
        }
        return this.runtimeObject;
    }

    @Override
    public String getRTObjectCode() {
        if (StringUtils.hasLength((String)this.rtObjectCode)) {
            return this.rtObjectCode;
        }
        return ((IPSSysSFPlugin)this.getPSModelObject()).getTemplCode();
    }

    protected void setRTObjectCode(String rtObjectCode) {
        this.rtObjectCode = rtObjectCode;
    }
}

