/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.engine.eai;

import java.util.Arrays;
import java.util.List;
import net.ibizsys.model.PSModelUtils;
import net.ibizsys.model.engine.IPSModelEngineHolder;
import net.ibizsys.model.engine.PSModelEngineException;
import net.ibizsys.model.engine.eai.IPSSysDataSyncAgentEngine;
import net.ibizsys.model.engine.service.PSSubSysServiceAPIEngineBaseBase;
import net.ibizsys.model.res.IPSSysDataSyncAgent;
import net.ibizsys.model.system.IPSSystemModule;
import org.springframework.util.StringUtils;

public abstract class PSSysDataSyncAgentEngineBase<M extends IPSSysDataSyncAgent>
extends PSSubSysServiceAPIEngineBaseBase<M>
implements IPSSysDataSyncAgentEngine<M> {
    private List<String> topics = null;
    private String defaultTopic = null;
    private String groupId = null;
    private boolean transacted = false;
    private String agentType = null;
    private boolean groupIdDefined = false;

    @Override
    public void init(IPSModelEngineHolder iPSModelEngineContext, String id, M iPSModelObject) throws Exception {
        this.setConfigFolder("syseaiagent." + PSModelUtils.calcUniqueTag((IPSSystemModule)iPSModelObject.getPSSystemModule(), (String)iPSModelObject.getCodeName()));
        super.init(iPSModelEngineContext, id, iPSModelObject);
    }

    @Override
    protected void onInit() throws Exception {
        this.setAgentType(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".agenttype", this.getPSSysDataSyncAgent().getAgentType()));
        String strTopic = this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".topic", this.getPSSysDataSyncAgent().getTopic());
        if (!StringUtils.hasLength((String)strTopic) && StringUtils.hasLength((String)this.getPSSysDataSyncAgent().getCodeName())) {
            strTopic = this.getPSSysDataSyncAgent().getCodeName().toLowerCase();
        }
        if (StringUtils.hasLength((String)strTopic)) {
            String[] topics = strTopic.split("[;]");
            this.setTopics(Arrays.asList(topics));
            this.setDefaultTopic(topics[0]);
        }
        this.setGroupId(this.getPSModelEngineHolder().getParam(this.getConfigFolder() + ".groupid", this.getPSSysDataSyncAgent().getGroupId()));
        super.onInit();
    }

    public IPSSysDataSyncAgent getPSSysDataSyncAgent() {
        return (IPSSysDataSyncAgent)this.getPSModelObject();
    }

    @Override
    public void send(Object[] data) {
        throw new PSModelEngineException(this, "\u6ca1\u6709\u5b9e\u73b0");
    }

    @Override
    public boolean isRawDataMode() {
        return false;
    }

    public List<String> getTopics() {
        return this.topics;
    }

    protected void setTopics(List<String> topics) {
        this.topics = topics;
    }

    public String getDefaultTopic() {
        return this.defaultTopic;
    }

    protected void setDefaultTopic(String defaultTopic) {
        this.defaultTopic = defaultTopic;
    }

    public String getGroupId() {
        return this.groupId;
    }

    protected void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public boolean isGroupIdDefined() {
        return this.groupIdDefined;
    }

    protected void setGroupIdDefined(boolean groupIdDefined) {
        this.groupIdDefined = groupIdDefined;
    }

    public boolean isTransacted() {
        return this.transacted;
    }

    public void setTransacted(boolean transacted) {
        this.transacted = transacted;
    }

    protected void setAgentType(String agentType) {
        this.agentType = agentType;
    }

    public String getAgentType() {
        return this.agentType;
    }
}

