/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.engine.dataentity.logic;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.logic.IPSDELogicLink;
import net.ibizsys.model.dataentity.logic.IPSDELogicNode;
import net.ibizsys.model.dataentity.logic.IPSDELogicNodeParam;
import net.ibizsys.model.dataentity.logic.IPSDELogicParam;
import net.ibizsys.model.engine.dataentity.logic.IPSDELogicEngine;
import net.ibizsys.model.engine.dataentity.logic.IPSDELogicParamAddin;
import net.ibizsys.model.engine.dataentity.logic.IPSDELogicSession;
import net.ibizsys.model.engine.dataentity.logic.PSDELogicSession;
import net.ibizsys.model.engine.security.SecurityContextHolder;
import net.ibizsys.model.util.DateUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.ObjectUtils;

public abstract class PSDELogicSessionBase
implements IPSDELogicSession {
    private static final Log log = LogFactory.getLog(PSDELogicSession.class);
    private Map<String, Object> paramMap = new HashMap<String, Object>();
    private Object result = null;
    private Object lastReturn = null;
    private IPSDELogicEngine iPSDELogicEngine = null;
    private List debugData = null;
    private int debugMode;

    public PSDELogicSessionBase(IPSDELogicEngine iPSDELogicEngine) {
        this.debugMode = PSModelEnums.DELogicDebugMode.NONE.value;
        this.iPSDELogicEngine = iPSDELogicEngine;
        this.setDebugMode(iPSDELogicEngine.getPSDELogic().getDebugMode());
        this.debugData = new ArrayList();
    }

    @Override
    public IPSDELogicEngine getPSDELogicEngine() {
        return this.iPSDELogicEngine;
    }

    @Override
    public int getDebugMode() {
        return this.debugMode;
    }

    protected void setDebugMode(int debugMode) {
        this.debugMode = debugMode;
    }

    @Override
    public boolean isOutputDebugInfo() {
        return this.getDebugMode() == PSModelEnums.DELogicDebugMode.INFO.value;
    }

    @Override
    public Object getParam(String strName) throws Exception {
        return this.getParam(strName, false);
    }

    @Override
    public void setParam(String strName, Object object) {
        this.paramMap.put(strName, object);
    }

    @Override
    public Object getParam(String strName, boolean bTryMode) throws Exception {
        Object obj = this.paramMap.get(strName);
        if (obj != null || bTryMode) {
            return obj;
        }
        throw new Exception(String.format("\u672a\u5b58\u5728\u6307\u5b9a\u53c2\u6570[%1$s]", strName));
    }

    @Override
    public Object getResult() {
        return this.result;
    }

    @Override
    public void setResult(Object result) {
        this.result = result;
    }

    @Override
    public Object getLastReturn() {
        return this.lastReturn;
    }

    @Override
    public void setLastReturn(Object lastReturn) {
        this.lastReturn = lastReturn;
    }

    @Override
    public void debugEnterNode(IPSDELogicNode iPSDELogicNode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("\u8fdb\u5165\u8282\u70b9[%1$s]", iPSDELogicNode.getName()));
        }
        if (this.getDebugData() == null) {
            return;
        }
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        data.put("type", "enternode");
        data.put("time", DateUtils.getCurTimeString2());
        data.put("name", iPSDELogicNode.getName());
        data.put("codeName", iPSDELogicNode.getCodeName());
        this.getDebugData().add(data);
    }

    @Override
    public void debugExitNode(IPSDELogicNode iPSDELogicNode) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("\u79bb\u5f00\u8282\u70b9[%1$s]", iPSDELogicNode.getName()));
        }
        if (this.getDebugData() == null) {
            return;
        }
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        data.put("type", "exitnode");
        data.put("time", DateUtils.getCurTimeString2());
        data.put("name", iPSDELogicNode.getName());
        data.put("codeName", iPSDELogicNode.getCodeName());
        this.getDebugData().add(data);
    }

    @Override
    public void debugEnterLink(IPSDELogicNode iPSDELogicNode, IPSDELogicLink iPSDELogicLink) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("\u8fdb\u5165\u8fde\u63a5[%1$s@%2$s]", iPSDELogicLink.getName(), iPSDELogicNode.getName()));
        }
        if (this.getDebugData() == null) {
            return;
        }
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        data.put("type", "enterlink");
        data.put("time", DateUtils.getCurTimeString2());
        data.put("name", String.format("%1$s@%2$s", iPSDELogicLink.getName(), iPSDELogicNode.getName()));
        this.getDebugData().add(data);
    }

    @Override
    public void debugParam(IPSDELogicParam iPSDELogicParam) {
        if (this.getDebugData() == null) {
            return;
        }
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("type", "debugparam");
        data.put("time", DateUtils.getCurTimeString2());
        IPSDELogicParamAddin iPSDELogicParamAddin = this.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicParam.getCodeName(), false);
        iPSDELogicParamAddin.debug(this, data);
        this.getDebugData().add(data);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("\u8f93\u51fa\u53c2\u6570[%1$s]\r\n%2$s", iPSDELogicParamAddin.getName(), data));
        }
    }

    @Override
    public void debugInfo(String strInfo) {
        if (log.isDebugEnabled()) {
            log.debug((Object)strInfo);
        }
        if (this.getDebugData() == null) {
            return;
        }
        LinkedHashMap<String, String> data = new LinkedHashMap<String, String>();
        data.put("type", "debuginfo");
        data.put("time", DateUtils.getCurTimeString2());
        data.put("info", strInfo);
        this.getDebugData().add(data);
    }

    @Override
    public List getDebugData() {
        return this.debugData;
    }

    @Override
    public Object getNodeParamValue(IPSDELogicNodeParam iPSDELogicNodeParam) throws Exception {
        if (PSModelEnums.DELogicParamValueType.SRCDLPARAM.value.equals(iPSDELogicNodeParam.getSrcValueType())) {
            IPSDELogicParamAddin srcPSDELogicParamAddin = this.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName(), false);
            if (ObjectUtils.isEmpty((Object)iPSDELogicNodeParam.getSrcFieldName())) {
                return srcPSDELogicParamAddin.getValue(this);
            }
            return srcPSDELogicParamAddin.get(this, iPSDELogicNodeParam.getSrcFieldName().toLowerCase());
        }
        if (PSModelEnums.DELogicParamValueType.NULLVALUE.value.equals(iPSDELogicNodeParam.getSrcValueType())) {
            return null;
        }
        if (PSModelEnums.DELogicParamValueType.SRCVALUE.value.equals(iPSDELogicNodeParam.getSrcValueType())) {
            return iPSDELogicNodeParam.getSrcValue();
        }
        if (PSModelEnums.DELogicParamValueType.SESSION.value.equals(iPSDELogicNodeParam.getSrcValueType())) {
            if (ObjectUtils.isEmpty((Object)iPSDELogicNodeParam.getSrcFieldName())) {
                throw new Exception(String.format("\u5904\u7406\u8282\u70b9\u53c2\u6570[%1$s]\u672a\u6307\u5b9a\u6e90\u5c5e\u6027\u540d\u79f0", iPSDELogicNodeParam.getName()));
            }
            if (SecurityContextHolder.getCurrent() == null) {
                throw new Exception(String.format("\u5b89\u5168\u4e0a\u4e0b\u6587\u5bf9\u8c61\u65e0\u6548", new Object[0]));
            }
            return SecurityContextHolder.getCurrent().getSessionValue(iPSDELogicNodeParam.getSrcFieldName());
        }
        if (PSModelEnums.DELogicParamValueType.APPLICATION.value.equals(iPSDELogicNodeParam.getSrcValueType())) {
            if (ObjectUtils.isEmpty((Object)iPSDELogicNodeParam.getSrcFieldName())) {
                throw new Exception(String.format("\u5904\u7406\u8282\u70b9\u53c2\u6570[%1$s]\u672a\u6307\u5b9a\u6e90\u5c5e\u6027\u540d\u79f0", iPSDELogicNodeParam.getName()));
            }
            throw new Exception(String.format("\u6ca1\u6709\u5b9e\u73b0", new Object[0]));
        }
        if (PSModelEnums.DELogicParamValueType.EXPRESSION.value.equals(iPSDELogicNodeParam.getSrcValueType())) {
            throw new Exception("\u6ca1\u6709\u5b9e\u73b0");
        }
        if (PSModelEnums.DELogicParamValueType.COUNT.value.equals(iPSDELogicNodeParam.getSrcValueType())) {
            IPSDELogicParamAddin srcPSDELogicParamAddin = this.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName(), false);
            return srcPSDELogicParamAddin.count(this);
        }
        if (PSModelEnums.DELogicParamValueType.AGGREGATION.value.equals(iPSDELogicNodeParam.getSrcValueType())) {
            IPSDELogicParamAddin srcPSDELogicParamAddin = this.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName(), false);
            if (ObjectUtils.isEmpty((Object)iPSDELogicNodeParam.getSrcFieldName())) {
                throw new Exception(String.format("\u5904\u7406\u8282\u70b9\u53c2\u6570[%1$s]\u672a\u6307\u5b9a\u6e90\u5c5e\u6027\u540d\u79f0", iPSDELogicNodeParam.getName()));
            }
            if (ObjectUtils.isEmpty((Object)iPSDELogicNodeParam.getAggMode())) {
                throw new Exception(String.format("\u5904\u7406\u8282\u70b9\u53c2\u6570[%1$s]\u672a\u6307\u5b9a\u805a\u5408\u6a21\u5f0f", iPSDELogicNodeParam.getName()));
            }
            return srcPSDELogicParamAddin.aggregate(this, iPSDELogicNodeParam.getSrcFieldName(), iPSDELogicNodeParam.getAggMode());
        }
        throw new Exception(String.format("\u5904\u7406\u8282\u70b9\u53c2\u6570[%1$s]\u6e90\u503c\u7c7b\u578b[%2$s]\u672a\u652f\u6301", iPSDELogicNodeParam.getName(), iPSDELogicNodeParam.getSrcValueType()));
    }

    @Override
    public Object getLogicParamValue(String strLogicParamCodeName) throws Exception {
        IPSDELogicParamAddin iPSDELogicParamAddin = this.getPSDELogicEngine().getPSDELogicParamAddin(strLogicParamCodeName, false);
        return iPSDELogicParamAddin.getValue(this);
    }

    @Override
    public Object getParam(IPSDELogicParam iPSDELogicParam) throws Exception {
        String name = String.format("_LogicParam_%1$s", iPSDELogicParam.getCodeName());
        return this.getParam(name);
    }

    @Override
    public void setParam(IPSDELogicParam iPSDELogicParam, Object value) {
        String name = String.format("_LogicParam_%1$s", iPSDELogicParam.getCodeName());
        this.setParam(name, value);
    }

    @Override
    public Object getParam(IPSDELogicParam iPSDELogicParam, boolean tryMode) throws Exception {
        String name = String.format("_LogicParam_%1$s", iPSDELogicParam.getCodeName());
        return this.getParam(name, tryMode);
    }
}

