/*
 * Decompiled with CFR 0.152.
 */
package net.ibizsys.model.engine.dataentity.logic;

import java.util.List;
import net.ibizsys.model.IPSModelObject;
import net.ibizsys.model.PSModelEnums;
import net.ibizsys.model.dataentity.logic.IPSDELogicNode;
import net.ibizsys.model.dataentity.logic.IPSDELogicNodeParam;
import net.ibizsys.model.engine.dataentity.logic.IPSDELogicEngine;
import net.ibizsys.model.engine.dataentity.logic.IPSDELogicParamAddin;
import net.ibizsys.model.engine.dataentity.logic.IPSDELogicSession;
import net.ibizsys.model.engine.dataentity.logic.PSDELogicNodeAddinBase;
import net.ibizsys.model.engine.res.IPSSysTranslatorEngine;
import net.ibizsys.model.res.IPSSysTranslator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.StringUtils;

public class PSDELogicPrepareParamNodeAddin
extends PSDELogicNodeAddinBase<IPSDELogicEngine<?>, IPSDELogicNode> {
    private static final Log log = LogFactory.getLog(PSDELogicPrepareParamNodeAddin.class);

    @Override
    protected void onExecute(IPSDELogicSession iPSDELogicSession) throws Throwable {
        List psDELogicNodeParamList = this.getPSDELogicNode().getPSDELogicNodeParams();
        if (psDELogicNodeParamList == null || psDELogicNodeParamList.size() == 0) {
            return;
        }
        for (IPSDELogicNodeParam iPSDELogicNodeParam : psDELogicNodeParamList) {
            String strParamAction = iPSDELogicNodeParam.getParamAction();
            if (PSModelEnums.DELogicNodeParamType.SETPARAMVALUE.value.equals(strParamAction)) {
                this.onSetParamValue(iPSDELogicSession, iPSDELogicNodeParam);
                continue;
            }
            if (PSModelEnums.DELogicNodeParamType.RESETPARAM.value.equals(strParamAction)) {
                this.onResetParam(iPSDELogicSession, iPSDELogicNodeParam);
                continue;
            }
            if (PSModelEnums.DELogicNodeParamType.COPYPARAM.value.equals(strParamAction)) continue;
            if (PSModelEnums.DELogicNodeParamType.BINDPARAM.value.equals(strParamAction)) {
                this.onBindParam(iPSDELogicSession, iPSDELogicNodeParam);
                continue;
            }
            if (PSModelEnums.DELogicNodeParamType.RENEWPARAM.value.equals(strParamAction)) {
                this.onRenewParam(iPSDELogicSession, iPSDELogicNodeParam);
                continue;
            }
            if (PSModelEnums.DELogicNodeParamType.APPENDPARAM.value.equals(strParamAction)) {
                this.onAppendParam(iPSDELogicSession, iPSDELogicNodeParam);
                continue;
            }
            if (PSModelEnums.DELogicNodeParamType.SORTPARAM.value.equals(strParamAction)) {
                this.onSortParam(iPSDELogicSession, iPSDELogicNodeParam);
                continue;
            }
            log.warn((Object)String.format("\u672a\u652f\u6301\u7684\u53c2\u6570\u8bbe\u7f6e\u64cd\u4f5c[%1$s]", strParamAction));
            if (!iPSDELogicSession.isOutputDebugInfo()) continue;
            iPSDELogicSession.debugInfo(String.format("\u672a\u652f\u6301\u7684\u53c2\u6570\u8bbe\u7f6e\u64cd\u4f5c[%1$s]", strParamAction));
        }
    }

    protected void onCopyParam(IPSDELogicSession iPSDELogicSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
        IPSDELogicParamAddin srcDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName(), false);
        IPSDELogicParamAddin dstDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
        srcDELogicParamRuntime.copyTo(iPSDELogicSession, dstDELogicParamRuntime.getValue(iPSDELogicSession));
        if (iPSDELogicSession.isOutputDebugInfo()) {
            iPSDELogicSession.debugInfo(String.format("\u62f7\u8d1d\u53c2\u6570[%1$s] ==> %2$s", srcDELogicParamRuntime.getCodeName(), dstDELogicParamRuntime.getCodeName()));
        }
    }

    protected void onBindParam(IPSDELogicSession iPSDELogicSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
        IPSSysTranslator iPSSysTranslator;
        IPSDELogicParamAddin srcDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName(), false);
        IPSDELogicParamAddin dstDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
        String strSrcFieldName = iPSDELogicNodeParam.getSrcFieldName();
        Object objValue = null;
        if (StringUtils.hasLength((String)strSrcFieldName)) {
            objValue = srcDELogicParamRuntime.get(iPSDELogicSession, strSrcFieldName);
            if (iPSDELogicSession.isOutputDebugInfo()) {
                iPSDELogicSession.debugInfo(String.format("\u6e90\u53c2\u6570[%1$s]\u5c5e\u6027[%2$s] ==> %3$s", srcDELogicParamRuntime.getCodeName(), strSrcFieldName, objValue));
            }
        } else {
            objValue = srcDELogicParamRuntime.getValue(iPSDELogicSession);
            if (iPSDELogicSession.isOutputDebugInfo()) {
                iPSDELogicSession.debugInfo(String.format("\u6e90\u53c2\u6570[%1$s] ==> %2$s", srcDELogicParamRuntime.getCodeName(), objValue));
            }
        }
        if ((iPSSysTranslator = iPSDELogicNodeParam.getPSSysTranslator()) != null) {
            IPSSysTranslatorEngine iPSSysTranslatorEngine = this.getPSModelEngineHolder().getPSModelEngine((IPSModelObject)iPSSysTranslator, IPSSysTranslatorEngine.class);
            objValue = iPSSysTranslatorEngine.translate(objValue, !iPSDELogicNodeParam.isOutTranslate());
            if (iPSDELogicSession.isOutputDebugInfo()) {
                iPSDELogicSession.debugInfo(String.format("\u8f6c\u6362\u5668[%1$s]\u503c\u8f93\u5165\u8f6c\u6362 ==> %2$s", iPSSysTranslatorEngine.getName(), objValue));
            }
        }
        dstDELogicParamRuntime.bind(iPSDELogicSession, objValue);
        if (iPSDELogicSession.isOutputDebugInfo()) {
            iPSDELogicSession.debugInfo(String.format("\u7ed1\u5b9a\u53c2\u6570[%1$s] <== %2$s", dstDELogicParamRuntime.getCodeName(), objValue));
        }
    }

    protected void onRenewParam(IPSDELogicSession iPSDELogicSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
        IPSDELogicParamAddin dstDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
        dstDELogicParamRuntime.renew(iPSDELogicSession);
        if (iPSDELogicSession.isOutputDebugInfo()) {
            iPSDELogicSession.debugInfo(String.format("\u91cd\u5efa\u53c2\u6570[%1$s]", dstDELogicParamRuntime.getCodeName()));
        }
    }

    protected void onResetParam(IPSDELogicSession iPSDELogicSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
        IPSDELogicParamAddin dstDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
        dstDELogicParamRuntime.resetAll(iPSDELogicSession);
        if (iPSDELogicSession.isOutputDebugInfo()) {
            iPSDELogicSession.debugInfo(String.format("\u91cd\u7f6e\u53c2\u6570[%1$s]", dstDELogicParamRuntime.getCodeName()));
        }
    }

    protected void onSetParamValue(IPSDELogicSession iPSDELogicSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
        IPSSysTranslator iPSSysTranslator;
        IPSDELogicParamAddin dstDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
        if (!StringUtils.hasLength((String)iPSDELogicNodeParam.getDstFieldName())) {
            throw new Exception(String.format("\u5904\u7406\u8282\u70b9\u53c2\u6570[%1$s]\u672a\u6307\u5b9a\u8bbe\u7f6e\u76ee\u6807\u5c5e\u6027", iPSDELogicNodeParam.getName()));
        }
        if (PSModelEnums.DELogicParamValueType.NONEVALUE.value.equals(iPSDELogicNodeParam.getSrcValueType())) {
            dstDELogicParamRuntime.reset(iPSDELogicSession, iPSDELogicNodeParam.getDstFieldName().toLowerCase());
            if (iPSDELogicSession.isOutputDebugInfo()) {
                iPSDELogicSession.debugInfo(String.format("\u91cd\u7f6e\u53c2\u6570[%1$s]\u5c5e\u6027[%2$s]", dstDELogicParamRuntime.getCodeName(), iPSDELogicNodeParam.getDstFieldName()));
            }
            return;
        }
        Object objValue = this.calcPSDELogicNodeParamValue(iPSDELogicSession, iPSDELogicNodeParam);
        if (iPSDELogicSession.isOutputDebugInfo()) {
            iPSDELogicSession.debugInfo(String.format("\u8ba1\u7b97\u8282\u70b9\u53c2\u6570[%1$s] ==> %2$s", iPSDELogicNodeParam.getName(), objValue));
        }
        if ((iPSSysTranslator = iPSDELogicNodeParam.getPSSysTranslator()) != null) {
            IPSSysTranslatorEngine iPSSysTranslatorEngine = this.getPSModelEngineHolder().getPSModelEngine((IPSModelObject)iPSSysTranslator, IPSSysTranslatorEngine.class);
            objValue = iPSSysTranslatorEngine.translate(objValue, !iPSDELogicNodeParam.isOutTranslate());
            if (iPSDELogicSession.isOutputDebugInfo()) {
                iPSDELogicSession.debugInfo(String.format("\u8f6c\u6362\u5668[%1$s]\u503c\u8f93\u5165\u8f6c\u6362 ==> %2$s", iPSSysTranslatorEngine.getName(), objValue));
            }
        }
        dstDELogicParamRuntime.set(iPSDELogicSession, iPSDELogicNodeParam.getDstFieldName().toLowerCase(), objValue);
        if (iPSDELogicSession.isOutputDebugInfo()) {
            iPSDELogicSession.debugInfo(String.format("\u8bbe\u7f6e\u53c2\u6570[%1$s]\u5c5e\u6027[%2$s] <== %3$s", dstDELogicParamRuntime.getCodeName(), iPSDELogicNodeParam.getDstFieldName(), objValue));
        }
    }

    protected void onAppendParam(IPSDELogicSession iPSDELogicSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
        IPSSysTranslator iPSSysTranslator;
        IPSDELogicParamAddin dstDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
        IPSDELogicParamAddin srcDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getSrcPSDELogicParamMust().getCodeName(), false);
        String strSrcFieldName = iPSDELogicNodeParam.getSrcFieldName();
        Object objValue = null;
        if (StringUtils.hasLength((String)strSrcFieldName)) {
            objValue = srcDELogicParamRuntime.get(iPSDELogicSession, strSrcFieldName);
            if (iPSDELogicSession.isOutputDebugInfo()) {
                iPSDELogicSession.debugInfo(String.format("\u6e90\u53c2\u6570[%1$s]\u5c5e\u6027[%2$s] ==> %3$s", srcDELogicParamRuntime.getCodeName(), strSrcFieldName, objValue));
            }
        } else {
            objValue = srcDELogicParamRuntime.getValue(iPSDELogicSession);
            if (iPSDELogicSession.isOutputDebugInfo()) {
                iPSDELogicSession.debugInfo(String.format("\u6e90\u53c2\u6570[%1$s] ==> %2$s", srcDELogicParamRuntime.getCodeName(), objValue));
            }
        }
        if ((iPSSysTranslator = iPSDELogicNodeParam.getPSSysTranslator()) != null) {
            IPSSysTranslatorEngine iPSSysTranslatorEngine = this.getPSModelEngineHolder().getPSModelEngine((IPSModelObject)iPSSysTranslator, IPSSysTranslatorEngine.class);
            objValue = iPSSysTranslatorEngine.translate(objValue, !iPSDELogicNodeParam.isOutTranslate());
            if (iPSDELogicSession.isOutputDebugInfo()) {
                iPSDELogicSession.debugInfo(String.format("\u8f6c\u6362\u5668[%1$s]\u503c\u8f93\u5165\u8f6c\u6362 ==> %2$s", iPSSysTranslatorEngine.getName(), objValue));
            }
        }
        dstDELogicParamRuntime.append(iPSDELogicSession, iPSDELogicNodeParam.getDstIndex(), objValue, iPSDELogicNodeParam.getSrcIndex(), iPSDELogicNodeParam.getSrcSize());
        if (iPSDELogicSession.isOutputDebugInfo()) {
            if (iPSDELogicNodeParam.getSrcIndex() >= 0) {
                iPSDELogicSession.debugInfo(String.format("\u9644\u52a0\u6570\u7ec4\u53c2\u6570[%1$s][%2$s] <== %3$s{%4$s, %5$s}", dstDELogicParamRuntime.getCodeName(), iPSDELogicNodeParam.getDstIndex(), objValue, iPSDELogicNodeParam.getSrcIndex(), iPSDELogicNodeParam.getSrcSize()));
            } else {
                iPSDELogicSession.debugInfo(String.format("\u9644\u52a0\u6570\u7ec4\u53c2\u6570[%1$s][%2$s] <== %3$s", dstDELogicParamRuntime.getCodeName(), iPSDELogicNodeParam.getDstIndex(), objValue));
            }
        }
    }

    protected void onSortParam(IPSDELogicSession iPSDELogicSession, IPSDELogicNodeParam iPSDELogicNodeParam) throws Throwable {
        IPSDELogicParamAddin dstDELogicParamRuntime = iPSDELogicSession.getPSDELogicEngine().getPSDELogicParamAddin(iPSDELogicNodeParam.getDstPSDELogicParamMust().getCodeName(), false);
        String strDstFieldName = iPSDELogicNodeParam.getDstFieldName();
        if (!StringUtils.hasLength((String)iPSDELogicNodeParam.getDstFieldName())) {
            throw new Exception(String.format("\u5904\u7406\u8282\u70b9\u53c2\u6570[%1$s]\u672a\u6307\u5b9a\u8bbe\u7f6e\u6392\u5e8f\u5c5e\u6027", iPSDELogicNodeParam.getName()));
        }
        dstDELogicParamRuntime.sort(iPSDELogicSession, strDstFieldName, iPSDELogicNodeParam.getDstSortDir());
        if (iPSDELogicSession.isOutputDebugInfo()) {
            iPSDELogicSession.debugInfo(String.format("\u6392\u5e8f\u6570\u7ec4\u53c2\u6570[%1$s] <== %2$s, %3$s", dstDELogicParamRuntime.getCodeName(), strDstFieldName, iPSDELogicNodeParam.getDstSortDir()));
        }
    }
}

